/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.world.decoration;

import com.mojang.serialization.Codec;
import java.util.BitSet;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;

public class MapGenLargeCrystal
extends WorldCarver<ProbabilityConfig> {
    BlockState fillerBlock;
    BlockState crystalBlock;

    public MapGenLargeCrystal(Codec<ProbabilityConfig> codec, int chancePerChunk, BlockState fillerBlock, BlockState blockCrystal) {
        super(codec, chancePerChunk);
        this.fillerBlock = fillerBlock;
        this.crystalBlock = blockCrystal;
    }

    public void setFillerBlock(BlockState fillerBlock) {
        this.fillerBlock = fillerBlock;
    }

    public void setCrystalBlock(BlockState crystalBlock) {
        this.crystalBlock = crystalBlock;
    }

    public boolean carveRegion(IChunk blocks, Function func, Random rand, int p_225555_4_, int chunkX, int chunkZ, int rangeX, int rangeZ, BitSet carvingMask, ProbabilityConfig config) {
        int yOff;
        int xOff;
        int zOff;
        int x = 16 * (-chunkX + rangeX);
        int z = 16 * (-chunkZ + rangeZ);
        BlockState state = this.fillerBlock;
        Block fillerBlock = state.func_177230_c();
        int height = rand.nextInt(40) + 10;
        int edgeRadius = rand.nextInt(4) + 2;
        int numDiag = edgeRadius + 1;
        int xShear = 1 - (rand.nextInt(6) + 3) / 4;
        int zShear = 1 - (rand.nextInt(6) + 3) / 4;
        BlockState usedState = AdvancedRocketryBlocks.crystalBlocks[rand.nextInt(AdvancedRocketryBlocks.crystalBlocks.length)].func_176223_P();
        float SHAPE = 0.01f + rand.nextFloat() * 0.2f;
        int y = 80;
        int currentEdgeRadius = (int)(SHAPE * (float)(edgeRadius * height) + (1.0f - SHAPE) * (float)edgeRadius);
        for (zOff = -numDiag - currentEdgeRadius / 2; zOff <= -currentEdgeRadius / 2; ++zOff) {
            for (xOff = -numDiag - currentEdgeRadius / 2; xOff <= numDiag + currentEdgeRadius / 2; ++xOff) {
                for (yOff = this.getHeightValue(x + xOff, z + zOff, blocks); yOff < y; ++yOff) {
                    this.setBlock(x + xOff, yOff, z + zOff, usedState, blocks);
                }
                this.setBlock(x + xOff, y, z + zOff, fillerBlock.func_176223_P(), blocks);
            }
            ++currentEdgeRadius;
        }
        for (zOff = -currentEdgeRadius / 2; zOff <= currentEdgeRadius / 2; ++zOff) {
            for (xOff = -numDiag - currentEdgeRadius / 2; xOff <= numDiag + currentEdgeRadius / 2; ++xOff) {
                for (yOff = this.getHeightValue(x + xOff, z + zOff, blocks); yOff < y; ++yOff) {
                    this.setBlock(x + xOff, yOff, z + zOff, fillerBlock.func_176223_P(), blocks);
                }
                this.setBlock(x + xOff, y, z + zOff, fillerBlock.func_176223_P(), blocks);
            }
        }
        for (zOff = currentEdgeRadius / 2; zOff <= numDiag + currentEdgeRadius / 2; ++zOff) {
            for (xOff = -numDiag - --currentEdgeRadius / 2; xOff <= numDiag + currentEdgeRadius / 2; ++xOff) {
                for (yOff = this.getHeightValue(x + xOff, z + zOff, blocks); yOff < y; ++yOff) {
                    this.setBlock(x + xOff, yOff, z + zOff, fillerBlock.func_176223_P(), blocks);
                }
                this.setBlock(x + xOff, y, z + zOff, fillerBlock.func_176223_P(), blocks);
            }
        }
        ++y;
        for (int yOff2 = 0; yOff2 < height; ++yOff2) {
            int xOff2;
            int zOff2;
            currentEdgeRadius = (int)(SHAPE * (float)(edgeRadius * (height - yOff2)) + (1.0f - SHAPE) * (float)edgeRadius);
            for (zOff2 = -numDiag - currentEdgeRadius / 2; zOff2 <= -currentEdgeRadius / 2; ++zOff2) {
                for (xOff2 = -numDiag - currentEdgeRadius / 2; xOff2 <= numDiag + currentEdgeRadius / 2; ++xOff2) {
                    this.setBlock(x + xOff2 + xShear * yOff2, y + yOff2, z + zOff2 + zShear * yOff2, usedState, blocks);
                }
                ++currentEdgeRadius;
            }
            for (zOff2 = -currentEdgeRadius / 2; zOff2 <= currentEdgeRadius / 2; ++zOff2) {
                for (xOff2 = -numDiag - currentEdgeRadius / 2; xOff2 <= numDiag + currentEdgeRadius / 2; ++xOff2) {
                    this.setBlock(x + xOff2 + xShear * yOff2, y + yOff2, z + zOff2 + zShear * yOff2, usedState, blocks);
                }
            }
            for (zOff2 = currentEdgeRadius / 2; zOff2 <= numDiag + currentEdgeRadius / 2; ++zOff2) {
                for (xOff2 = -numDiag - --currentEdgeRadius / 2; xOff2 <= numDiag + currentEdgeRadius / 2; ++xOff2) {
                    this.setBlock(x + xOff2 + xShear * yOff2, y + yOff2, z + zOff2 + zShear * yOff2, usedState, blocks);
                }
            }
        }
        currentEdgeRadius = (int)(SHAPE * (float)(edgeRadius * height) + (1.0f - SHAPE) * (float)edgeRadius);
        for (zOff = -numDiag - currentEdgeRadius / 2; zOff <= -currentEdgeRadius / 2; ++zOff) {
            for (xOff = -currentEdgeRadius / 2; xOff <= currentEdgeRadius / 2; ++xOff) {
                if (rand.nextInt(3) >= 1) continue;
                this.setBlock(x + xOff, y, z + zOff, state, blocks);
            }
            ++currentEdgeRadius;
        }
        for (zOff = -currentEdgeRadius / 2; zOff <= currentEdgeRadius / 2; ++zOff) {
            for (xOff = -currentEdgeRadius / 2; xOff <= currentEdgeRadius / 2; ++xOff) {
                if (rand.nextInt(3) >= 1) continue;
                this.setBlock(x + xOff, y, z + zOff, state, blocks);
            }
        }
        for (zOff = currentEdgeRadius / 2; zOff <= numDiag + currentEdgeRadius / 2; ++zOff) {
            for (xOff = -(--currentEdgeRadius) / 2; xOff <= currentEdgeRadius / 2; ++xOff) {
                if (rand.nextInt(3) >= 1) continue;
                this.setBlock(x + xOff, y, z + zOff, state, blocks);
            }
        }
        return true;
    }

    public boolean shouldCarve(Random rand, int rangeX, int rangeZ, ProbabilityConfig config) {
        int chancePerChunk = 6;
        return rand.nextInt(chancePerChunk) == Math.abs(rangeX) % chancePerChunk && rand.nextInt(chancePerChunk) == Math.abs(rangeZ) % chancePerChunk;
    }

    private void setBlock(int x, int y, int z, BlockState block, IChunk blocks) {
        if (x > 15 || x < 0 || z > 15 || z < 0 || y < 0 || y > 255) {
            return;
        }
        blocks.func_177436_a(new BlockPos(x, y, z), block, false);
    }

    private int getHeightValue(int x, int z, IChunk blocks) {
        if (x > 15 || x < 0 || z > 15 || z < 0) {
            return 0;
        }
        return blocks.func_217303_b(Heightmap.Type.WORLD_SURFACE_WG).func_202273_a(x, z);
    }

    protected boolean func_222708_a(double p_222708_1_, double p_222708_3_, double p_222708_5_, int p_222708_7_) {
        return false;
    }
}

