/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.world.decoration;

import com.mojang.serialization.Codec;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.ProbabilityConfig;

public class MapGenSwampTree
extends WorldCarver<ProbabilityConfig> {
    Map<BlockPos, BlockState> cachedCanopy;
    Map<BlockPos, BlockState> cachedRoots;
    private static final double arcSize = 16.0;
    int chancePerChunk;

    public MapGenSwampTree(Codec<ProbabilityConfig> codec, int chancePerChunk) {
        super(codec, chancePerChunk);
        chancePerChunk = 10;
        this.cachedCanopy = new HashMap<BlockPos, BlockState>();
        this.cachedRoots = new HashMap<BlockPos, BlockState>();
        this.chancePerChunk = chancePerChunk;
        this.buildCanopy();
        this.buildRoots();
    }

    private void buildRoots() {
        this.cachedRoots.clear();
        for (double Yangle = 0.0; Yangle < Math.PI * 2; Yangle += 1.0471975511965976) {
            int yOffset = (int)(20.0 * Math.sin(Math.PI)) + 1;
            int xOffset = (int)(17.6 * Math.cos(Math.PI) * Math.cos(Yangle));
            int zOffset = (int)(17.6 * Math.cos(Math.PI) * Math.sin(Yangle));
            for (double angle = Math.PI; angle > 0.0; angle -= 0.07853981633974483) {
                int zz;
                int yy = (int)(20.0 * Math.sin(angle));
                double xzRadius = 12.0 * Math.cos(angle);
                int xx = (int)(xzRadius * Math.cos(Yangle));
                if (!this.cachedRoots.containsKey(new BlockPos(2 + xx - xOffset, yy - yOffset + 2, (zz = (int)(xzRadius * Math.sin(Yangle))) - zOffset))) {
                    this.cachedRoots.put(new BlockPos(2 + xx - xOffset, yy - yOffset + 2, zz - zOffset), (BlockState)Blocks.field_196617_K.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y));
                }
                if (!this.cachedRoots.containsKey(new BlockPos(3 + xx - xOffset, yy - yOffset + 2, zz - zOffset))) {
                    this.cachedRoots.put(new BlockPos(3 + xx - xOffset, yy - yOffset + 2, zz - zOffset), (BlockState)Blocks.field_196617_K.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y));
                }
                if (!this.cachedRoots.containsKey(new BlockPos(2 + xx - xOffset, yy - yOffset + 2, 1 + zz - zOffset))) {
                    this.cachedRoots.put(new BlockPos(2 + xx - xOffset, yy - yOffset + 2, 1 + zz - zOffset), (BlockState)Blocks.field_196617_K.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y));
                }
                if (!this.cachedRoots.containsKey(new BlockPos(2 + xx - xOffset, yy - yOffset + 3, 1 + zz - zOffset))) {
                    this.cachedRoots.put(new BlockPos(2 + xx - xOffset, yy - yOffset + 3, 1 + zz - zOffset), (BlockState)Blocks.field_196617_K.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y));
                }
                if (!this.cachedRoots.containsKey(new BlockPos(1 + xx - xOffset, yy - yOffset + 2, zz - zOffset))) {
                    this.cachedRoots.put(new BlockPos(1 + xx - xOffset, yy - yOffset + 2, zz - zOffset), (BlockState)Blocks.field_196617_K.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y));
                }
                if (this.cachedRoots.containsKey(new BlockPos(2 + xx - xOffset, yy - yOffset + 2, zz - zOffset - 1))) continue;
                this.cachedRoots.put(new BlockPos(2 + xx - xOffset, yy - yOffset + 2, zz - zOffset - 1), (BlockState)Blocks.field_196617_K.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y));
            }
        }
    }

    private void buildCanopy() {
        this.cachedCanopy.clear();
        for (double Yangle = 0.0; Yangle < Math.PI * 2; Yangle += 0.006135923151542565) {
            int yOffset = (int)(16.0 * Math.sin(2.356194490192345));
            int xOffset = (int)(20.0 * Math.cos(2.356194490192345) * Math.cos(Yangle));
            int zOffset = (int)(20.0 * Math.cos(2.356194490192345) * Math.sin(Yangle));
            for (double angle = 2.356194490192345; angle > -0.5235987755982988; angle -= 0.02454369260617026) {
                int yy = (int)(16.0 * Math.sin(angle));
                double xzRadius = 20.8 * Math.cos(angle);
                int xx = (int)(xzRadius * Math.cos(Yangle));
                int zz = (int)(xzRadius * Math.sin(Yangle));
                for (int yyy = -2; yyy < 4; ++yyy) {
                    if (this.cachedCanopy.containsKey(new BlockPos(2 + xx - xOffset, yyy + yy - yOffset + 2, zz - zOffset))) continue;
                    this.cachedCanopy.put(new BlockPos(2 + xx - xOffset, yyy + yy - yOffset + 2, zz - zOffset), (BlockState)Blocks.field_196642_W.func_176223_P().func_206870_a((Property)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(true)));
                }
            }
        }
    }

    public boolean carveRegion(IChunk world, Function<BlockPos, Biome> biomePos, Random rand, int p_225555_8_, int rangeX, int rangeZ, int chunkX, int chunkZ, BitSet carvingMask, ProbabilityConfig config) {
        int x = (rangeX - chunkX) * 16;
        int z = (rangeZ - chunkZ) * 16;
        int y = 56;
        int treeHeight = rand.nextInt(10) + 40;
        int radius = 4;
        int edgeRadius = 1;
        int numDiag = edgeRadius + 1;
        int meta = 3;
        BlockState block = Blocks.field_196617_K.func_176223_P();
        float SHAPE = 0.1f;
        int currentEdgeRadius = (int)(0.1f * (float)(edgeRadius * treeHeight) + 0.9f * (float)edgeRadius);
        ++y;
        for (int yOff = -20; yOff < treeHeight; ++yOff) {
            int xOff;
            int zOff;
            currentEdgeRadius = (int)(0.1f * (float)(edgeRadius * (treeHeight - yOff)) + 0.9f * (float)edgeRadius);
            for (zOff = -numDiag - currentEdgeRadius / 2; zOff <= -currentEdgeRadius / 2; ++zOff) {
                for (xOff = -numDiag - currentEdgeRadius / 2; xOff <= numDiag + currentEdgeRadius / 2; ++xOff) {
                    this.setBlock(new BlockPos(x + xOff, y + yOff, z + zOff), block, world);
                }
                ++currentEdgeRadius;
            }
            for (zOff = -currentEdgeRadius / 2; zOff <= currentEdgeRadius / 2; ++zOff) {
                for (xOff = -numDiag - currentEdgeRadius / 2; xOff <= numDiag + currentEdgeRadius / 2; ++xOff) {
                    this.setBlock(new BlockPos(x + xOff, y + yOff, z + zOff), block, world);
                }
            }
            for (zOff = currentEdgeRadius / 2; zOff <= numDiag + currentEdgeRadius / 2; ++zOff) {
                for (xOff = -numDiag - --currentEdgeRadius / 2; xOff <= numDiag + currentEdgeRadius / 2; ++xOff) {
                    this.setBlock(new BlockPos(x + xOff, y + yOff, z + zOff), block, world);
                }
            }
        }
        for (Map.Entry<BlockPos, BlockState> entry : this.cachedCanopy.entrySet()) {
            this.setBlock(entry.getKey().func_177982_a(x - radius / 2, y + treeHeight, z), entry.getValue(), world);
        }
        for (double Yangle = 0.0; Yangle < Math.PI * 2; Yangle += 0.39269908169872414) {
            int yOffset = (int)(16.0 * Math.sin(2.356194490192345));
            int xOffset = (int)(20.0 * Math.cos(2.356194490192345) * Math.cos(Yangle));
            int zOffset = (int)(20.0 * Math.cos(2.356194490192345) * Math.sin(Yangle));
            for (double angle = 2.356194490192345; angle > -0.5235987755982988; angle -= 0.07853981633974483) {
                int yy = (int)(16.0 * Math.sin(angle));
                double xzRadius = 20.0 * Math.cos(angle);
                int xx = (int)(xzRadius * Math.cos(Yangle));
                int zz = (int)(xzRadius * Math.sin(Yangle));
                this.setBlock(new BlockPos(x + 2 + xx - xOffset - radius / 2, y + treeHeight + yy - yOffset + 2, z + zz - zOffset), Blocks.field_196617_K.func_176223_P(), world);
                this.setBlock(new BlockPos(x + 3 + xx - xOffset - radius / 2, y + treeHeight + yy - yOffset + 2, z + zz - zOffset), Blocks.field_196617_K.func_176223_P(), world);
                this.setBlock(new BlockPos(x + 1 + xx - xOffset - radius / 2, y + treeHeight + yy - yOffset + 2, z + zz - zOffset), Blocks.field_196617_K.func_176223_P(), world);
                this.setBlock(new BlockPos(x + 2 + xx - xOffset - radius / 2, y + treeHeight + yy - yOffset + 3, z + zz - zOffset), Blocks.field_196617_K.func_176223_P(), world);
                this.setBlock(new BlockPos(x + 2 + xx - xOffset - radius / 2, y + treeHeight + yy - yOffset + 2, z + zz - zOffset + 1), Blocks.field_196617_K.func_176223_P(), world);
                this.setBlock(new BlockPos(x + 2 + xx - xOffset - radius / 2, y + treeHeight + yy - yOffset + 2, z + zz - zOffset - 1), Blocks.field_196617_K.func_176223_P(), world);
            }
            if (rand.nextInt(4) != 0) continue;
            int yy = (int)(16.0 * Math.sin(1.0471975511965976));
            double xzRadius = 20.0 * Math.cos(1.5707963267948966);
            int xx = (int)(xzRadius * Math.cos(Yangle));
            int zz = (int)(xzRadius * Math.sin(Yangle));
            int xxx = xx;
            int zzz = zz;
            for (zz = -1; zz < 2; ++zz) {
                for (xx = -1; xx < 2; ++xx) {
                    this.setBlock(new BlockPos(x + 2 + xx - xOffset - radius / 2, y + treeHeight - 10 + yy - yOffset + 2, z + zz - zOffset), (BlockState)Blocks.field_196642_W.func_176223_P().func_206870_a((Property)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(true)), world);
                }
            }
            xx = xxx;
            zz = zzz;
            for (int yyy = 0; yyy < 10; ++yyy) {
                for (zz = -2; zz < 3; ++zz) {
                    for (xx = -2; xx < 3; ++xx) {
                        this.setBlock(new BlockPos(x + 2 + xx - xOffset - radius / 2, y + treeHeight - yyy + yy - yOffset + 2, z + zz - zOffset), (BlockState)Blocks.field_196642_W.func_176223_P().func_206870_a((Property)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(true)), world);
                    }
                }
                xx = xxx;
                zz = zzz;
                this.setBlock(new BlockPos(x + 2 + xx - xOffset - radius / 2, y + treeHeight + yy - yyy - yOffset + 2, z + zz - zOffset), Blocks.field_196617_K.func_176223_P(), world);
                this.setBlock(new BlockPos(x + 3 + xx - xOffset - radius / 2, y + treeHeight + yy - yyy - yOffset + 2, z + zz - zOffset), Blocks.field_196617_K.func_176223_P(), world);
                this.setBlock(new BlockPos(x + 1 + xx - xOffset - radius / 2, y + treeHeight + yy - yyy - yOffset + 2, z + zz - zOffset), Blocks.field_196617_K.func_176223_P(), world);
                this.setBlock(new BlockPos(x + 2 + xx - xOffset - radius / 2, y + treeHeight + yy - yyy - yOffset + 3, z + zz - zOffset), Blocks.field_196617_K.func_176223_P(), world);
                this.setBlock(new BlockPos(x + 2 + xx - xOffset - radius / 2, y + treeHeight + yy - yyy - yOffset + 2, z + zz - zOffset + 1), Blocks.field_196617_K.func_176223_P(), world);
                this.setBlock(new BlockPos(x + 2 + xx - xOffset - radius / 2, y + treeHeight + yy - yyy - yOffset + 2, z + zz - zOffset - 1), Blocks.field_196617_K.func_176223_P(), world);
            }
        }
        for (Map.Entry<BlockPos, BlockState> entry : this.cachedRoots.entrySet()) {
            this.setBlock(entry.getKey().func_177982_a(x - radius / 2, y, z), entry.getValue(), world);
        }
        return true;
    }

    protected void func_151538_a(World world2, int rangeX, int rangeZ, int chunkX, int chunkZ, Block[] blocks) {
    }

    private void setBlock(BlockPos pos, BlockState block, IChunk world) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (x > 15 || x < 0 || z > 15 || z < 0 || y < 0 || y > 255) {
            return;
        }
        world.func_177436_a(new BlockPos(x, y, z), block, false);
    }

    private BlockState getBlock(BlockPos pos, Block block, ChunkPrimer blocks) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (x > 15 || x < 0 || z > 15 || z < 0 || y < 0 || y > 255) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return blocks.func_180495_p(pos);
    }

    public boolean generate(World world, Random rand, int x, int y, int z) {
        BlockPos yOff;
        int xOff;
        int zOff;
        int treeHeight = rand.nextInt(10) + 40;
        int radius = 4;
        boolean flag = true;
        int edgeRadius = 1;
        int numDiag = edgeRadius + 1;
        int meta = 3;
        BlockState block = Blocks.field_196617_K.func_176223_P();
        float SHAPE = 0.1f;
        int currentEdgeRadius = (int)(0.1f * (float)(edgeRadius * treeHeight) + 0.9f * (float)edgeRadius);
        for (zOff = -numDiag - currentEdgeRadius / 2; zOff <= -currentEdgeRadius / 2; ++zOff) {
            for (xOff = -numDiag - currentEdgeRadius / 2; xOff <= numDiag + currentEdgeRadius / 2; ++xOff) {
                yOff = world.func_205770_a(Heightmap.Type.WORLD_SURFACE, new BlockPos(x + xOff, 0, z + zOff));
                while (yOff.func_177956_o() < y) {
                    world.func_175656_a(yOff, block);
                    yOff = yOff.func_177984_a();
                }
                world.func_175656_a(new BlockPos(x + xOff, y, z + zOff), block);
            }
            ++currentEdgeRadius;
        }
        for (zOff = -currentEdgeRadius / 2; zOff <= currentEdgeRadius / 2; ++zOff) {
            for (xOff = -numDiag - currentEdgeRadius / 2; xOff <= numDiag + currentEdgeRadius / 2; ++xOff) {
                yOff = world.func_205770_a(Heightmap.Type.WORLD_SURFACE, new BlockPos(x + xOff, 0, z + zOff));
                while (yOff.func_177956_o() < y) {
                    world.func_175656_a(yOff, block);
                    yOff = yOff.func_177984_a();
                }
                world.func_175656_a(new BlockPos(x + xOff, y, z + zOff), block);
            }
        }
        for (zOff = currentEdgeRadius / 2; zOff <= numDiag + currentEdgeRadius / 2; ++zOff) {
            for (xOff = -numDiag - --currentEdgeRadius / 2; xOff <= numDiag + currentEdgeRadius / 2; ++xOff) {
                yOff = world.func_205770_a(Heightmap.Type.WORLD_SURFACE, new BlockPos(x + xOff, 0, z + zOff));
                while (yOff.func_177956_o() < y) {
                    world.func_175656_a(yOff, block);
                    yOff = yOff.func_177984_a();
                }
                world.func_175656_a(new BlockPos(x + xOff, y, z + zOff), block);
            }
        }
        ++y;
        for (int yOff2 = 0; yOff2 < treeHeight; ++yOff2) {
            int zOff2;
            currentEdgeRadius = (int)(0.1f * (float)(edgeRadius * (treeHeight - yOff2)) + 0.9f * (float)edgeRadius);
            for (zOff2 = -numDiag - currentEdgeRadius / 2; zOff2 <= -currentEdgeRadius / 2; ++zOff2) {
                for (int xOff2 = -numDiag - currentEdgeRadius / 2; xOff2 <= numDiag + currentEdgeRadius / 2; ++xOff2) {
                    world.func_175656_a(new BlockPos(x + xOff2, y + yOff2, z + zOff2), block);
                }
                ++currentEdgeRadius;
            }
            for (zOff2 = -currentEdgeRadius / 2; zOff2 <= currentEdgeRadius / 2; ++zOff2) {
                for (int xOff3 = -numDiag - currentEdgeRadius / 2; xOff3 <= numDiag + currentEdgeRadius / 2; ++xOff3) {
                    world.func_175656_a(new BlockPos(x + xOff3, y + yOff2, z + zOff2), block);
                }
            }
            for (zOff2 = currentEdgeRadius / 2; zOff2 <= numDiag + currentEdgeRadius / 2; ++zOff2) {
                for (int xOff4 = -numDiag - --currentEdgeRadius / 2; xOff4 <= numDiag + currentEdgeRadius / 2; ++xOff4) {
                    world.func_175656_a(new BlockPos(x + xOff4, y + yOff2, z + zOff2), block);
                }
            }
        }
        for (Map.Entry<BlockPos, BlockState> entry : this.cachedCanopy.entrySet()) {
            world.func_180501_a(entry.getKey().func_177982_a(x - radius / 2, y + treeHeight, z), entry.getValue(), 2);
        }
        for (double Yangle = 0.0; Yangle < Math.PI * 2; Yangle += 0.39269908169872414) {
            int yOffset = (int)(16.0 * Math.sin(2.356194490192345));
            int xOffset = (int)(20.0 * Math.cos(2.356194490192345) * Math.cos(Yangle));
            int zOffset = (int)(20.0 * Math.cos(2.356194490192345) * Math.sin(Yangle));
            for (double angle = 2.356194490192345; angle > -0.5235987755982988; angle -= 0.07853981633974483) {
                int yy = (int)(16.0 * Math.sin(angle));
                double xzRadius = 20.0 * Math.cos(angle);
                int xx = (int)(xzRadius * Math.cos(Yangle));
                int zz = (int)(xzRadius * Math.sin(Yangle));
                world.func_180501_a(new BlockPos(x + 2 + xx - xOffset - radius / 2, y + treeHeight + yy - yOffset + 2, z + zz - zOffset), Blocks.field_196617_K.func_176223_P(), 5);
                world.func_180501_a(new BlockPos(x + 3 + xx - xOffset - radius / 2, y + treeHeight + yy - yOffset + 2, z + zz - zOffset), Blocks.field_196617_K.func_176223_P(), 5);
                world.func_180501_a(new BlockPos(x + 1 + xx - xOffset - radius / 2, y + treeHeight + yy - yOffset + 2, z + zz - zOffset), Blocks.field_196617_K.func_176223_P(), 5);
                world.func_180501_a(new BlockPos(x + 2 + xx - xOffset - radius / 2, y + treeHeight + yy - yOffset + 3, z + zz - zOffset), Blocks.field_196617_K.func_176223_P(), 5);
                world.func_180501_a(new BlockPos(x + 2 + xx - xOffset - radius / 2, y + treeHeight + yy - yOffset + 2, z + zz - zOffset + 1), Blocks.field_196617_K.func_176223_P(), 5);
                world.func_180501_a(new BlockPos(x + 2 + xx - xOffset - radius / 2, y + treeHeight + yy - yOffset + 2, z + zz - zOffset - 1), Blocks.field_196617_K.func_176223_P(), 5);
            }
            if (rand.nextInt(4) != 0) continue;
            int yy = (int)(16.0 * Math.sin(1.0471975511965976));
            double xzRadius = 20.0 * Math.cos(1.5707963267948966);
            int xx = (int)(xzRadius * Math.cos(Yangle));
            int zz = (int)(xzRadius * Math.sin(Yangle));
            int xxx = xx;
            int zzz = zz;
            for (zz = -1; zz < 2; ++zz) {
                for (xx = -1; xx < 2; ++xx) {
                    world.func_180501_a(new BlockPos(x + 2 + xx - xOffset - radius / 2, y + treeHeight - 10 + yy - yOffset + 2, z + zz - zOffset), (BlockState)Blocks.field_196642_W.func_176223_P().func_206870_a((Property)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(true)), 5);
                }
            }
            xx = xxx;
            zz = zzz;
            for (int yyy = 0; yyy < 10; ++yyy) {
                for (zz = -2; zz < 3; ++zz) {
                    for (xx = -2; xx < 3; ++xx) {
                        world.func_180501_a(new BlockPos(x + 2 + xx - xOffset - radius / 2, y + treeHeight - yyy + yy - yOffset + 2, z + zz - zOffset), (BlockState)Blocks.field_196642_W.func_176223_P().func_206870_a((Property)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(true)), 5);
                    }
                }
                xx = xxx;
                zz = zzz;
                world.func_180501_a(new BlockPos(x + 2 + xx - xOffset - radius / 2, y + treeHeight + yy - yyy - yOffset + 2, z + zz - zOffset), Blocks.field_196617_K.func_176223_P(), 5);
                world.func_180501_a(new BlockPos(x + 3 + xx - xOffset - radius / 2, y + treeHeight + yy - yyy - yOffset + 2, z + zz - zOffset), Blocks.field_196617_K.func_176223_P(), 5);
                world.func_180501_a(new BlockPos(x + 1 + xx - xOffset - radius / 2, y + treeHeight + yy - yyy - yOffset + 2, z + zz - zOffset), Blocks.field_196617_K.func_176223_P(), 5);
                world.func_180501_a(new BlockPos(x + 2 + xx - xOffset - radius / 2, y + treeHeight + yy - yyy - yOffset + 3, z + zz - zOffset), Blocks.field_196617_K.func_176223_P(), 5);
                world.func_180501_a(new BlockPos(x + 2 + xx - xOffset - radius / 2, y + treeHeight + yy - yyy - yOffset + 2, z + zz - zOffset + 1), Blocks.field_196617_K.func_176223_P(), 5);
                world.func_180501_a(new BlockPos(x + 2 + xx - xOffset - radius / 2, y + treeHeight + yy - yyy - yOffset + 2, z + zz - zOffset - 1), Blocks.field_196617_K.func_176223_P(), 5);
            }
        }
        for (Map.Entry<BlockPos, BlockState> entry : this.cachedRoots.entrySet()) {
            world.func_180501_a(entry.getKey().func_177982_a(x - radius / 2, y, z), entry.getValue(), 2);
        }
        return true;
    }

    private void onPlantGrow(World world, int x, int y, int z, int sourceX, int sourceY, int sourceZ) {
        world.func_180495_p(new BlockPos(x, y, z)).func_177230_c().onPlantGrow(world.func_180495_p(new BlockPos(x, y, z)), (IWorld)world, new BlockPos(x, y, z), new BlockPos(sourceX, sourceY, sourceZ));
    }

    public boolean shouldCarve(Random rand, int chunkX, int chunkZ, ProbabilityConfig config) {
        return rand.nextInt(this.chancePerChunk) == Math.abs(chunkX) % this.chancePerChunk && rand.nextInt(this.chancePerChunk) == Math.abs(chunkZ) % this.chancePerChunk;
    }

    protected boolean func_222708_a(double p_222708_1_, double p_222708_3_, double p_222708_5_, int p_222708_7_) {
        return false;
    }
}

