/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.world.decoration;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.ScatteredStructurePiece;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.TemplateManager;
import zmaster587.advancedRocketry.api.AdvancedRocketryBiomes;

public class StructurePieceCrater
extends ScatteredStructurePiece {
    int chancePerChunk;
    int radius;
    int xCenter;
    int zCenter;

    public StructurePieceCrater(Random random, int x, int z) {
        super(AdvancedRocketryBiomes.STRUCTURE_PIECE_CRATER, random, x, 64, z, 160, 15, 160);
        this.func_186164_a(null);
        this.radius = random.nextInt(56) + 8;
        this.xCenter = x;
        this.zCenter = z;
    }

    public StructurePieceCrater(TemplateManager mgr, CompoundNBT piece) {
        super(AdvancedRocketryBiomes.STRUCTURE_PIECE_CRATER, piece);
        this.radius = piece.func_74762_e("Radius");
        this.xCenter = piece.func_74762_e("xCenter");
        this.zCenter = piece.func_74762_e("zCenter");
    }

    protected void func_143011_b(CompoundNBT tagCompound) {
        super.func_143011_b(tagCompound);
        tagCompound.func_74768_a("Radius", this.radius);
        tagCompound.func_74768_a("xCenter", this.xCenter);
        tagCompound.func_74768_a("zCenter", this.zCenter);
    }

    public boolean func_230383_a_(ISeedReader world, StructureManager structureMgr, ChunkGenerator chunkGen, Random rand, MutableBoundingBox bb, ChunkPos chunkPos, BlockPos blockPos) {
        int depth = this.radius * this.radius;
        int xCoord = chunkPos.field_77276_a << 4;
        int zCoord = chunkPos.field_77275_b << 4;
        int ridgeSize = 12;
        double distFromCenterX = xCoord - this.xCenter - this.radius - 2 * ridgeSize;
        double distFromCenterZ = zCoord - this.zCenter - this.radius - 2 * ridgeSize;
        for (int relx = 15; relx >= 0; --relx) {
            for (int relz = 15; relz >= 0; --relz) {
                int dist;
                int x = relx + xCoord;
                int z = relz + zCoord;
                int y = world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, x, z) - 1;
                int count = (int)(((double)depth - ((distFromCenterX + (double)relx) * (distFromCenterX + (double)relx) + (distFromCenterZ + (double)relz) * (distFromCenterZ + (double)relz))) / (double)(this.radius * 2));
                for (dist = 0; dist < count; ++dist) {
                    if (y - dist <= 2) continue;
                    this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), x, y - dist, z, bb);
                }
                if (count <= 0 && count > -2 * ridgeSize) {
                    for (dist = 0; dist < (ridgeSize * ridgeSize - (count + ridgeSize) * (count + ridgeSize)) / (ridgeSize * 2); ++dist) {
                        if (y + dist >= 255) continue;
                        this.func_175811_a(world, world.func_226691_t_(new BlockPos(x, y + dist, z)).func_242440_e().func_242502_e().func_204108_a(), x, y + dist, z, bb);
                    }
                }
                if (count <= 1 || y - count <= 2) continue;
                this.func_175811_a(world, world.func_226691_t_(new BlockPos(x, y - count, z)).func_242440_e().func_242502_e().func_204108_a(), x, y - count, z, bb);
            }
        }
        return true;
    }

    protected void func_175811_a(ISeedReader worldIn, BlockState blockstateIn, int x, int y, int z, MutableBoundingBox boundingboxIn) {
        worldIn.func_180501_a(new BlockPos(x, y, z), blockstateIn, 2);
    }
}

