/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.world.decoration;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.ScatteredStructurePiece;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraftforge.registries.ForgeRegistries;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryBiomes;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.libVulpes.block.BlockMeta;

public class StructurePieceGeode
extends ScatteredStructurePiece {
    int chancePerChunk;
    int radius;
    int xCenter;
    int zCenter;
    private static List<BlockMeta> ores;

    public static void init() {
        if (ores == null) {
            ores = new LinkedList<BlockMeta>();
            for (int i = 0; i < ARConfiguration.getCurrentConfig().standardGeodeOres.size(); ++i) {
                ResourceLocation oreDictName = ARConfiguration.getCurrentConfig().standardGeodeOres.get(i);
                ores.add(new BlockMeta((Block)ForgeRegistries.BLOCKS.getValue(oreDictName)));
            }
        }
    }

    public StructurePieceGeode(Random random, int x, int z) {
        super(AdvancedRocketryBiomes.STRUCTURE_PIECE_GEODE, random, x, 64, z, 128, 15, 128);
        this.func_186164_a(null);
        this.radius = random.nextInt((Integer)ARConfiguration.getCurrentConfig().geodeVariation.get()) + (Integer)ARConfiguration.getCurrentConfig().geodeBaseSize.get() - (Integer)ARConfiguration.getCurrentConfig().geodeVariation.get() / 2;
        this.xCenter = x;
        this.zCenter = z;
    }

    public StructurePieceGeode(TemplateManager mgr, CompoundNBT piece) {
        super(AdvancedRocketryBiomes.STRUCTURE_PIECE_GEODE, piece);
        this.radius = piece.func_74762_e("Radius");
        this.xCenter = piece.func_74762_e("xCenter");
        this.zCenter = piece.func_74762_e("zCenter");
    }

    protected void func_143011_b(CompoundNBT tagCompound) {
        super.func_143011_b(tagCompound);
        tagCompound.func_74768_a("Radius", this.radius);
        tagCompound.func_74768_a("xCenter", this.xCenter);
        tagCompound.func_74768_a("zCenter", this.zCenter);
    }

    public boolean func_230383_a_(ISeedReader world, StructureManager structureMgr, ChunkGenerator chunkGen, Random rand, MutableBoundingBox bb, ChunkPos chunkPos, BlockPos blockPos) {
        int depth = this.radius * this.radius;
        int chunkX = chunkPos.field_77276_a;
        int chunkZ = chunkPos.field_77275_b;
        int xCoord = (chunkX << 4) - this.xCenter - this.radius;
        int zCoord = (chunkZ << 4) - this.zCenter - this.radius;
        BlockPos pos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
        int avgY = 64;
        for (int relx = 15; relx >= 0; --relx) {
            for (int relz = 15; relz >= 0; --relz) {
                int count = (depth - ((xCoord + relx) * (xCoord + relx) + (zCoord + relz) * (zCoord + relz))) / (this.radius * 2);
                int x = (chunkX << 4) + relx;
                int z = (chunkZ << 4) + relz;
                if (avgY - count < 1 || avgY + count > 255) continue;
                for (int dist = -count; dist < Math.min(count, 3); ++dist) {
                    this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), x, avgY - dist, z, bb);
                }
                if (count < 0) continue;
                if (count > 4) {
                    int i;
                    int size = rand.nextInt(4) + 4;
                    if (relx % 4 > 0 && relz % 4 > 0) {
                        for (i = 1; i < size; ++i) {
                            this.func_175811_a(world, ores.get((relx / 4 + relz / 4) % ores.size()).getBlockState(), x, avgY + count - i, z, bb);
                        }
                    } else {
                        size -= 2;
                        for (i = 1; i < size; ++i) {
                            this.func_175811_a(world, Blocks.field_150348_b.func_176223_P(), x, avgY + count - i, z, bb);
                        }
                    }
                    if ((relx + 2) % 4 > 0 && (relz + 2) % 4 > 0) {
                        for (i = 1; i < size; ++i) {
                            this.func_175811_a(world, ores.get((relx / 4 + relz / 4) % ores.size()).getBlockState(), x, avgY - count + i, z, bb);
                        }
                    }
                }
                this.func_175811_a(world, AdvancedRocketryBlocks.blocksGeode.func_176223_P(), x, avgY - count, z, bb);
                this.func_175811_a(world, AdvancedRocketryBlocks.blocksGeode.func_176223_P(), x, avgY + count, z, bb);
            }
        }
        return true;
    }

    protected void func_175811_a(ISeedReader worldIn, BlockState blockstateIn, int x, int y, int z, MutableBoundingBox boundingboxIn) {
        worldIn.func_180501_a(new BlockPos(x, y, z), blockstateIn, 2);
    }
}

