/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.world.decoration;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.ScatteredStructurePiece;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.TemplateManager;
import zmaster587.advancedRocketry.api.AdvancedRocketryBiomes;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;

public class StructurePieceVolcano
extends ScatteredStructurePiece {
    private static final Supplier<? extends Block> blockEnrichedLava = AdvancedRocketryBlocks.blockEnrichedLavaFluid;
    private static final Block blockCasing = AdvancedRocketryBlocks.blockBasalt;
    int xCenter;
    int zCenter;
    int sizeDeviation;

    public StructurePieceVolcano(Random random, int x, int z) {
        super(AdvancedRocketryBiomes.STRUCTURE_PIECE_VOLCANO, random, x, 64, z, 128, 64, 128);
        this.func_186164_a(null);
        this.xCenter = x;
        this.zCenter = z;
        this.sizeDeviation = random.nextInt(8);
    }

    public StructurePieceVolcano(TemplateManager mgr, CompoundNBT piece) {
        super(AdvancedRocketryBiomes.STRUCTURE_PIECE_VOLCANO, piece);
        this.xCenter = piece.func_74762_e("xCenter");
        this.zCenter = piece.func_74762_e("zCenter");
        this.sizeDeviation = piece.func_74762_e("sizeDev");
    }

    protected void func_143011_b(CompoundNBT tagCompound) {
        super.func_143011_b(tagCompound);
        tagCompound.func_74768_a("xCenter", this.xCenter);
        tagCompound.func_74768_a("zCenter", this.zCenter);
        tagCompound.func_74768_a("sizeDev", this.sizeDeviation);
    }

    public boolean func_230383_a_(ISeedReader world, StructureManager structureMgr, ChunkGenerator chunkGen, Random rand, MutableBoundingBox bb, ChunkPos chunkPos, BlockPos blockPos) {
        int size = 64;
        int xCoord = chunkPos.field_77276_a << 4;
        int zCoord = chunkPos.field_77275_b << 4;
        double distFromCenterX = xCoord - this.xCenter - 64;
        double distFromCenterZ = zCoord - this.zCenter - 64;
        int baseHeight = 40;
        int lavaNodeHeight = 25;
        for (int x = 15; x >= 0; --x) {
            for (int z = 15; z >= 0; --z) {
                int crackle = rand.nextInt(2);
                int realXcoord = xCoord + x;
                int realZcoord = zCoord + z;
                double x2 = (distFromCenterX + (double)x) * (distFromCenterX + (double)x);
                double z2 = (distFromCenterZ + (double)z) * (distFromCenterZ + (double)z);
                double radius = Math.sqrt(x2 + z2);
                double func = 1.0 / Math.pow(1.028, radius - (double)((size - this.sizeDeviation) * 3)) + (double)baseHeight - 8.0 / Math.pow(1.09, radius - (double)(size - this.sizeDeviation) / 2.6) - Math.pow(1.7, radius - (double)size * 0.9);
                for (int y = 254; y >= 1; --y) {
                    boolean innerLayer;
                    boolean underSurface = func >= (double)(y + crackle);
                    boolean bl = innerLayer = func >= (double)(y + crackle) && radius < 5.0 && y > lavaNodeHeight;
                    if (innerLayer) {
                        this.func_175811_a(world, blockEnrichedLava.get().func_176223_P(), realXcoord, y, realZcoord, bb);
                    } else if (underSurface) {
                        this.func_175811_a(world, blockCasing.func_176223_P(), realXcoord, y, realZcoord, bb);
                    }
                    double sphereradius = x2 + z2 + (double)((y - lavaNodeHeight) * (y - lavaNodeHeight));
                    if (sphereradius < 529.0) {
                        this.func_175811_a(world, blockEnrichedLava.get().func_176223_P(), realXcoord, y, realZcoord, bb);
                    } else if (sphereradius < 625.0) {
                        this.func_175811_a(world, blockCasing.func_176223_P(), realXcoord, y, realZcoord, bb);
                    }
                    if (!innerLayer) continue;
                    this.func_175811_a(world, blockEnrichedLava.get().func_176223_P(), realXcoord, y, realZcoord, bb);
                }
            }
        }
        return true;
    }

    protected void func_175811_a(ISeedReader worldIn, BlockState blockstateIn, int x, int y, int z, MutableBoundingBox boundingboxIn) {
        worldIn.func_180501_a(new BlockPos(x, y, z), blockstateIn, 2);
    }
}

