/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.world.gen;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.trunkplacer.StraightTrunkPlacer;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;

public class WorldGenAlienTree
extends StraightTrunkPlacer {
    public static final Codec<WorldGenAlienTree> codec = RecordCodecBuilder.create(p_236902_0_ -> WorldGenAlienTree.func_236915_a_((RecordCodecBuilder.Instance)p_236902_0_).apply((Applicative)p_236902_0_, WorldGenAlienTree::new));

    public WorldGenAlienTree(int i, int j, int k) {
        super(i, j, k);
    }

    public List<FoliagePlacer.Foliage> func_230382_a_(IWorldGenerationReader world, Random random, int p_230382_3_, BlockPos pos, Set<BlockPos> p_230382_5_, MutableBoundingBox boundingBox, BaseTreeFeatureConfig p_230382_7_) {
        int treeHeight = random.nextInt(10) + 20;
        boolean flag = true;
        int y = pos.func_177956_o();
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        boolean isSoil = true;
        if (isSoil && y < 256 - treeHeight - 1) {
            int trunkY;
            int j2;
            this.onPlantGrow(world, x, y - 1, z, x, y, z);
            this.onPlantGrow(world, x + 1, y - 1, z, x, y, z);
            this.onPlantGrow(world, x + 1, y - 1, z + 1, x, y, z);
            this.onPlantGrow(world, x, y - 1, z + 1, x, y, z);
            int j3 = random.nextInt(4);
            int j1 = treeHeight - random.nextInt(4);
            int trunkX = x;
            int trunkZ = z;
            int i2 = 0;
            for (j2 = 0; j2 < treeHeight; ++j2) {
                trunkY = y + j2;
                WorldGenAlienTree.func_236913_a_((IWorldWriter)world, (BlockPos)new BlockPos(trunkX, trunkY, trunkZ), (BlockState)AdvancedRocketryBlocks.blockAlienWood.func_176223_P(), (MutableBoundingBox)boundingBox);
                WorldGenAlienTree.func_236913_a_((IWorldWriter)world, (BlockPos)new BlockPos(trunkX + 1, trunkY, trunkZ), (BlockState)AdvancedRocketryBlocks.blockAlienWood.func_176223_P(), (MutableBoundingBox)boundingBox);
                WorldGenAlienTree.func_236913_a_((IWorldWriter)world, (BlockPos)new BlockPos(trunkX, trunkY, trunkZ + 1), (BlockState)AdvancedRocketryBlocks.blockAlienWood.func_176223_P(), (MutableBoundingBox)boundingBox);
                WorldGenAlienTree.func_236913_a_((IWorldWriter)world, (BlockPos)new BlockPos(trunkX + 1, trunkY, trunkZ + 1), (BlockState)AdvancedRocketryBlocks.blockAlienWood.func_176223_P(), (MutableBoundingBox)boundingBox);
                i2 = trunkY;
            }
            WorldGenAlienTree.func_236913_a_((IWorldWriter)world, (BlockPos)new BlockPos(trunkX - 1, y, trunkZ), (BlockState)AdvancedRocketryBlocks.blockAlienWood.func_176223_P(), (MutableBoundingBox)boundingBox);
            WorldGenAlienTree.func_236913_a_((IWorldWriter)world, (BlockPos)new BlockPos(trunkX + 2, y, trunkZ), (BlockState)AdvancedRocketryBlocks.blockAlienWood.func_176223_P(), (MutableBoundingBox)boundingBox);
            WorldGenAlienTree.func_236913_a_((IWorldWriter)world, (BlockPos)new BlockPos(trunkX + 2, y, trunkZ + 1), (BlockState)AdvancedRocketryBlocks.blockAlienWood.func_176223_P(), (MutableBoundingBox)boundingBox);
            WorldGenAlienTree.func_236913_a_((IWorldWriter)world, (BlockPos)new BlockPos(trunkX - 1, y, trunkZ + 1), (BlockState)AdvancedRocketryBlocks.blockAlienWood.func_176223_P(), (MutableBoundingBox)boundingBox);
            WorldGenAlienTree.func_236913_a_((IWorldWriter)world, (BlockPos)new BlockPos(trunkX, y, trunkZ - 1), (BlockState)AdvancedRocketryBlocks.blockAlienWood.func_176223_P(), (MutableBoundingBox)boundingBox);
            WorldGenAlienTree.func_236913_a_((IWorldWriter)world, (BlockPos)new BlockPos(trunkX + 1, y, trunkZ - 1), (BlockState)AdvancedRocketryBlocks.blockAlienWood.func_176223_P(), (MutableBoundingBox)boundingBox);
            WorldGenAlienTree.func_236913_a_((IWorldWriter)world, (BlockPos)new BlockPos(trunkX + 1, y, trunkZ + 2), (BlockState)AdvancedRocketryBlocks.blockAlienWood.func_176223_P(), (MutableBoundingBox)boundingBox);
            WorldGenAlienTree.func_236913_a_((IWorldWriter)world, (BlockPos)new BlockPos(trunkX, y, trunkZ + 2), (BlockState)AdvancedRocketryBlocks.blockAlienWood.func_176223_P(), (MutableBoundingBox)boundingBox);
            WorldGenAlienTree.func_236913_a_((IWorldWriter)world, (BlockPos)new BlockPos(trunkX, y, trunkZ), (BlockState)AdvancedRocketryBlocks.blockAlienWood.func_176223_P(), (MutableBoundingBox)boundingBox);
            WorldGenAlienTree.func_236913_a_((IWorldWriter)world, (BlockPos)new BlockPos(trunkX + 1, y, trunkZ), (BlockState)AdvancedRocketryBlocks.blockAlienWood.func_176223_P(), (MutableBoundingBox)boundingBox);
            WorldGenAlienTree.func_236913_a_((IWorldWriter)world, (BlockPos)new BlockPos(trunkX, y, trunkZ + 1), (BlockState)AdvancedRocketryBlocks.blockAlienWood.func_176223_P(), (MutableBoundingBox)boundingBox);
            WorldGenAlienTree.func_236913_a_((IWorldWriter)world, (BlockPos)new BlockPos(trunkX + 1, y, trunkZ + 1), (BlockState)AdvancedRocketryBlocks.blockAlienWood.func_176223_P(), (MutableBoundingBox)boundingBox);
            this.generatePod(world, random, 6, trunkX + 1, random.nextInt(10) + y + treeHeight / 6, trunkZ, 1, 1, boundingBox);
            this.generatePod(world, random, 6, trunkX, random.nextInt(10) + y + treeHeight / 6, trunkZ + 1, -1, -1, boundingBox);
            this.generatePod(world, random, 6, trunkX, random.nextInt(10) + y + treeHeight / 6, trunkZ + 1, -1, 1, boundingBox);
            this.generatePod(world, random, 6, trunkX + 1, random.nextInt(10) + y + treeHeight / 6, trunkZ, 1, -1, boundingBox);
            this.generatePod(world, random, 6, trunkX + 1, random.nextInt(10) + y + treeHeight / 6, trunkZ, 1, 0, boundingBox);
            this.generatePod(world, random, 6, trunkX, random.nextInt(10) + y + treeHeight / 6, trunkZ + 1, -1, 0, boundingBox);
            this.generatePod(world, random, 6, trunkX, random.nextInt(10) + y + treeHeight / 6, trunkZ + 1, 0, 1, boundingBox);
            this.generatePod(world, random, 6, trunkX + 1, random.nextInt(10) + y + treeHeight / 6, trunkZ, 0, -1, boundingBox);
            this.generatePod(world, random, 3, trunkX + 1, random.nextInt(5) + y + treeHeight - treeHeight / 3, trunkZ, 1, 1, boundingBox);
            this.generatePod(world, random, 3, trunkX, random.nextInt(5) + y + treeHeight - treeHeight / 3, trunkZ + 1, -1, -1, boundingBox);
            this.generatePod(world, random, 3, trunkX, random.nextInt(5) + y + treeHeight - treeHeight / 3, trunkZ + 1, -1, 1, boundingBox);
            this.generatePod(world, random, 3, trunkX + 1, random.nextInt(5) + y + treeHeight - treeHeight / 3, trunkZ, 1, -1, boundingBox);
            this.generatePod(world, random, 3, trunkX + 1, random.nextInt(5) + y + treeHeight - treeHeight / 3, trunkZ, 1, 0, boundingBox);
            this.generatePod(world, random, 3, trunkX, random.nextInt(5) + y + treeHeight - treeHeight / 3, trunkZ + 1, -1, 0, boundingBox);
            this.generatePod(world, random, 3, trunkX, random.nextInt(5) + y + treeHeight - treeHeight / 3, trunkZ + 1, 0, 1, boundingBox);
            this.generatePod(world, random, 3, trunkX + 1, random.nextInt(5) + y + treeHeight - treeHeight / 3, trunkZ, 0, -1, boundingBox);
            for (j2 = -3; j2 <= 3; ++j2) {
                for (trunkY = -3; trunkY <= 1; ++trunkY) {
                    int b1 = -1;
                    for (int c = 0; c < treeHeight - 4; ++c) {
                        int radius = Math.abs(trunkX + j2) + Math.abs(trunkZ + trunkY);
                        if ((c >= treeHeight / 3 || radius >= 3) && (c < treeHeight / 3 || radius >= 4)) continue;
                        this.replaceAirWithLeaves(world, trunkX + j2, i2 + b1 - c, trunkZ + trunkY, boundingBox);
                        this.replaceAirWithLeaves(world, 1 + trunkX - j2, i2 + b1 - c, trunkZ + trunkY, boundingBox);
                        this.replaceAirWithLeaves(world, trunkX + j2, i2 + b1 - c, 1 + trunkZ - trunkY, boundingBox);
                        this.replaceAirWithLeaves(world, 1 + trunkX - j2, i2 + b1 - c, 1 + trunkZ - trunkY, boundingBox);
                    }
                    if (j2 <= -2 && trunkY <= -1 || j2 == -1 && trunkY == -2) continue;
                    int b2 = 1;
                    this.replaceAirWithLeaves(world, trunkX + j2, i2 + b2, trunkZ + trunkY, boundingBox);
                    this.replaceAirWithLeaves(world, 1 + trunkX - j2, i2 + b2, trunkZ + trunkY, boundingBox);
                    this.replaceAirWithLeaves(world, trunkX + j2, i2 + b2, 1 + trunkZ - trunkY, boundingBox);
                    this.replaceAirWithLeaves(world, 1 + trunkX - j2, i2 + b2, 1 + trunkZ - trunkY, boundingBox);
                }
            }
            if (random.nextBoolean()) {
                this.replaceAirWithLeaves(world, trunkX, i2 + 2, trunkZ, boundingBox);
                this.replaceAirWithLeaves(world, trunkX + 1, i2 + 2, trunkZ, boundingBox);
                this.replaceAirWithLeaves(world, trunkX + 1, i2 + 2, trunkZ + 1, boundingBox);
                this.replaceAirWithLeaves(world, trunkX, i2 + 2, trunkZ + 1, boundingBox);
            }
            for (j2 = -3; j2 <= 4; ++j2) {
                for (trunkY = -3; trunkY <= 4; ++trunkY) {
                    if (j2 == -3 && trunkY == -3 || j2 == -3 && trunkY == 4 || j2 == 4 && trunkY == -3 || j2 == 4 && trunkY == 4 || Math.abs(j2) >= 3 && Math.abs(trunkY) >= 3) continue;
                    this.replaceAirWithLeaves(world, trunkX + j2, i2, trunkZ + trunkY, boundingBox);
                }
            }
        }
        return new LinkedList<FoliagePlacer.Foliage>();
    }

    private void generatePod(IWorldGenerationReader world, Random random, int intitalDist, int x, int y, int z, int dirX, int dirZ, MutableBoundingBox boundingBox) {
        int branchLength = random.nextInt(5) + intitalDist;
        Direction direction = Direction.func_82600_a((int)(dirX != 0 && dirZ != 0 ? Math.abs(dirX) * 4 : Math.abs(dirX) * 4 + Math.abs(dirZ) * 8));
        boolean flag = true;
        for (int l = 0; l < branchLength && flag; ++l) {
            int newX = x + dirX * l;
            int newY = l >= branchLength / 2 ? y + 2 : y;
            int newZ = z + dirZ * l;
            flag = flag && this.replaceBlockWithWood(world, newX, newY, newZ, direction, boundingBox);
            flag = flag && this.replaceBlockWithWood(world, newX, newY - 1, newZ, direction, boundingBox);
            flag = flag && this.replaceBlockWithWood(world, newX + dirZ, newY, newZ + dirX, direction, boundingBox);
            flag = flag && this.replaceBlockWithWood(world, newX + dirZ, newY - 1, newZ + dirX, direction, boundingBox);
        }
        int radius = 4;
        for (int offX = -radius; offX < radius; ++offX) {
            for (int offY = -radius; offY < radius; ++offY) {
                for (int offZ = -radius; offZ < radius; ++offZ) {
                    if (offX * offX + offY * offY + offZ * offZ >= radius * radius + 1) continue;
                    this.replaceAirWithLeaves(world, x + offX + dirX * branchLength, y + offY + 1, z + offZ + dirZ * branchLength, boundingBox);
                }
            }
        }
    }

    private boolean replaceBlockWithWood(IWorldGenerationReader world, int x, int y, int z, Direction direction, MutableBoundingBox boundingBox) {
        WorldGenAlienTree.func_236913_a_((IWorldWriter)world, (BlockPos)new BlockPos(x, y, z), (BlockState)((BlockState)AdvancedRocketryBlocks.blockAlienWood.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)direction.func_176740_k())), (MutableBoundingBox)boundingBox);
        return true;
    }

    private void replaceAirWithLeaves(IWorldGenerationReader world, int x, int y, int z, MutableBoundingBox boundingBox) {
        BlockPos pos = new BlockPos(x, y, z);
        WorldGenAlienTree.func_236913_a_((IWorldWriter)world, (BlockPos)pos, (BlockState)AdvancedRocketryBlocks.blockAlienLeaves.func_176223_P(), (MutableBoundingBox)boundingBox);
    }

    private void onPlantGrow(IWorldGenerationReader world, int x, int y, int z, int sourceX, int sourceY, int sourceZ) {
    }

    static class Foliage {
        private final FoliagePlacer.Foliage field_236892_a_;
        private final int field_236893_b_;

        public Foliage(BlockPos p_i232055_1_, int p_i232055_2_) {
            this.field_236892_a_ = new FoliagePlacer.Foliage(p_i232055_1_, 0, false);
            this.field_236893_b_ = p_i232055_2_;
        }

        public int func_236894_a_() {
            return this.field_236893_b_;
        }
    }
}

