/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.world.gen;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;

public class WorldGenLargeCrystal
extends Feature<NoFeatureConfig> {
    BlockState block = AdvancedRocketryBlocks.blockCrystal.func_176223_P();

    public WorldGenLargeCrystal(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGen, Random rand, BlockPos pos, NoFeatureConfig config) {
        BlockPos yOff;
        int xOff;
        int zOff;
        if (rand.nextInt() % 18 != 0) {
            return false;
        }
        BlockState state = world.func_226691_t_(pos).func_242440_e().func_242502_e().func_204109_b();
        Block fillerBlock = state.func_177230_c();
        int height = rand.nextInt(40) + 10;
        int edgeRadius = rand.nextInt(4) + 2;
        int numDiag = edgeRadius + 1;
        int xShear = 1 - (rand.nextInt(6) + 3) / 4;
        int zShear = 1 - (rand.nextInt(6) + 3) / 4;
        BlockState usedState = AdvancedRocketryBlocks.crystalBlocks[rand.nextInt(AdvancedRocketryBlocks.crystalBlocks.length)].func_176223_P();
        float SHAPE = 0.01f + rand.nextFloat() * 0.2f;
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        int y = world.func_205770_a(Heightmap.Type.WORLD_SURFACE, new BlockPos(x, 0, z)).func_177956_o() - 2;
        int currentEdgeRadius = (int)(SHAPE * (float)(edgeRadius * height) + (1.0f - SHAPE) * (float)edgeRadius);
        for (zOff = -numDiag - currentEdgeRadius / 2; zOff <= -currentEdgeRadius / 2; ++zOff) {
            for (xOff = -numDiag - currentEdgeRadius / 2; xOff <= numDiag + currentEdgeRadius / 2; ++xOff) {
                yOff = world.func_205770_a(Heightmap.Type.WORLD_SURFACE, new BlockPos(x + xOff, y, z + zOff));
                while (yOff.func_177956_o() < y) {
                    this.setBlockState(world, yOff, fillerBlock.func_176223_P());
                    yOff = yOff.func_177984_a();
                }
                this.setBlockState(world, new BlockPos(x + xOff, y, z + zOff), fillerBlock.func_176223_P());
            }
            ++currentEdgeRadius;
        }
        for (zOff = -currentEdgeRadius / 2; zOff <= currentEdgeRadius / 2; ++zOff) {
            for (xOff = -numDiag - currentEdgeRadius / 2; xOff <= numDiag + currentEdgeRadius / 2; ++xOff) {
                yOff = world.func_205770_a(Heightmap.Type.WORLD_SURFACE, new BlockPos(x + xOff, y, z + zOff));
                while (yOff.func_177956_o() < y) {
                    this.setBlockState(world, yOff, fillerBlock.func_176223_P());
                    yOff = yOff.func_177984_a();
                }
                this.setBlockState(world, new BlockPos(x + xOff, y, z + zOff), fillerBlock.func_176223_P());
            }
        }
        for (zOff = currentEdgeRadius / 2; zOff <= numDiag + currentEdgeRadius / 2; ++zOff) {
            for (xOff = -numDiag - --currentEdgeRadius / 2; xOff <= numDiag + currentEdgeRadius / 2; ++xOff) {
                yOff = world.func_205770_a(Heightmap.Type.WORLD_SURFACE, new BlockPos(x + xOff, y, z + zOff));
                while (yOff.func_177956_o() < y) {
                    this.setBlockState(world, yOff, fillerBlock.func_176223_P());
                    yOff = yOff.func_177984_a();
                }
                this.setBlockState(world, new BlockPos(x + xOff, y, z + zOff), fillerBlock.func_176223_P());
            }
        }
        ++y;
        for (int yOff2 = 0; yOff2 < height; ++yOff2) {
            int zOff2;
            currentEdgeRadius = (int)(SHAPE * (float)(edgeRadius * (height - yOff2)) + (1.0f - SHAPE) * (float)edgeRadius);
            for (zOff2 = -numDiag - currentEdgeRadius / 2; zOff2 <= -currentEdgeRadius / 2; ++zOff2) {
                for (int xOff2 = -numDiag - currentEdgeRadius / 2; xOff2 <= numDiag + currentEdgeRadius / 2; ++xOff2) {
                    this.setBlockState(world, new BlockPos(x + xOff2 + xShear * yOff2, y + yOff2, z + zOff2 + zShear * yOff2), usedState);
                }
                ++currentEdgeRadius;
            }
            for (zOff2 = -currentEdgeRadius / 2; zOff2 <= currentEdgeRadius / 2; ++zOff2) {
                for (int xOff3 = -numDiag - currentEdgeRadius / 2; xOff3 <= numDiag + currentEdgeRadius / 2; ++xOff3) {
                    this.setBlockState(world, new BlockPos(x + xOff3 + xShear * yOff2, y + yOff2, z + zOff2 + zShear * yOff2), usedState);
                }
            }
            for (zOff2 = currentEdgeRadius / 2; zOff2 <= numDiag + currentEdgeRadius / 2; ++zOff2) {
                for (int xOff4 = -numDiag - --currentEdgeRadius / 2; xOff4 <= numDiag + currentEdgeRadius / 2; ++xOff4) {
                    this.setBlockState(world, new BlockPos(x + xOff4 + xShear * yOff2, y + yOff2, z + zOff2 + zShear * yOff2), usedState);
                }
            }
        }
        currentEdgeRadius = (int)(SHAPE * (float)(edgeRadius * height) + (1.0f - SHAPE) * (float)edgeRadius);
        for (zOff = -numDiag - currentEdgeRadius / 2; zOff <= -currentEdgeRadius / 2; ++zOff) {
            for (xOff = -currentEdgeRadius / 2; xOff <= currentEdgeRadius / 2; ++xOff) {
                if (rand.nextInt(3) >= 1) continue;
                this.setBlockState(world, new BlockPos(x + xOff, y, z + zOff), state);
            }
            ++currentEdgeRadius;
        }
        for (zOff = -currentEdgeRadius / 2; zOff <= currentEdgeRadius / 2; ++zOff) {
            for (xOff = -currentEdgeRadius / 2; xOff <= currentEdgeRadius / 2; ++xOff) {
                if (rand.nextInt(3) >= 1) continue;
                this.setBlockState(world, new BlockPos(x + xOff, y, z + zOff), state);
            }
        }
        for (zOff = currentEdgeRadius / 2; zOff <= numDiag + currentEdgeRadius / 2; ++zOff) {
            for (xOff = -(--currentEdgeRadius) / 2; xOff <= currentEdgeRadius / 2; ++xOff) {
                if (rand.nextInt(3) >= 1) continue;
                this.setBlockState(world, new BlockPos(x + xOff, y, z + zOff), state);
            }
        }
        return true;
    }

    private void setBlockState(ISeedReader world, BlockPos pos, BlockState state) {
        world.func_180501_a(pos, state, 2);
    }
}

