/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.world.gen.ore;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.item.BlockItem;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.commons.lang3.reflect.FieldUtils;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryBiomes;
import zmaster587.libVulpes.api.material.AllowedProducts;
import zmaster587.libVulpes.api.material.MaterialRegistry;

public class OreGen {
    public static final ConfiguredFeature<?, ?> COPPER_ORE = OreGen.register("ore_copper", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((BlockItem)MaterialRegistry.getMaterialFromName((String)"copper").getProduct(AllowedProducts.getProductByName((String)"ORE")).func_77973_b()).func_179223_d().func_176223_P(), ((Integer)ARConfiguration.getCurrentConfig().copperClumpSize.get()).intValue())).func_242733_d(128)).func_242728_a()).func_242731_b(40)).func_242729_a(((Integer)ARConfiguration.getCurrentConfig().copperPerChunk.get()).intValue()));
    public static final ConfiguredFeature<?, ?> TIN_ORE = OreGen.register("ore_tin", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((BlockItem)MaterialRegistry.getMaterialFromName((String)"tin").getProduct(AllowedProducts.getProductByName((String)"ORE")).func_77973_b()).func_179223_d().func_176223_P(), ((Integer)ARConfiguration.getCurrentConfig().tinClumpSize.get()).intValue())).func_242733_d(128)).func_242728_a()).func_242731_b(20)).func_242729_a(((Integer)ARConfiguration.getCurrentConfig().tinPerChunk.get()).intValue()));
    public static final ConfiguredFeature<?, ?> RUTILE_ORE = OreGen.register("ore_rutile", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((BlockItem)MaterialRegistry.getMaterialFromName((String)"rutile").getProduct(AllowedProducts.getProductByName((String)"ORE")).func_77973_b()).func_179223_d().func_176223_P(), ((Integer)ARConfiguration.getCurrentConfig().rutileClumpSize.get()).intValue())).func_242733_d(80)).func_242728_a()).func_242731_b(20)).func_242729_a(((Integer)ARConfiguration.getCurrentConfig().rutilePerChunk.get()).intValue()));
    public static final ConfiguredFeature<?, ?> ALUMINUM_ORE = OreGen.register("ore_aluminum", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((BlockItem)MaterialRegistry.getMaterialFromName((String)"aluminum").getProduct(AllowedProducts.getProductByName((String)"ORE")).func_77973_b()).func_179223_d().func_176223_P(), ((Integer)ARConfiguration.getCurrentConfig().aluminumClumpSize.get()).intValue())).func_242733_d(80)).func_242728_a()).func_242731_b(20)).func_242729_a(((Integer)ARConfiguration.getCurrentConfig().aluminumPerChunk.get()).intValue()));
    public static final ConfiguredFeature<?, ?> DILITHIUM_ORE = OreGen.register("ore_dilithium", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((BlockItem)MaterialRegistry.getMaterialFromName((String)"dilithium").getProduct(AllowedProducts.getProductByName((String)"ORE")).func_77973_b()).func_179223_d().func_176223_P(), ((Integer)ARConfiguration.getCurrentConfig().dilithiumClumpSize.get()).intValue())).func_242733_d(80)).func_242728_a()).func_242731_b(20)).func_242729_a(((Integer)ARConfiguration.getCurrentConfig().dilithiumPerChunk.get()).intValue()));
    private static final int UNDERGROUND_ORES = GenerationStage.Decoration.UNDERGROUND_ORES.ordinal();

    private static <FC extends IFeatureConfig> ConfiguredFeature<FC, ?> register(String p_243968_0_, ConfiguredFeature<FC, ?> p_243968_1_) {
        return (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)p_243968_0_, p_243968_1_);
    }

    public static void injectOreGen() {
        Field features = ObfuscationReflectionHelper.findField(BiomeGenerationSettings.class, (String)"field_242484_f");
        OreGen.setMutable(features);
        OreGen.updateAllFeatures(features);
        AdvancedRocketryBiomes.getAllBiomes().forEachRemaining(biome -> {
            if (((Boolean)ARConfiguration.getCurrentConfig().generateCopper.get()).booleanValue()) {
                OreGen.getOreFeatures(biome).add(() -> COPPER_ORE);
            }
            if (((Boolean)ARConfiguration.getCurrentConfig().generateTin.get()).booleanValue()) {
                OreGen.getOreFeatures(biome).add(() -> TIN_ORE);
            }
            if (((Boolean)ARConfiguration.getCurrentConfig().generateRutile.get()).booleanValue()) {
                OreGen.getOreFeatures(biome).add(() -> RUTILE_ORE);
            }
            if (((Boolean)ARConfiguration.getCurrentConfig().generateAluminum.get()).booleanValue()) {
                OreGen.getOreFeatures(biome).add(() -> ALUMINUM_ORE);
            }
            if (((Boolean)ARConfiguration.getCurrentConfig().generateDilithium.get()).booleanValue()) {
                OreGen.getOreFeatures(biome).add(() -> DILITHIUM_ORE);
            }
        });
    }

    private static void updateAllFeatures(Field features) {
        for (Biome b : WorldGenRegistries.field_243657_i) {
            BiomeGenerationSettings settings = b.func_242440_e();
            List current = (List)OreGen.getValue(features, settings);
            List values = Collections.synchronizedList(new LinkedList());
            current.forEach(list -> values.add(new LinkedList(list)));
            OreGen.setValue(features, settings, values);
        }
    }

    public static <T> T getValue(Field f, Object instance) {
        try {
            return (T)f.get(instance);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void setValue(Field f, Object instance, Object value) {
        try {
            f.set(instance, value);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private static List<Supplier<ConfiguredFeature<?, ?>>> getOreFeatures(Biome b) {
        List features = b.func_242440_e().func_242498_c();
        while (features.size() <= UNDERGROUND_ORES) {
            features.add(new LinkedList());
        }
        return (List)features.get(UNDERGROUND_ORES);
    }

    public static void setMutable(Field f) {
        FieldUtils.removeFinalModifier((Field)f, (boolean)true);
    }
}

