/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.world.util;

import java.util.HashMap;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import zmaster587.advancedRocketry.api.DataStorage;
import zmaster587.advancedRocketry.api.satellite.IDataHandler;

public class MultiData
implements IDataHandler {
    HashMap<DataStorage.DataType, DataStorage> dataStorages = new HashMap();

    public MultiData() {
        this.reset();
    }

    public void reset() {
        for (DataStorage.DataType type : DataStorage.DataType.values()) {
            if (type == DataStorage.DataType.UNDEFINED) continue;
            this.dataStorages.put(type, new DataStorage(type));
        }
    }

    public int getDataAmount(DataStorage.DataType type) {
        return this.dataStorages.get((Object)type).getData();
    }

    @Override
    public int extractData(int maxAmount, DataStorage.DataType type, Direction dir, boolean commit) {
        DataStorage storage = this.dataStorages.get((Object)type);
        if (storage == null) {
            return 0;
        }
        return storage.removeData(maxAmount, commit);
    }

    @Override
    public int addData(int maxAmount, DataStorage.DataType type, Direction dir, boolean commit) {
        DataStorage storage = this.dataStorages.get((Object)type);
        if (storage == null) {
            return 0;
        }
        return storage.addData(maxAmount, type, commit);
    }

    public void setMaxData(int amount) {
        for (DataStorage.DataType type : DataStorage.DataType.values()) {
            if (type == DataStorage.DataType.UNDEFINED) continue;
            this.dataStorages.get((Object)type).setMaxData(amount);
        }
    }

    public int getMaxData() {
        return this.dataStorages.get((Object)DataStorage.DataType.ATMOSPHEREDENSITY).getMaxData();
    }

    public DataStorage getDataStorageForType(DataStorage.DataType dataType) {
        return this.dataStorages.get((Object)dataType);
    }

    public void setDataAmount(int amount, DataStorage.DataType dataType) {
        if (dataType != DataStorage.DataType.UNDEFINED) {
            this.dataStorages.get((Object)dataType).setData(amount, dataType);
        }
    }

    public void writeToNBT(CompoundNBT nbt) {
        for (DataStorage.DataType type : DataStorage.DataType.values()) {
            if (type == DataStorage.DataType.UNDEFINED) continue;
            CompoundNBT dataNBT = new CompoundNBT();
            this.dataStorages.get((Object)type).writeToNBT(dataNBT);
            nbt.func_218657_a(type.name(), (INBT)dataNBT);
        }
    }

    public void readFromNBT(CompoundNBT nbt) {
        for (DataStorage.DataType type : DataStorage.DataType.values()) {
            if (type == DataStorage.DataType.UNDEFINED) continue;
            CompoundNBT dataNBT = nbt.func_74775_l(type.name());
            this.dataStorages.get((Object)type).readFromNBT(dataNBT);
        }
    }
}

