/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.api.material;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import zmaster587.libVulpes.api.LibVulpesBlocks;
import zmaster587.libVulpes.api.material.AllowedProducts;
import zmaster587.libVulpes.api.material.Material;
import zmaster587.libVulpes.api.material.MixedMaterial;
import zmaster587.libVulpes.block.BlockOre;
import zmaster587.libVulpes.items.ItemMaterialBlock;
import zmaster587.libVulpes.items.ItemOreProduct;
import zmaster587.libVulpes.util.ItemStackMapping;

public class MaterialRegistry {
    static HashMap<Object, MixedMaterial> mixedMaterialList = new HashMap();
    static HashMap<AllowedProducts, List<Block>> productBlockListMapping;
    static List<MaterialRegistry> registries;
    @OnlyIn(value=Dist.CLIENT)
    static Object oreProductColorizer;
    public HashMap<String, Material> strToMaterial = new HashMap();
    public List<Material> materialList = new LinkedList<Material>();
    public HashMap<AllowedProducts, HashMap<Material, Item>> oreProducts;

    public MaterialRegistry() {
        productBlockListMapping = new HashMap();
        registries.add(this);
    }

    public void registerMaterial(Material material) {
        this.strToMaterial.put(material.getUnlocalizedName(), material);
        material.setIndex(this.materialList.size());
        material.registry = this;
        this.materialList.add(material);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void init() {
    }

    public void registerOres(ItemGroup tab) {
        List<AllowedProducts> allAllowedProducts = AllowedProducts.getAllAllowedProducts();
        this.oreProducts = new HashMap();
        for (int i = 0; i < allAllowedProducts.size(); ++i) {
            HashMap<Material, ItemOreProduct> productToItem = new HashMap<Material, ItemOreProduct>();
            this.oreProducts.put(AllowedProducts.getAllAllowedProducts().get(i), productToItem);
            AllowedProducts product = allAllowedProducts.get(i);
            for (int j = 0; j < this.materialList.size(); ++j) {
                Object item;
                Material mat = this.materialList.get(j);
                if (!product.isOfType(mat.getAllowedProducts())) continue;
                String productName = product.name().toLowerCase(Locale.ENGLISH);
                Item.Properties itemProps = new Item.Properties();
                itemProps.func_200916_a(tab);
                if (allAllowedProducts.get(i).isBlock()) {
                    AbstractBlock.Properties oreProperties = AbstractBlock.Properties.func_200945_a((net.minecraft.block.material.Material)net.minecraft.block.material.Material.field_151576_e).func_200943_b(4.0f);
                    oreProperties.harvestTool(mat.getTool());
                    oreProperties.harvestLevel(mat.getHarvestLevel());
                    BlockOre metalBlocks = new BlockOre(oreProperties, product, mat);
                    metalBlocks.setRegistryName(productName + mat.unlocalizedName);
                    LibVulpesBlocks.registerBlock(metalBlocks);
                    this.getBlockListForProduct(allAllowedProducts.get(i)).add(metalBlocks);
                    item = new ItemMaterialBlock(metalBlocks, itemProps, mat);
                    productToItem.put(mat, (ItemOreProduct)((Object)item));
                    LibVulpesBlocks.registerItem((Item)item.setRegistryName(productName + mat.unlocalizedName));
                    for (int g = 0; g < mat.getOreDictNames().length; ++g) {
                        String str = mat.getOreDictNames()[g];
                        BlockTags.func_199896_a().func_241834_b(new ResourceLocation("forge:" + productName + "s/" + str)).func_230235_a_((Object)metalBlocks);
                    }
                    BlockTags.func_199896_a().func_241834_b(new ResourceLocation("libvulpes", "block" + productName)).func_230235_a_((Object)metalBlocks);
                } else {
                    item = new ItemOreProduct(itemProps, mat);
                    productToItem.put(mat, (ItemOreProduct)((Object)item));
                    LibVulpesBlocks.registerItem((Item)item.setRegistryName(productName + mat.unlocalizedName));
                }
                for (int g = 0; g < mat.getOreDictNames().length; ++g) {
                    String str = mat.getOreDictNames()[g];
                    ItemTags.func_199903_a().func_241834_b(new ResourceLocation("forge:" + productName + "s/" + str)).func_230235_a_(item);
                }
            }
        }
    }

    public List<Block> getBlockListForProduct(AllowedProducts product) {
        return productBlockListMapping.get(product);
    }

    public Block getBlockForProduct(AllowedProducts product, Material material, int index) {
        for (Block block : productBlockListMapping.get(product)) {
            if (((BlockOre)block).field_149764_J != material) continue;
            return block;
        }
        return null;
    }

    public static Material getMaterialFromItemStack(ItemStack stack) {
        Item item = stack.func_77973_b();
        for (MaterialRegistry registry : registries) {
            Collection tags = ItemTags.func_199903_a().func_199913_a((Object)stack.func_77973_b());
            for (Material ore : registry.materialList) {
                for (String str : ore.getOreDictNames()) {
                    for (ResourceLocation i : tags) {
                        if (!i.func_110623_a().contains(str)) continue;
                        return ore;
                    }
                }
            }
        }
        return null;
    }

    public static ItemStack getItemStackFromMaterialAndType(String material, AllowedProducts product) {
        return MaterialRegistry.getItemStackFromMaterialAndType(material, product, 1);
    }

    public static ItemStack getItemStackFromMaterialAndType(String ore, AllowedProducts product, int amount) {
        for (MaterialRegistry registry : registries) {
            Material ore2 = registry.strToMaterial.get(ore);
            if (!registry.oreProducts.containsKey(product) || !registry.oreProducts.get(product).containsKey(ore2)) continue;
            return new ItemStack((IItemProvider)registry.oreProducts.get(product).get(ore2), amount);
        }
        return null;
    }

    public static void registerMixedMaterial(MixedMaterial material) {
        if (material.getInput() instanceof ItemStack) {
            mixedMaterialList.put(new ItemStackMapping((ItemStack)material.getInput()), material);
        } else {
            mixedMaterialList.put(material.getInput(), material);
        }
    }

    public MixedMaterial getMixedMaterial(ItemStack stack) {
        return mixedMaterialList.get(new ItemStackMapping(stack));
    }

    public MixedMaterial getMixedMaterial(String str) {
        return mixedMaterialList.get(str);
    }

    public static int getColorFromItemMaterial(ItemStack stack) {
        Material material = MaterialRegistry.getMaterialFromItemStack(stack);
        if (material == null) {
            return 0x7A7A7A;
        }
        return material.getColor();
    }

    public static Collection<MixedMaterial> getMixedMaterialList() {
        return mixedMaterialList.values();
    }

    public static Material getMaterialFromName(String string) {
        for (MaterialRegistry registry : registries) {
            Material material = registry.strToMaterial.get(string.toLowerCase());
            if (material == null) continue;
            return material;
        }
        return null;
    }

    public static List<Material> getAllMaterials() {
        LinkedList<Material> list = new LinkedList<Material>();
        for (MaterialRegistry registry : registries) {
            list.addAll(registry.materialList);
        }
        return list;
    }

    static {
        registries = new LinkedList<MaterialRegistry>();
    }
}

