/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.block;

import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import zmaster587.libVulpes.api.ITimeModifier;
import zmaster587.libVulpes.block.RotatableBlock;

public class BlockMotor
extends RotatableBlock
implements ITimeModifier {
    float timeModifier;
    static final VoxelShape HOLLOW_CUBE = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);

    public BlockMotor(AbstractBlock.Properties properties, float timeMultiplier) {
        super(properties);
        this.timeModifier = timeMultiplier;
    }

    @Override
    public float getTimeMult() {
        return this.timeModifier;
    }

    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new StringTextComponent(String.format(TextFormatting.GRAY + "Machine Speed: %.2f", Float.valueOf(1.0f / this.getTimeMult()))));
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return HOLLOW_CUBE;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return super.getPickBlock(state.func_177230_c().func_176223_P(), target, world, pos, player);
    }
}

