/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import zmaster587.libVulpes.block.RotatableBlock;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.util.IAdjBlockUpdate;

public class BlockTile
extends RotatableBlock {
    protected TileEntityType<?> tileClass;
    protected GuiHandler.guiId guiId;
    public static final BooleanProperty STATE = BooleanProperty.func_177716_a((String)"state");

    public BlockTile(AbstractBlock.Properties properties, GuiHandler.guiId guiId2) {
        super(properties);
        this.guiId = guiId2;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)STATE, (Comparable)Boolean.valueOf(false)));
    }

    public BlockTile _setTile(TileEntityType<?> tileClass) {
        this.tileClass = tileClass;
        return this;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, STATE});
    }

    public void setBlockState(World world, BlockState state, BlockPos pos, boolean newState) {
        world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)STATE, (Comparable)Boolean.valueOf(newState)), 2);
        world.func_225319_b(pos, state, (BlockState)state.func_206870_a((Property)STATE, (Comparable)Boolean.valueOf(newState)));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return this.tileClass.func_200968_a();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) != null) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)te), buf -> {
                buf.writeInt(((IModularInventory)te).getModularInvType().ordinal());
                buf.func_179255_a(pos);
            });
        }
        return ActionResultType.SUCCESS;
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, world, pos, neighbor);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IAdjBlockUpdate) {
            ((IAdjBlockUpdate)tile).onAdjacentBlockUpdated();
        }
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_203425_a(newState.func_177230_c())) {
            return;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (!world.func_201670_d() && tile instanceof IInventory) {
            IInventory inventory = (IInventory)tile;
            for (int i1 = 0; i1 < inventory.func_70302_i_(); ++i1) {
                ItemStack itemstack = inventory.func_70301_a(i1);
                if (itemstack.func_190926_b()) continue;
                float f = world.func_201674_k().nextFloat() * 0.8f + 0.1f;
                float f1 = world.func_201674_k().nextFloat() * 0.8f + 0.1f;
                float f2 = world.func_201674_k().nextFloat() * 0.8f + 0.1f;
                while (itemstack.func_190916_E() > 0) {
                    int j1 = world.func_201674_k().nextInt(21) + 10;
                    if (j1 > itemstack.func_190916_E()) {
                        j1 = itemstack.func_190916_E();
                    }
                    Item oldItem = itemstack.func_77973_b();
                    ItemStack oldStack = itemstack.func_77946_l();
                    itemstack.func_190920_e(itemstack.func_190916_E() - j1);
                    ItemEntity entityitem = new ItemEntity(world, (double)((float)pos.func_177958_n() + f), (double)((float)pos.func_177956_o() + f1), (double)((float)pos.func_177952_p() + f2), new ItemStack((IItemProvider)oldItem, j1, itemstack.func_77978_p()));
                    float f3 = 0.05f;
                    entityitem.func_213293_j((double)((float)world.func_201674_k().nextGaussian() * f3), (double)((float)world.func_201674_k().nextGaussian() * f3 + 0.2f), (double)((float)world.func_201674_k().nextGaussian() * f3));
                    if (oldStack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d(oldStack.func_77978_p().func_74737_b());
                    }
                    world.func_217376_c((Entity)entityitem);
                    world.func_217376_c((Entity)entityitem);
                }
            }
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public GuiHandler.guiId getGuid() {
        return this.guiId;
    }
}

