/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.block.multiblock;

import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import zmaster587.libVulpes.block.BlockTile;
import zmaster587.libVulpes.block.multiblock.IHidableBlock;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.tile.multiblock.TileMultiBlock;

public class BlockMultiblockMachine
extends BlockTile
implements IHidableBlock {
    public static final BooleanProperty VISIBLE = BooleanProperty.func_177716_a((String)"visible");

    public BlockMultiblockMachine(AbstractBlock.Properties property, GuiHandler.guiId guiId2) {
        super(property, guiId2);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{VISIBLE});
    }

    @Override
    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileMultiBlock tileMulti;
        if (state.func_203425_a(newState.func_177230_c())) {
            return;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileMultiBlock && (tileMulti = (TileMultiBlock)tile).isComplete()) {
            tileMulti.deconstructMultiBlock(world, pos, false, state);
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    @Override
    public void hideBlock(World world, BlockPos pos, BlockState state) {
        world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)VISIBLE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void showBlock(World world, BlockPos pos, BlockState state) {
        world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)VISIBLE, (Comparable)Boolean.valueOf(true)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        Style style = Style.field_240709_b_.func_240712_a_(TextFormatting.DARK_GRAY).func_240712_a_(TextFormatting.ITALIC);
        tooltip.add((ITextComponent)new TranslationTextComponent("machine.tooltip.multiblock").func_240703_c_(style));
    }

    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return super.func_200122_a(state, adjacentBlockState, side) || (Boolean)state.func_177229_b((Property)VISIBLE) == false;
    }

    public boolean func_208619_r() {
        return true;
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)VISIBLE) != false ? state.func_196954_c(worldIn, pos) : VoxelShapes.func_197880_a();
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileMultiBlock) {
            TileMultiBlock tileMulti = (TileMultiBlock)tile;
            if (tileMulti.isComplete() && !worldIn.field_72995_K) {
                if (tile instanceof IModularInventory) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)tileMulti), buf -> {
                        buf.writeInt(((IModularInventory)tile).getModularInvType().ordinal());
                        buf.func_179255_a(pos);
                    });
                }
            } else {
                return tileMulti.attemptCompleteStructure(state) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
            }
        }
        return ActionResultType.SUCCESS;
    }
}

