/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.client.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ProgressBarImage {
    protected ResourceLocation image;
    protected int backOffsetX;
    protected int backOffsetY;
    protected int foreOffsetX;
    protected int foreOffsetY;
    protected int backWidth;
    protected int backHeight;
    protected int foreWidth;
    protected int foreHeight;
    protected int insetX;
    protected int insetY;
    Direction direction;

    public ProgressBarImage(int backOffsetX, int backOffsetY, int backWidth, int backHeight, int foreOffsetX, int foreOffsetY, int foreWidth, int foreHeight, int insetX, int insetY, Direction direction, ResourceLocation image) {
        this.backOffsetX = backOffsetX;
        this.backOffsetY = backOffsetY;
        this.backWidth = backWidth;
        this.backHeight = backHeight;
        this.foreOffsetX = foreOffsetX;
        this.foreOffsetY = foreOffsetY;
        this.foreHeight = foreHeight;
        this.foreWidth = foreWidth;
        this.insetX = insetX;
        this.insetY = insetY;
        this.direction = direction;
        this.image = image;
    }

    public ProgressBarImage(int backOffsetX, int backOffsetY, int backWidth, int backHeight, int foreOffsetX, int foreOffsetY, int foreWidth, int foreHeight, Direction direction, ResourceLocation image) {
        this(backOffsetX, backOffsetY, backWidth, backHeight, foreOffsetX, foreOffsetY, foreWidth, foreHeight, 0, 0, direction, image);
    }

    public ProgressBarImage(int backOffsetX, int backOffsetY, int backWidth, int backHeight, int foreOffsetX, int foreOffsetY, Direction direction, ResourceLocation image) {
        this(backOffsetX, backOffsetY, backWidth, backHeight, foreOffsetX, foreOffsetY, backWidth, backHeight, 0, 0, direction, image);
    }

    public ResourceLocation getResourceLocation() {
        return this.image;
    }

    public int getBackOffsetX() {
        return this.backOffsetX;
    }

    public int getBackOffsetY() {
        return this.backOffsetY;
    }

    public int getForeOffsetX() {
        return this.foreOffsetX;
    }

    public int getForeOffsetY() {
        return this.foreOffsetY;
    }

    public int getBackWidth() {
        return this.backWidth;
    }

    public int getBackHeight() {
        return this.backHeight;
    }

    public int getForeWidth() {
        return this.foreWidth;
    }

    public int getForeHeight() {
        return this.foreHeight;
    }

    public int getInsetX() {
        return this.insetX;
    }

    public int getInsetY() {
        return this.insetY;
    }

    public Direction getDirection() {
        return this.direction;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderProgressBarPartial(MatrixStack mat, int x, int y, float center, float variation, ContainerScreen<?> gui) {
        float change;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.image);
        gui.func_238474_b_(mat, x, y, this.backOffsetX, this.backOffsetY, this.backWidth, this.backHeight);
        if (center - variation / 2.0f < 0.0f) {
            change = center - variation / 2.0f;
            center -= change / 2.0f;
            variation += change;
        }
        if (center + variation / 2.0f > 1.0f) {
            change = 1.0f - center - variation / 2.0f;
            center += change / 2.0f;
            variation -= change;
        }
        if (this.direction == Direction.EAST) {
            gui.func_238474_b_(mat, x + this.insetX + (int)((float)this.foreWidth * (1.0f - center - variation / 2.0f)), y + this.insetY, this.foreOffsetX + (int)((1.0f - variation / 2.0f - center) * (float)this.foreWidth), this.foreOffsetY, (int)(variation * (float)this.foreWidth), this.foreHeight);
        } else if (this.direction == Direction.UP) {
            gui.func_238474_b_(mat, x + this.insetX, y + this.insetY + this.foreHeight - (int)(variation * (float)this.foreHeight), this.foreOffsetX, this.foreOffsetY + this.foreHeight - (int)(variation * (float)this.foreHeight), this.foreWidth, (int)(variation * (float)this.foreHeight));
        } else if (this.direction == Direction.DOWN) {
            gui.func_238474_b_(mat, x + this.insetX, y + this.insetY, this.foreOffsetX, this.foreOffsetY, this.foreWidth, (int)(variation * (float)this.foreHeight));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderProgressBar(MatrixStack mat, int x, int y, float percent, AbstractGui gui) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.image);
        gui.func_238474_b_(mat, x, y, this.backOffsetX, this.backOffsetY, this.backWidth, this.backHeight);
        if (this.direction == Direction.EAST) {
            gui.func_238474_b_(mat, x + this.insetX, y + this.insetY, this.foreOffsetX, this.foreOffsetY, (int)(percent * (float)this.foreWidth), this.foreHeight);
        } else if (this.direction == Direction.WEST) {
            gui.func_238474_b_(mat, x + this.insetX + this.foreWidth - (int)(percent * (float)this.foreWidth), y + this.insetY, this.foreOffsetX + this.foreWidth - (int)(percent * (float)this.foreWidth), this.foreOffsetY, (int)(percent * (float)this.foreWidth), this.foreHeight);
        } else if (this.direction == Direction.UP) {
            gui.func_238474_b_(mat, x + this.insetX, y + this.insetY + this.foreHeight - (int)(percent * (float)this.foreHeight), this.foreOffsetX, this.foreOffsetY + this.foreHeight - (int)(percent * (float)this.foreHeight), this.foreWidth, (int)(percent * (float)this.foreHeight));
        } else if (this.direction == Direction.DOWN) {
            gui.func_238474_b_(mat, x + this.insetX, y + this.insetY, this.foreOffsetX, this.foreOffsetY, this.foreWidth, (int)(percent * (float)this.foreHeight));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderProgressBar(int x, int zLevel, int y, float percent) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.image);
        this.blit(x, zLevel, y, this.backOffsetX, this.backOffsetY, this.backWidth, this.backHeight);
        if (this.direction == Direction.EAST) {
            this.blit(x + this.insetX, zLevel, y + this.insetY, this.foreOffsetX, this.foreOffsetY, (int)(percent * (float)this.foreWidth), this.foreHeight);
        } else if (this.direction == Direction.WEST) {
            this.blit(x + this.insetX + this.foreWidth - (int)(percent * (float)this.foreWidth), zLevel, y + this.insetY, this.foreOffsetX + this.foreWidth - (int)(percent * (float)this.foreWidth), this.foreOffsetY, (int)(percent * (float)this.foreWidth), this.foreHeight);
        } else if (this.direction == Direction.UP) {
            this.blit(x + this.insetX, zLevel, y + this.insetY + this.foreHeight - (int)(percent * (float)this.foreHeight), this.foreOffsetX, this.foreOffsetY + this.foreHeight - (int)(percent * (float)this.foreHeight), this.foreWidth, (int)(percent * (float)this.foreHeight));
        } else if (this.direction == Direction.DOWN) {
            this.blit(x + this.insetX, zLevel, y + this.insetY, this.foreOffsetX, this.foreOffsetY, this.foreWidth, (int)(percent * (float)this.foreHeight));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void blit(int x, int zLevel, int y, int textureX, int textureY, int width, int height) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_225582_a_((double)(x + 0), (double)(y + height), (double)zLevel).func_225583_a_((float)(textureX + 0) * 0.00390625f, (float)(textureY + height) * 0.00390625f).func_181675_d();
        vertexbuffer.func_225582_a_((double)(x + width), (double)(y + height), (double)zLevel).func_225583_a_((float)(textureX + width) * 0.00390625f, (float)(textureY + height) * 0.00390625f).func_181675_d();
        vertexbuffer.func_225582_a_((double)(x + width), (double)(y + 0), (double)zLevel).func_225583_a_((float)(textureX + width) * 0.00390625f, (float)(textureY + 0) * 0.00390625f).func_181675_d();
        vertexbuffer.func_225582_a_((double)(x + 0), (double)(y + 0), (double)zLevel).func_225583_a_((float)(textureX + 0) * 0.00390625f, (float)(textureY + 0) * 0.00390625f).func_181675_d();
        tessellator.func_78381_a();
    }
}

