/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.event;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BucketHandler {
    public static final BucketHandler INSTANCE = new BucketHandler();
    private static Map<Block, Item> bucketMap = new HashMap<Block, Item>();
    private static Map<Fluid, Item> itemMap = new HashMap<Fluid, Item>();

    @SubscribeEvent
    public void onBucketFill(FillBucketEvent event) {
        if (event.getTarget() == null || RayTraceResult.Type.BLOCK != event.getTarget().func_216346_c()) {
            return;
        }
        BlockState state = event.getWorld().func_180495_p(new BlockPos(event.getTarget().func_216347_e()));
        Block block = state.func_177230_c();
        Item bucket = bucketMap.get(block);
        if (bucket != null && state.equals(block.func_176223_P())) {
            event.getWorld().func_175656_a(new BlockPos(event.getTarget().func_216347_e()), Blocks.field_150350_a.func_176223_P());
            event.setFilledBucket(new ItemStack((IItemProvider)bucket));
            bucket.hasContainerItem(event.getFilledBucket());
            event.setResult(Event.Result.ALLOW);
        }
    }

    public Item getItemFromFluid(Fluid fluid) {
        return itemMap.get(fluid);
    }

    public void registerBucket(Block block, Item item, Fluid fluid) {
        bucketMap.put(block, item);
        itemMap.put(fluid, item);
    }
}

