/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.inventory;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IntReferenceHolder;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import zmaster587.libVulpes.api.LibvulpesGuiRegistry;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;

public class ContainerModular
extends Container {
    List<ModuleBase> modules;
    int numSlots;
    int numTrackers;
    IModularInventory modularInventory;
    public boolean includePlayerInv;
    public GuiHandler.guiId guid;

    public static ContainerModular createFromNetworkItem(int windowId, PlayerInventory invPlayer, PacketBuffer buf) {
        GuiHandler.guiId guid = GuiHandler.guiId.values()[buf.readInt()];
        int ID = guid.ordinal();
        ItemStack stack = GuiHandler.getHeldFromBuf(buf);
        IModularInventory modularItem = (IModularInventory)stack.func_77973_b();
        boolean includePlayerInv = GuiHandler.doesIncludePlayerInv(ID);
        boolean includeHotBar = GuiHandler.doesIncludeHotBar(ID);
        return new ContainerModular(LibvulpesGuiRegistry.CONTAINER_MODULAR_HELD_ITEM, windowId, invPlayer.field_70458_d, modularItem.getModules(ID, invPlayer.field_70458_d), modularItem, guid, includePlayerInv, includeHotBar);
    }

    public static ContainerModular createFromNetworkBlock(int windowId, PlayerInventory invPlayer, PacketBuffer buf) {
        GuiHandler.guiId guid = GuiHandler.guiId.values()[buf.readInt()];
        int ID = guid.ordinal();
        TileEntity tile = GuiHandler.getTeFromBuf(buf);
        IModularInventory modularItem = (IModularInventory)tile;
        boolean includePlayerInv = GuiHandler.doesIncludePlayerInv(ID);
        boolean includeHotBar = GuiHandler.doesIncludeHotBar(ID);
        return new ContainerModular(LibvulpesGuiRegistry.CONTAINER_MODULAR_TILE, windowId, invPlayer.field_70458_d, modularItem.getModules(ID, invPlayer.field_70458_d), modularItem, guid, includePlayerInv, includeHotBar);
    }

    public static ContainerModular createFromEntity(int windowId, PlayerInventory invPlayer, PacketBuffer buf) {
        GuiHandler.guiId guid = GuiHandler.guiId.values()[buf.readInt()];
        int ID = guid.ordinal();
        Entity tile = GuiHandler.getEntityFromBuf(buf);
        IModularInventory modularItem = (IModularInventory)tile;
        boolean includePlayerInv = GuiHandler.doesIncludePlayerInv(ID);
        boolean includeHotBar = GuiHandler.doesIncludeHotBar(ID);
        return new ContainerModular(LibvulpesGuiRegistry.CONTAINER_MODULAR_TILE, windowId, invPlayer.field_70458_d, modularItem.getModules(ID, invPlayer.field_70458_d), modularItem, guid, includePlayerInv, includeHotBar);
    }

    public ContainerModular(@Nullable ContainerType<?> type, int id, PlayerEntity playerInv, List<ModuleBase> modules, IModularInventory modulularInv, GuiHandler.guiId guid) {
        this(type, id, playerInv, modules, modulularInv, guid, GuiHandler.doesIncludePlayerInv(guid.ordinal()), GuiHandler.doesIncludeHotBar(guid.ordinal()));
    }

    public ContainerModular(@Nullable ContainerType<?> type, int id, PlayerEntity playerInv, List<ModuleBase> modules, IModularInventory modulularInv, GuiHandler.guiId guid, boolean includePlayerInv, boolean includeHotBar) {
        super(type, id);
        this.modularInventory = modulularInv;
        this.modules = modules;
        this.guid = guid;
        this.numSlots = 0;
        this.numTrackers = 0;
        this.includePlayerInv = includePlayerInv;
        for (ModuleBase module : modules) {
            for (Slot slot : module.getSlots(this)) {
                this.addSlotToContainer(slot);
                ++this.numSlots;
            }
            for (IntReferenceHolder intReferenceHolder : module.getIntTrackers(this)) {
                this.func_216958_a(intReferenceHolder);
                ++this.numTrackers;
            }
        }
        if (includePlayerInv) {
            for (int i1 = 0; i1 < 3; ++i1) {
                for (int l1 = 0; l1 < 9; ++l1) {
                    this.addSlotToContainer(new Slot((IInventory)playerInv.field_71071_by, l1 + i1 * 9 + 9, 8 + l1 * 18, 89 + i1 * 18));
                }
            }
        }
        if (includeHotBar) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.addSlotToContainer(new Slot((IInventory)playerInv.field_71071_by, j1, 8 + j1 * 18, 147));
            }
        }
    }

    public Slot addSlotToContainer(Slot slot) {
        return super.func_75146_a(slot);
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        int moduleIndex = 0;
        for (ModuleBase module : this.modules) {
            module.sendInitialChanges(this, listener, moduleIndex);
            moduleIndex += module.numberOfChangesToSend();
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        int moduleIndex = 0;
        for (ModuleBase module : this.modules) {
            for (int i = 0; i < module.numberOfChangesToSend(); ++i) {
                if (module.isUpdateRequired(i)) {
                    List listeners = (List)ObfuscationReflectionHelper.getPrivateValue(Container.class, (Object)((Object)this), (String)"field_75149_d");
                    for (int j = 0; j < listeners.size(); ++j) {
                        module.sendChanges(this, (IContainerListener)listeners.get(j), moduleIndex, i);
                    }
                }
                ++moduleIndex;
            }
        }
    }

    public void func_75137_b(int slot, int value) {
        int moduleIndex = 0;
        for (ModuleBase module : this.modules) {
            if (slot - moduleIndex < module.numberOfChangesToSend() && slot - moduleIndex >= 0) {
                module.onChangeRecieved(slot - moduleIndex, value);
            }
            moduleIndex += module.numberOfChangesToSend();
        }
    }

    public ItemStack func_82846_b(PlayerEntity player, int slotId) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotId);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (slotId < this.numSlots ? !this.func_75135_a(itemstack1, this.numSlots, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, slotId, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    public boolean func_75145_c(PlayerEntity player) {
        return this.modularInventory.canInteractWithContainer(player);
    }
}

