/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.inventory.modules;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import zmaster587.libVulpes.inventory.TextureResources;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IGuiCallback;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.util.BlockDirectionFunction;

public class ModuleBlockSideSelector
extends ModuleBase
implements IButtonInventory {
    private IGuiCallback callback;
    private ModuleButton[] buttons;
    private BlockDirectionFunction bdf;
    private String[] text;
    private static final String[] directions = new String[]{"Bottom: ", "Top: ", "North: ", "South ", "West: ", "East: "};
    private static final int[] colors = new int[]{56576, 0xDD0000, 221, 0xDDDD00, 0xDD00DD, 56797};

    public ModuleBlockSideSelector(int offsetX, int offsetY, IGuiCallback callback, String ... stateNames) {
        super(offsetX, offsetY);
        this.callback = callback;
        this.bdf = new BlockDirectionFunction(stateNames.length);
        this.text = stateNames;
        this.buttons = new ModuleButton[]{new ModuleButton(offsetX + 42, offsetY + 42, "", this, TextureResources.buttonSquare, directions[0] + stateNames[0], 16, 16), new ModuleButton(offsetX + 21, offsetY + 21, "", this, TextureResources.buttonSquare, directions[1] + stateNames[0], 16, 16), new ModuleButton(offsetX + 21, offsetY, "", this, TextureResources.buttonSquare, directions[2] + stateNames[0], 16, 16), new ModuleButton(offsetX + 21, offsetY + 42, "", this, TextureResources.buttonSquare, directions[3] + stateNames[0], 16, 16), new ModuleButton(offsetX, offsetY + 21, "", this, TextureResources.buttonSquare, directions[4] + stateNames[0], 16, 16), new ModuleButton(offsetX + 42, offsetY + 21, "", this, TextureResources.buttonSquare, directions[5] + stateNames[0], 16, 16)};
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            for (ModuleButton button : this.buttons) {
                button.setBGColor(colors[0]);
            }
        });
    }

    @Override
    public void actionPerform(Button button) {
        for (ModuleButton button2 : this.buttons) {
            button2.actionPerform(button);
        }
    }

    @Override
    public List<Button> addButtons(int x, int y) {
        List<Button> list = super.addButtons(x, y);
        for (int i = 0; i < 6; ++i) {
            list.addAll(this.buttons[i].addButtons(x, y));
        }
        return list;
    }

    @Override
    public void renderBackground(ContainerScreen<? extends Container> gui, MatrixStack matrix, int x, int y, int mouseX, int mouseY, FontRenderer font) {
        super.renderBackground(gui, matrix, x, y, mouseX, mouseY, font);
        for (ModuleButton button : this.buttons) {
            button.renderBackground(gui, matrix, x, y, mouseX, mouseY, font);
        }
    }

    @Override
    public void renderForeground(MatrixStack mat, int guiOffsetX, int guiOffsetY, int mouseX, int mouseY, float zLevel, ContainerScreen<? extends Container> gui, FontRenderer font) {
        super.renderForeground(mat, guiOffsetX, guiOffsetY, mouseX, mouseY, zLevel, gui, font);
        for (ModuleButton button : this.buttons) {
            ((ModuleBase)button).renderForeground(mat, guiOffsetX, guiOffsetY, mouseX, mouseY, zLevel, gui, font);
        }
    }

    public int getStateForSide(Direction side) {
        return this.getStateForSide(side.ordinal());
    }

    public int getStateForSide(int side) {
        return this.bdf.getState(side);
    }

    public void setStateForSide(Direction side, int state) {
        this.setStateForSide(side.ordinal(), state);
    }

    public void setStateForSide(int sideNum, int state) {
        this.bdf.setState(sideNum, state);
        if (EffectiveSide.get().isClient()) {
            this.buttons[sideNum].setBGColor(colors[this.bdf.getState(sideNum) % colors.length]);
            this.buttons[sideNum].setToolTipText(directions[sideNum] + this.text[this.bdf.getState(sideNum)]);
        }
    }

    public void write(CompoundNBT nbt) {
        this.bdf.write(nbt);
    }

    public void readFromNBT(CompoundNBT nbt) {
        this.bdf.readFromNBT(nbt);
        if (EffectiveSide.get().isClient()) {
            for (int i = 0; i < this.buttons.length; ++i) {
                this.buttons[i].setBGColor(colors[this.bdf.getState(i) % colors.length]);
                this.buttons[i].setToolTipText(directions[i] + this.text[this.bdf.getState(i)]);
            }
        }
    }

    @Override
    public void onInventoryButtonPressed(ModuleButton buttonId) {
        int index = 0;
        for (ModuleButton button : this.buttons) {
            if (button == buttonId) break;
            ++index;
        }
        this.bdf.advanceState(index);
        this.buttons[index].setBGColor(colors[this.bdf.getState(index) % colors.length]);
        this.buttons[index].setToolTipText(directions[index] + this.text[this.bdf.getState(index)]);
        this.callback.onModuleUpdated(this);
    }
}

