/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.inventory.modules;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import zmaster587.libVulpes.gui.GuiImageButton;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;

public class ModuleButton
extends ModuleBase {
    @OnlyIn(value=Dist.CLIENT)
    public GuiImageButton button;
    IButtonInventory tile;
    boolean prevState;
    public int buttonId;
    protected int color;
    protected int bgColor;
    protected String text;
    protected String tooltipText;
    ResourceLocation[] buttonImages;
    protected boolean visible = true;
    boolean enabled = true;
    protected String sound;
    Object additionalData;

    public ModuleButton(int offsetX, int offsetY, String text, IButtonInventory tile, ResourceLocation[] buttonImages) {
        super(offsetX, offsetY);
        this.tile = tile;
        this.buttonImages = buttonImages;
        this.text = text;
        this.buttonId = this.buttonId;
        this.sound = "";
        this.sizeX = 52;
        this.sizeY = 16;
        this.bgColor = -1;
        this.color = -14483678;
    }

    public ModuleButton(int offsetX, int offsetY, String text, IButtonInventory tile, ResourceLocation[] buttonImages, String tooltipText) {
        this(offsetX, offsetY, text, tile, buttonImages);
        this.tooltipText = tooltipText;
    }

    public ModuleButton(int offsetX, int offsetY, String text, IButtonInventory tile, ResourceLocation[] buttonImages, int sizeX, int sizeY) {
        this(offsetX, offsetY, text, tile, buttonImages);
        this.sizeX = sizeX;
        this.sizeY = sizeY;
    }

    public ModuleButton(int offsetX, int offsetY, String text, IButtonInventory tile, ResourceLocation[] buttonImages, String tooltipText, int sizeX, int sizeY) {
        this(offsetX, offsetY, text, tile, buttonImages, sizeX, sizeY);
        this.tooltipText = tooltipText;
    }

    public ModuleButton setAdditionalData(Object data) {
        this.additionalData = data;
        return this;
    }

    public Object getAdditionalData() {
        return this.additionalData;
    }

    public void setImage(ResourceLocation[] images) {
        this.button.setButtonTexture(images);
    }

    public void setSound(String str) {
        if (EffectiveSide.get().isClient()) {
            if (this.button == null) {
                this.sound = str;
            } else {
                this.button.setSound(str);
            }
        }
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setToolTipText(String text) {
        this.tooltipText = text;
    }

    public String getText() {
        return this.text;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public int getColor() {
        return this.color;
    }

    public void setBGColor(int color) {
        this.bgColor = color;
        if (this.button != null) {
            this.button.setBackgroundColor(this.bgColor);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
        if (this.button != null) {
            this.button.field_230694_p_ = visible;
        }
    }

    public boolean isVisible() {
        return this.button.field_230694_p_;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.button != null) {
            this.enabled = this.button.enabled = enabled;
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Button> addButtons(int x, int y) {
        LinkedList<Button> list = new LinkedList<Button>();
        this.button = new GuiImageButton(x + this.offsetX, y + this.offsetY, this.sizeX, this.sizeY, this.buttonImages);
        this.button.field_230694_p_ = this.visible;
        this.button.enabled = this.enabled;
        if (!this.sound.isEmpty()) {
            this.button.setSound(this.sound);
            this.sound = "";
        }
        this.button.setBackgroundColor(this.bgColor);
        list.add(this.button);
        return list;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void actionPerform(Button button) {
        if (this.enabled && button != null && button == this.button) {
            this.tile.onInventoryButtonPressed(this);
        }
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        int relativeX = mouseX - this.offsetX;
        int relativeY = mouseY - this.offsetY;
        return this.enabled && relativeX > 0 && relativeX < this.sizeX && relativeY > 0 && relativeY < this.sizeY;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderForeground(MatrixStack mat, int guiOffsetX, int guiOffsetY, int mouseX, int mouseY, float zLevel, ContainerScreen<? extends Container> gui, FontRenderer font) {
        if (this.visible) {
            int n = this.offsetX + this.sizeX / 2;
            int n2 = this.offsetY + this.sizeY / 2;
            font.getClass();
            ContainerScreen.func_238471_a_((MatrixStack)mat, (FontRenderer)font, (String)this.text, (int)n, (int)(n2 - 9 / 2), (int)this.color);
            if (this.tooltipText != null && this.isMouseOver(mouseX, mouseY)) {
                LinkedList<String> list = new LinkedList<String>();
                for (String str : this.tooltipText.split("\n")) {
                    list.add(str);
                }
                this.drawTooltip(gui, mat, list, mouseX, mouseY, zLevel, font);
            }
        }
    }
}

