/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.inventory.modules;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.lwjgl.opengl.GL11;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.inventory.GuiModular;
import zmaster587.libVulpes.inventory.modules.ModuleBase;

public class ModuleContainerPan
extends ModuleBase {
    protected int currentPosX;
    protected int currentPosY;
    protected int screenSizeX;
    protected int screenSizeY;
    protected int containerSizeX;
    protected int containerSizeY;
    protected List<ModuleBase> moduleList;
    protected List<ModuleBase> staticModuleList;
    protected List<Button> buttonList;
    protected List<Button> staticButtonList;
    protected List<Slot> slotList;
    protected double mouseLastX;
    protected double mouseLastY;
    boolean outofBounds;
    ResourceLocation backdrop;
    protected int internalOffsetX;
    protected int internalOffsetY;
    protected boolean mouseFirstDown = true;

    public ModuleContainerPan(int offsetX, int offsetY, List<ModuleBase> moduleList, List<ModuleBase> staticModules, ResourceLocation backdrop, int screenSizeX, int screenSizeY) {
        this(offsetX, offsetY, moduleList, staticModules, backdrop, screenSizeX, screenSizeY, 16, 16, 0, 0);
    }

    public ModuleContainerPan(int offsetX, int offsetY, List<ModuleBase> moduleList, List<ModuleBase> staticModules, ResourceLocation backdrop, int screenSizeX, int screenSizeY, int paddingX, int paddingY) {
        this(offsetX, offsetY, moduleList, staticModules, backdrop, screenSizeX, screenSizeY, paddingX, paddingY, 0, 0);
    }

    public ModuleContainerPan(int offsetX, int offsetY, List<ModuleBase> moduleList, List<ModuleBase> staticModules, ResourceLocation backdrop, int screenSizeX, int screenSizeY, int paddingX, int paddingY, int containerSizeX, int containerSizeY) {
        super(offsetX, offsetY);
        this.moduleList = moduleList;
        this.staticModuleList = staticModules;
        this.outofBounds = true;
        this.screenSizeX = screenSizeX;
        this.screenSizeY = screenSizeY;
        this.buttonList = new LinkedList<Button>();
        this.staticButtonList = new LinkedList<Button>();
        this.slotList = new LinkedList<Slot>();
        this.backdrop = backdrop;
        if (containerSizeX == 0 || containerSizeY == 0) {
            int maxX = 0;
            int maxY = 0;
            for (ModuleBase module : moduleList) {
                if (module.offsetX > maxX) {
                    maxX = module.offsetX;
                }
                if (module.offsetY <= maxY) continue;
                maxY = module.offsetY;
            }
            this.containerSizeX = maxX + paddingX;
            this.containerSizeY = maxY + paddingY;
        } else {
            this.containerSizeX = containerSizeX;
            this.containerSizeY = containerSizeY;
        }
        if (moduleList != null) {
            for (ModuleBase module : this.moduleList) {
                module.offsetX += offsetX;
                module.offsetY += offsetY;
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Button> addButtons(int x, int y) {
        this.buttonList.clear();
        this.staticButtonList.clear();
        for (ModuleBase module : this.moduleList) {
            this.buttonList.addAll(module.addButtons(0, 0));
        }
        for (ModuleBase module : this.staticModuleList) {
            this.staticButtonList.addAll(module.addButtons(x, y));
        }
        return new LinkedList<Button>();
    }

    public void setOffset(int x, int y) {
        this.internalOffsetX = x + this.screenSizeX;
        this.internalOffsetY = y + this.screenSizeY;
    }

    public void setOffset2(int x, int y) {
        int deltaX = -x - this.currentPosX;
        int deltaY = -y - this.currentPosY;
        this.currentPosX += deltaX;
        this.currentPosY += deltaY;
        try {
            Field xPos = ObfuscationReflectionHelper.findField(Slot.class, (String)"field_75223_e");
            Field yPos = ObfuscationReflectionHelper.findField(Slot.class, (String)"field_75221_f");
            xPos.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(xPos, xPos.getModifiers() & 0xFFFFFFEF);
            yPos.setAccessible(true);
            modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(yPos, yPos.getModifiers() & 0xFFFFFFEF);
            for (Slot slot : this.slotList) {
                xPos.setInt(slot, slot.field_75223_e + deltaX);
                yPos.setInt(slot, slot.field_75221_f + deltaY);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        for (Button button2 : this.buttonList) {
            button2.field_230690_l_ += deltaX;
            button2.field_230691_m_ += deltaY;
        }
        for (ModuleBase module : this.moduleList) {
            module.offsetX += deltaX;
            module.offsetY += deltaY;
        }
    }

    public int getScrollX() {
        return this.currentPosX;
    }

    public int getScrollY() {
        return this.currentPosY;
    }

    @Override
    public List<Slot> getSlots(Container container) {
        LinkedList<Slot> list = new LinkedList<Slot>();
        for (ModuleBase module : this.moduleList) {
            list.addAll(module.getSlots(container));
        }
        for (ModuleBase module : this.staticModuleList) {
            list.addAll(module.getSlots(container));
        }
        this.slotList = list;
        return list;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void actionPerform(Button button) {
        for (ModuleBase module : this.moduleList) {
            module.actionPerform(button);
        }
        for (ModuleBase module : this.staticModuleList) {
            module.actionPerform(button);
        }
    }

    public void onScroll(double dwheel) {
        if (dwheel < 0.0) {
            this.moveContainerInterior(0, -3);
        } else if (dwheel > 0.0) {
            this.moveContainerInterior(0, 3);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderForeground(MatrixStack mat, int guiOffsetX, int guiOffsetY, int mouseX, int mouseY, float zLevel, ContainerScreen<? extends Container> gui, FontRenderer font) {
        double scrollDelta = LibVulpes.proxy.getScrollDelta();
        if (this.isMouseInBounds(0, 0, mouseX, mouseY) && scrollDelta != 0.0) {
            this.onScroll(scrollDelta);
        }
        GL11.glEnable((int)3089);
        this.setUpScissor(gui, this.offsetX + guiOffsetX, guiOffsetY + this.offsetY, this.offsetX + this.screenSizeX, this.offsetY + this.screenSizeY);
        for (Button btn : this.buttonList) {
            btn.func_230430_a_(mat, mouseX, mouseY, zLevel);
        }
        for (Button btn : this.staticButtonList) {
            btn.func_230430_a_(mat, mouseX, mouseY, zLevel);
        }
        for (ModuleBase module : this.moduleList) {
            module.renderForeground(mat, guiOffsetX, guiOffsetY, mouseX, mouseY, zLevel, gui, font);
        }
        for (ModuleBase module : this.staticModuleList) {
            module.renderForeground(mat, guiOffsetX, guiOffsetY, mouseX, mouseY, zLevel, gui, font);
        }
        GL11.glDisable((int)3089);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void setUpScissor(ContainerScreen<Container> gui, int screenOffsetX, int screenOffsetY, int screenSizeX, int screenSizeY) {
        float multiplierX = (float)gui.getMinecraft().func_228018_at_().func_198105_m() / (float)gui.field_230708_k_;
        float multiplierY = (float)gui.getMinecraft().func_228018_at_().func_198083_n() / (float)gui.field_230709_l_;
        GL11.glScissor((int)((int)((float)screenOffsetX * multiplierX)), (int)(gui.getMinecraft().func_228018_at_().func_198083_n() - (int)((float)(screenOffsetY + screenSizeY) * multiplierY)), (int)((int)((float)screenSizeX * multiplierX)), (int)((int)((float)screenSizeY * multiplierY)));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onMouseClicked(GuiModular gui, double x, double y, int button) {
        super.onMouseClicked(gui, x, y, button);
        double scaledX = x;
        double scaledY = y;
        if (button == 0 && this.isMouseInBounds(0, 0, x, y)) {
            LinkedList<Button> fullButtonList = new LinkedList<Button>();
            fullButtonList.addAll(this.buttonList);
            fullButtonList.addAll(this.staticButtonList);
            for (IGuiEventListener iGuiEventListener : fullButtonList) {
                if (!iGuiEventListener.func_231047_b_(scaledX, scaledY)) continue;
                Button button2 = (Button)iGuiEventListener;
                button2.func_230988_a_(gui.getMinecraft().func_147118_V());
                gui.func_231035_a_((IGuiEventListener)button2);
            }
        }
        this.mouseFirstDown = true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean isMouseInBounds(int x, int y, double x2, double y2) {
        double transformedMouseX = x2 - (double)x - (double)this.offsetX;
        double transformedMouseY = y2 - (double)y - (double)this.offsetY;
        return transformedMouseX > 0.0 && transformedMouseX < (double)(this.screenSizeX + this.offsetX) && transformedMouseY > 0.0 && transformedMouseY < (double)(this.screenSizeY + this.offsetY);
    }

    protected void moveContainerInterior(int deltaX, int deltaY) {
        if (deltaX > 0) {
            deltaX = Math.min(deltaX, -this.currentPosX);
        } else if (deltaX < 0) {
            deltaX = Math.max(deltaX, -this.containerSizeX - this.currentPosX);
        }
        if (deltaY > 0) {
            deltaY = Math.min(deltaY, -this.currentPosY);
        } else if (deltaY < 0) {
            deltaY = Math.max(deltaY, -this.containerSizeY - this.currentPosY);
        }
        this.currentPosX += deltaX;
        this.currentPosY += deltaY;
        try {
            Field xPos = ObfuscationReflectionHelper.findField(Slot.class, (String)"field_75223_e");
            Field yPos = ObfuscationReflectionHelper.findField(Slot.class, (String)"field_75221_f");
            xPos.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(xPos, xPos.getModifiers() & 0xFFFFFFEF);
            yPos.setAccessible(true);
            modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(yPos, yPos.getModifiers() & 0xFFFFFFEF);
            for (Slot slot : this.slotList) {
                xPos.setInt(slot, slot.field_75223_e + deltaX);
                yPos.setInt(slot, slot.field_75221_f + deltaY);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        for (Button button2 : this.buttonList) {
            button2.field_230690_l_ += deltaX;
            button2.field_230691_m_ += deltaY;
        }
        for (ModuleBase module : this.moduleList) {
            module.offsetX += deltaX;
            module.offsetY += deltaY;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onMouseClickedAndDragged(double x, double y, int button) {
        if (this.isMouseInBounds(0, 0, x, y)) {
            if (this.outofBounds || this.mouseFirstDown) {
                this.mouseLastX = x;
                this.mouseLastY = y;
                this.outofBounds = false;
                this.mouseFirstDown = false;
            } else if (this.mouseLastX != x && this.mouseLastY != y) {
                int deltaX = (int)(x - this.mouseLastX);
                int deltaY = (int)(y - this.mouseLastY);
                this.moveContainerInterior(deltaX, deltaY);
                this.mouseLastX = x;
                this.mouseLastY = y;
            }
        } else {
            this.outofBounds = true;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderBackground(ContainerScreen<? extends Container> gui, MatrixStack mat, int x, int y, int mouseX, int mouseY, FontRenderer font) {
        GL11.glEnable((int)3089);
        this.setUpScissor(gui, x + this.offsetX, y + this.offsetY, this.screenSizeX + this.offsetX, this.screenSizeY + this.offsetY);
        if (this.backdrop != null) {
            gui.getMinecraft().func_110434_K().func_110577_a(this.backdrop);
            gui.func_238474_b_(mat, x + this.offsetX, y + this.offsetY, (int)(-0.1 * (double)this.currentPosX), (int)(-0.1 * (double)this.currentPosY), this.screenSizeX + this.offsetX, this.screenSizeY + this.offsetY);
        }
        for (Button button : this.buttonList) {
            button.func_230431_b_(mat, mouseX, mouseY, 0.0f);
        }
        for (Button button : this.staticButtonList) {
            button.func_230431_b_(mat, mouseX, mouseY, 0.0f);
        }
        for (ModuleBase module : this.moduleList) {
            module.renderBackground(gui, mat, x, y, mouseX, mouseY, font);
        }
        for (ModuleBase module : this.staticModuleList) {
            module.renderBackground(gui, mat, x, y, mouseX, mouseY, font);
        }
        GL11.glDisable((int)3089);
    }

    @Override
    public void setEnabled(boolean state) {
        if (state && !this.isEnabled()) {
            this.moveContainerInterior(10000, 0);
        } else if (!state && this.isEnabled()) {
            this.moveContainerInterior(-10000, 0);
        }
        super.setEnabled(state);
    }
}

