/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.inventory.modules;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import zmaster587.libVulpes.client.util.ProgressBarImage;
import zmaster587.libVulpes.inventory.modules.IProgressBar;
import zmaster587.libVulpes.inventory.modules.ModuleProgress;

public class ModuleDualProgressBar
extends ModuleProgress {
    private float multiplier = 1.0f;

    public ModuleDualProgressBar(int offsetX, int offsetY, int id, ProgressBarImage progressBar, IProgressBar progress) {
        super(offsetX, offsetY, id, progressBar, progress);
    }

    public ModuleDualProgressBar(int offsetX, int offsetY, int id, ProgressBarImage progressBar, IProgressBar progress, String tooltip) {
        super(offsetX, offsetY, id, progressBar, progress, tooltip);
    }

    public void setTooltipValueMultiplier(float multiplier) {
        this.multiplier = multiplier;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected List<String> getToolTip() {
        LinkedList<String> modifiedList = new LinkedList<String>();
        for (String string : this.tooltip) {
            int centerPoint = this.progress.getTotalProgress(this.id);
            int variation = this.progress.getProgress(this.id);
            String newStr = string.replaceAll("%b", String.format("%.2f", Float.valueOf(this.multiplier * (float)MathHelper.func_76125_a((int)(centerPoint - variation / 2), (int)0, (int)100))));
            newStr = newStr.replaceAll("%a", String.format("%.2f", Float.valueOf(this.multiplier * (float)MathHelper.func_76125_a((int)(centerPoint + variation / 2), (int)0, (int)100))));
            modifiedList.add(newStr);
        }
        return modifiedList;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderBackground(ContainerScreen<? extends Container> gui, MatrixStack mat, int x, int y, int mouseX, int mouseY, FontRenderer font) {
        float totalProgress = (float)this.progress.getTotalProgress(this.id) / 100.0f;
        float randomnessFactor = (float)this.progress.getProgress(this.id) / 100.0f;
        this.progressBar.renderProgressBarPartial(mat, x + this.offsetX, y + this.offsetY, totalProgress, 0.5f * randomnessFactor, gui);
    }
}

