/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.inventory.modules;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.LinkedList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.lwjgl.opengl.GL11;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.util.IFluidHandlerInternal;

public class ModuleLiquidIndicator
extends ModuleBase {
    IFluidHandler tile;
    IFluidHandlerInternal tile2;
    ResourceLocation fluidIcon = new ResourceLocation("advancedrocketry:textures/blocks/fluid/oxygen_flow.png");
    int prevLiquidUUID;
    int prevLiquidAmt;
    private static final int invalidFluid = -1;

    public ModuleLiquidIndicator(int offsetX, int offsetY, IFluidHandler progress) {
        super(offsetX, offsetY);
        this.tile = progress;
        if (progress instanceof IFluidHandlerInternal) {
            this.tile2 = (IFluidHandlerInternal)progress;
        }
    }

    @Override
    public int numberOfChangesToSend() {
        return 3;
    }

    private Fluid getFluid(int id) {
        for (Fluid fluid : ForgeRegistries.FLUIDS.getValues()) {
            if (ForgeRegistries.FLUIDS.getKey((IForgeRegistryEntry)fluid).hashCode() != id) continue;
            return fluid;
        }
        return Fluids.field_204546_a;
    }

    private int getFluidID(Fluid fluid) {
        return ForgeRegistries.FLUIDS.getKey((IForgeRegistryEntry)fluid).hashCode();
    }

    @Override
    public void sendChanges(Container container, IContainerListener crafter, int variableId, int localId) {
        FluidStack info = this.tile.getFluidInTank(0);
        if (localId == 0 && info != null) {
            crafter.func_71112_a(container, variableId, info.getAmount() & 0xFFFF);
        } else if (localId == 1 && info != null) {
            crafter.func_71112_a(container, variableId, info.getAmount() >>> 16 & 0xFFFF);
        } else if (localId == 2) {
            if (info == null) {
                crafter.func_71112_a(container, variableId, -1);
            } else {
                crafter.func_71112_a(container, variableId, this.getFluidID(info.getFluid()));
            }
        }
    }

    @Override
    public void onChangeRecieved(int slot, int value) {
        FluidStack info = this.tile.getFluidInTank(0);
        int tankCapacity = this.tile.getTankCapacity(0);
        if (slot == 2) {
            if ((info == null || info.getFluid().func_207187_a(Fluids.field_204541_a)) && value != -1) {
                if (this.tile2 != null) {
                    this.tile2.fillInternal(new FluidStack(this.getFluid(value), 1), IFluidHandler.FluidAction.EXECUTE);
                } else {
                    this.tile.fill(new FluidStack(this.getFluid(value), 1), IFluidHandler.FluidAction.EXECUTE);
                }
            } else if (value == -1) {
                if (this.tile2 != null) {
                    this.tile2.drainInternal(tankCapacity, IFluidHandler.FluidAction.EXECUTE);
                } else {
                    this.tile.drain(tankCapacity, IFluidHandler.FluidAction.EXECUTE);
                }
            } else if (info != null && value != this.getFluidID(info.getFluid())) {
                FluidStack stack = this.tile2 != null ? this.tile2.drainInternal(tankCapacity, IFluidHandler.FluidAction.EXECUTE) : this.tile.drain(tankCapacity, IFluidHandler.FluidAction.EXECUTE);
                stack = new FluidStack(stack.getFluid(), stack.getAmount());
                this.tile.fill(stack, IFluidHandler.FluidAction.EXECUTE);
            }
        } else if ((slot == 0 || slot == 1) && info != null) {
            int difference = slot == 0 ? (value & 0xFFFF) - (info.getAmount() & 0xFFFF) : (value << 16 & 0xFFFF0000) - (info.getAmount() & 0xFFFF0000);
            if (difference > 0) {
                if (this.tile2 != null) {
                    this.tile2.fillInternal(new FluidStack(info.getFluid(), difference), IFluidHandler.FluidAction.EXECUTE);
                } else {
                    this.tile.fill(new FluidStack(info.getFluid(), difference), IFluidHandler.FluidAction.EXECUTE);
                }
            } else if (this.tile2 != null) {
                this.tile2.drainInternal(-difference, IFluidHandler.FluidAction.EXECUTE);
            } else {
                this.tile.drain(-difference, IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    @Override
    public boolean needsUpdate(int localId) {
        FluidStack info = this.tile.getFluidInTank(0);
        if (localId == 0 || localId == 1) {
            return info != null && this.prevLiquidAmt != info.getAmount();
        }
        if (localId == 2) {
            if (info == null) {
                return this.prevLiquidUUID != -1;
            }
            return this.getFluidID(info.getFluid()) != this.prevLiquidUUID;
        }
        return false;
    }

    @Override
    protected void updatePreviousState(int localId) {
        FluidStack info = this.tile.getFluidInTank(0);
        if (localId == 0 && info != null) {
            this.prevLiquidAmt = info.getAmount();
        } else if (localId == 1) {
            this.prevLiquidUUID = info == null ? -1 : this.getFluidID(info.getFluid());
        }
    }

    protected float getProgress() {
        int capacity = 0;
        int fillAmount = 0;
        for (int i = 0; i < this.tile.getTanks(); ++i) {
            FluidStack fluidInfo = this.tile.getFluidInTank(i);
            capacity += this.tile.getTankCapacity(i);
            if (fluidInfo == null) continue;
            fillAmount += fluidInfo.getAmount();
        }
        return (float)fillAmount / (float)capacity;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderForeground(MatrixStack mat, int guiOffsetX, int guiOffsetY, int mouseX, int mouseY, float zLevel, ContainerScreen<? extends Container> gui, FontRenderer font) {
        int relativeX = mouseX - this.offsetX;
        int relativeY = mouseY - this.offsetY;
        int ySize = 52;
        int xSize = 12;
        if (relativeX > 0 && relativeX < xSize && relativeY > 0 && relativeY < ySize) {
            LinkedList<String> list = new LinkedList<String>();
            FluidStack fluidStack = this.tile.getFluidInTank(0);
            if (fluidStack != null) {
                list.add(fluidStack.getDisplayName().getString() + ": " + fluidStack.getAmount() + " / " + this.tile.getTankCapacity(0) + " mB");
            } else {
                list.add("Empty");
            }
            this.drawTooltip(gui, mat, list, mouseX, mouseY, zLevel, font);
        }
    }

    @Override
    public void renderBackground(ContainerScreen<? extends Container> gui, MatrixStack mat, int x, int y, int mouseX, int mouseY, FontRenderer font) {
        super.renderBackground(gui, mat, x, y, mouseX, mouseY, font);
        gui.func_238474_b_(mat, x + this.offsetX, y + this.offsetY, 176, 58, 14, 54);
        FluidStack info = this.tile.getFluidInTank(0);
        if (info == null) {
            return;
        }
        if (info.getFluid() == Fluids.field_204541_a) {
            return;
        }
        TextureAtlasSprite sprite = info.getFluid() != Fluids.field_204541_a ? (TextureAtlasSprite)ModelLoader.defaultTextureGetter().apply(ForgeHooksClient.getBlockMaterial((ResourceLocation)info.getFluid().getAttributes().getStillTexture())) : null;
        sprite.func_229241_m_().func_229148_d_();
        int color = info.getFluid().getAttributes().getColor(info);
        GL11.glColor3b((byte)((byte)(color >>> 16 & 0x7F)), (byte)((byte)(color >>> 8 & 0x7F)), (byte)((byte)(color & 0x7F)));
        float percent = this.getProgress();
        int ySize = 52;
        int xSize = 12;
        if (sprite == null) {
            gui.func_238474_b_(mat, this.offsetX + x + 1, this.offsetY + y + 1 + (ySize - (int)(percent * (float)ySize)), 0, 0, xSize, (int)(percent * (float)ySize));
        } else {
            gui.getMinecraft().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
            ContainerScreen.func_238470_a_((MatrixStack)mat, (int)(this.offsetX + x + 1), (int)(this.offsetY + y + 1 + (ySize - (int)(percent * (float)ySize))), (int)0, (int)xSize, (int)((int)(percent * (float)ySize)), (TextureAtlasSprite)sprite);
        }
    }
}

