/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.inventory.modules;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.LinkedList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.inventory.modules.ModuleBase;

public class ModulePower
extends ModuleBase {
    IUniversalEnergy tile;
    private static final int barXSize = 6;
    private static final int barYSize = 38;
    private static final int textureOffsetX = 0;
    private static final int textureOffsetY = 171;
    int prevPower = -1;

    public ModulePower(int offsetX, int offsetY, IUniversalEnergy tile) {
        super(offsetX, offsetY);
        this.tile = tile;
    }

    @Override
    public void renderBackground(ContainerScreen<? extends Container> gui, MatrixStack mat, int x, int y, int mouseX, int mouseY, FontRenderer font) {
        super.renderBackground(gui, mat, x, y, mouseX, mouseY, font);
        gui.func_238474_b_(mat, x + this.offsetX, y + this.offsetY, 176, 18, 8, 40);
        gui.func_238474_b_(mat, x + this.offsetX + 2, y + this.offsetY + 38 + 5, 15, 171, 4, 9);
        float percent = (float)this.tile.getUniversalEnergyStored() / (float)this.tile.getMaxEnergyStored();
        gui.func_238474_b_(mat, this.offsetX + x + 1, 1 + this.offsetY + y + (38 - (int)(percent * 38.0f)), 0, 38 - (int)(percent * 38.0f) + 171, 6, (int)(percent * 38.0f));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderForeground(MatrixStack mat, int guiOffsetX, int guiOffsetY, int mouseX, int mouseY, float zLevel, ContainerScreen<? extends Container> gui, FontRenderer font) {
        int relativeX = mouseX - this.offsetX;
        int relativeY = mouseY - this.offsetY;
        if (relativeX > 0 && relativeX < 6 && relativeY > 0 && relativeY < 38) {
            LinkedList<String> list = new LinkedList<String>();
            list.add(this.tile.getUniversalEnergyStored() + " / " + this.tile.getMaxEnergyStored() + " Power");
            this.drawTooltip(gui, mat, list, mouseX, mouseY, zLevel, font);
        }
    }

    @Override
    public int numberOfChangesToSend() {
        return 2;
    }

    @Override
    public boolean needsUpdate(int localId) {
        if (localId == 0) {
            return (this.prevPower & 0xFFFF) != (this.tile.getUniversalEnergyStored() & 0xFFFF);
        }
        if (localId == 1) {
            return (this.prevPower >>> 16 & 0xFFFF) != (this.tile.getUniversalEnergyStored() >>> 16 & 0xFFFF);
        }
        return false;
    }

    @Override
    protected void updatePreviousState(int localId) {
        if (localId == 0) {
            int data = this.tile.getUniversalEnergyStored() & 0xFFFF;
            this.prevPower = this.prevPower & 0xFFFF0000 | data;
        } else if (localId == 1) {
            int data = this.tile.getUniversalEnergyStored() & 0xFFFF0000;
            this.prevPower = this.prevPower & 0xFFFF | data;
        }
    }

    @Override
    public void sendChanges(Container container, IContainerListener crafter, int variableId, int localId) {
        if (localId == 0) {
            int data = this.tile.getUniversalEnergyStored() & 0xFFFF;
            crafter.func_71112_a(container, variableId, data);
        } else if (localId == 1) {
            int data = this.tile.getUniversalEnergyStored() & 0xFFFF0000;
            crafter.func_71112_a(container, variableId, data >>> 16);
        }
    }

    @Override
    public void onChangeRecieved(int slot, int value) {
        if (slot == 0) {
            int energy = this.tile.getUniversalEnergyStored();
            energy = energy & 0xFFFF0000 | value & 0xFFFF;
            this.tile.setEnergyStored(energy);
        } else if (slot == 1) {
            int energy = this.tile.getUniversalEnergyStored();
            energy = energy & 0xFFFF | value << 16;
            this.tile.setEnergyStored(energy);
        }
    }
}

