/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.inventory.modules;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import zmaster587.libVulpes.client.util.ProgressBarImage;
import zmaster587.libVulpes.inventory.modules.IProgressBar;
import zmaster587.libVulpes.inventory.modules.ModuleBase;

public class ModuleProgress
extends ModuleBase {
    ProgressBarImage progressBar;
    IProgressBar progress;
    int prevProgress;
    int prevTotalProgress;
    int id;
    List<String> tooltip;
    IntReferenceHolder currentValue;

    public ModuleProgress(int offsetX, int offsetY, int id, ProgressBarImage progressBar, IProgressBar progress) {
        super(offsetX, offsetY);
        this.progressBar = progressBar;
        this.progress = progress;
        this.id = id;
        this.currentValue = IntReferenceHolder.func_221492_a();
    }

    public ModuleProgress(int offsetX, int offsetY, int id, ProgressBarImage progressBar, IProgressBar progress, String tooltip) {
        this(offsetX, offsetY, id, progressBar, progress);
        this.setTooltip(tooltip);
    }

    @Override
    public List<IntReferenceHolder> getIntTrackers(Container container) {
        List<IntReferenceHolder> list = super.getIntTrackers(container);
        list.add(this.currentValue);
        return list;
    }

    public void setTooltip(String tooltip) {
        if (tooltip == null || tooltip.isEmpty()) {
            this.tooltip.clear();
        } else {
            this.tooltip = Arrays.asList(tooltip.split("\\n"));
        }
    }

    @Override
    public void renderForeground(MatrixStack mat, int guiOffsetX, int guiOffsetY, int mouseX, int mouseY, float zLevel, ContainerScreen<? extends Container> gui, FontRenderer font) {
        super.renderForeground(mat, guiOffsetX, guiOffsetY, mouseX, mouseY, zLevel, gui, font);
        List<String> tooltip = this.getToolTip();
        if (tooltip != null && !tooltip.isEmpty()) {
            int localX = mouseX - this.offsetX - this.progressBar.getInsetX();
            int localY = mouseY - this.offsetY - this.progressBar.getInsetY();
            if (localX > 0 && localX < this.progressBar.getBackWidth() - this.progressBar.getInsetX() && localY > 0 && localY < this.progressBar.getBackHeight() - this.progressBar.getInsetY()) {
                this.drawTooltip(gui, mat, tooltip, mouseX, MathHelper.func_76125_a((int)mouseY, (int)16, (int)Integer.MAX_VALUE), zLevel, font);
            }
        }
    }

    protected List<String> getToolTip() {
        return this.tooltip;
    }

    @Override
    public boolean needsUpdate(int localId) {
        switch (localId) {
            case 0: {
                return this.prevProgress != this.progress.getProgress(this.id);
            }
            case 1: {
                return this.prevTotalProgress != this.progress.getTotalProgress(this.id);
            }
        }
        return false;
    }

    @Override
    protected void updatePreviousState(int localId) {
        switch (localId) {
            case 0: {
                this.prevProgress = this.progress.getProgress(this.id);
                break;
            }
            case 1: {
                this.prevTotalProgress = this.progress.getTotalProgress(this.id);
            }
        }
    }

    @Override
    public void sendChanges(Container container, IContainerListener crafter, int variableId, int localId) {
        switch (localId) {
            case 0: {
                crafter.func_71112_a(container, variableId, this.progress.getProgress(this.id));
                break;
            }
            case 1: {
                crafter.func_71112_a(container, variableId, this.progress.getTotalProgress(this.id));
            }
        }
    }

    @Override
    public void onChangeRecieved(int slot, int value) {
        switch (slot) {
            case 0: {
                this.progress.setProgress(this.id, value);
                break;
            }
            case 1: {
                this.progress.setTotalProgress(this.id, value);
            }
        }
    }

    @Override
    public int numberOfChangesToSend() {
        return 2;
    }

    protected float getProgress() {
        return this.progress.getNormallizedProgress(this.id);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderBackground(ContainerScreen<? extends Container> gui, MatrixStack mat, int x, int y, int mouseX, int mouseY, FontRenderer font) {
        this.progressBar.renderProgressBar(mat, x + this.offsetX, y + this.offsetY, this.getProgress(), (AbstractGui)gui);
    }
}

