/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.inventory.modules;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import zmaster587.libVulpes.inventory.modules.IToggleButton;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleToggleSwitch;

public class ModuleRadioButton
extends ModuleBase {
    IToggleButton tile;
    List<ModuleToggleSwitch> buttons;
    int previousSelection;
    int enabledColor;
    int disabledColor;
    boolean enabled = true;

    public ModuleRadioButton(IToggleButton tile, List<ModuleToggleSwitch> buttons) {
        super(0, 0);
        this.buttons = buttons;
        this.tile = tile;
        this.enabledColor = -14483678;
        this.disabledColor = -56798;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public int getOptionSelected() {
        for (int i = 0; i < this.buttons.size(); ++i) {
            if (!this.buttons.get(i).getState()) continue;
            return i;
        }
        return -1;
    }

    public void setOptionSelected(int option) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            if (i == option) {
                this.buttons.get(i).setToggleState(true);
                this.buttons.get(i).setColor(this.enabledColor);
                continue;
            }
            this.buttons.get(i).setToggleState(false);
            this.buttons.get(i).setColor(this.disabledColor);
        }
    }

    @Override
    public int numberOfChangesToSend() {
        return 1;
    }

    @Override
    public boolean needsUpdate(int localId) {
        return this.previousSelection != this.getOptionSelected();
    }

    @Override
    protected void updatePreviousState(int localId) {
        this.previousSelection = this.getOptionSelected();
    }

    @Override
    public void sendChanges(Container container, IContainerListener crafter, int variableId, int localId) {
        crafter.func_71112_a(container, variableId, this.getOptionSelected());
    }

    @Override
    public void onChangeRecieved(int slot, int value) {
        this.setOptionSelected(value);
    }

    @Override
    public List<Button> addButtons(int x, int y) {
        List<Button> buttonList = super.addButtons(x, y);
        for (ModuleToggleSwitch button : this.buttons) {
            buttonList.addAll(button.addButtons(x, y));
        }
        return buttonList;
    }

    @Override
    public void actionPerform(Button buttonObj) {
        if (this.enabled) {
            super.actionPerform(buttonObj);
            boolean isNotOurRadio = true;
            for (ModuleToggleSwitch button : this.buttons) {
                if (!button.isButton(buttonObj)) continue;
                isNotOurRadio = false;
                break;
            }
            if (isNotOurRadio) {
                return;
            }
            for (ModuleToggleSwitch button : this.buttons) {
                button.setToggleState(button.isButton(buttonObj));
                if (!button.isButton(buttonObj)) continue;
                this.tile.onInventoryButtonPressed(button);
            }
        }
    }

    @Override
    public void renderForeground(MatrixStack mat, int guiOffsetX, int guiOffsetY, int mouseX, int mouseY, float zLevel, ContainerScreen<? extends Container> gui, FontRenderer font) {
        super.renderForeground(mat, guiOffsetX, guiOffsetY, mouseX, mouseY, zLevel, gui, font);
        for (ModuleToggleSwitch button : this.buttons) {
            button.renderForeground(mat, guiOffsetX, guiOffsetY, mouseX, mouseY, zLevel, gui, font);
        }
    }

    @Override
    public void renderBackground(ContainerScreen<? extends Container> gui, MatrixStack mat, int x, int y, int mouseX, int mouseY, FontRenderer font) {
        super.renderBackground(gui, mat, x, y, mouseX, mouseY, font);
        for (ModuleToggleSwitch button : this.buttons) {
            button.renderBackground(gui, mat, x, y, mouseX, mouseY, font);
        }
    }
}

