/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.inventory.modules;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.inventory.container.Container;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import zmaster587.libVulpes.inventory.TextureResources;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.util.ZUtils;

public class ModuleRedstoneOutputButton
extends ModuleButton {
    ZUtils.RedstoneState state;
    String suppText;

    public ModuleRedstoneOutputButton(int offsetX, int offsetY, String text, IButtonInventory tile) {
        super(offsetX, offsetY, text, tile, TextureResources.buttonRedstoneActive, 24, 24);
        this.sizeX = 24;
        this.sizeY = 24;
        this.state = ZUtils.RedstoneState.ON;
        this.suppText = "";
    }

    public ModuleRedstoneOutputButton(int offsetX, int offsetY, String text, IButtonInventory tile, String text2) {
        this(offsetX, offsetY, text, tile);
        this.suppText = text2;
    }

    public ZUtils.RedstoneState getState() {
        return this.state;
    }

    public void setRedstoneState(int i) {
        this.state = ZUtils.RedstoneState.values()[i];
    }

    public void setRedstoneState(ZUtils.RedstoneState i) {
        this.state = i;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderBackground(ContainerScreen<? extends Container> gui, MatrixStack mat, int x, int y, int mouseX, int mouseY, FontRenderer font) {
        if (this.state != null) {
            switch (this.state) {
                case ON: {
                    this.button.setButtonTexture(TextureResources.buttonRedstoneActive);
                    this.tooltipText = this.suppText + "Redstone control normal";
                    break;
                }
                case OFF: {
                    this.button.setButtonTexture(TextureResources.buttonRedstoneDisabled);
                    this.tooltipText = this.suppText + "Redstone control disabled";
                    break;
                }
                case INVERTED: {
                    this.button.setButtonTexture(TextureResources.buttonRedstoneInverted);
                    this.tooltipText = this.suppText + "Redstone control inverted";
                }
            }
        }
        super.renderBackground(gui, mat, x, y, mouseX, mouseY, font);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void actionPerform(Button button) {
        if (this.enabled && button == this.button) {
            if (this.state == null) {
                this.state = ZUtils.RedstoneState.ON;
            }
            this.state = this.state.getNext();
            this.tile.onInventoryButtonPressed(this);
        }
    }
}

