/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.inventory.modules;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import zmaster587.libVulpes.inventory.GuiModular;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IGuiCallback;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;

public class ModuleTab
extends ModuleBase
implements IButtonInventory {
    private ModuleButton tab;
    IGuiCallback gameObject;
    private ModuleButton[] buttons;

    public ModuleTab(int offsetX, int offsetY, int startingId, IGuiCallback object, int numTabs, String[] tabText, ResourceLocation[][] textures) {
        super(offsetX, offsetY);
        this.gameObject = object;
        this.buttons = new ModuleButton[numTabs];
        for (int i = 0; i < numTabs; ++i) {
            this.buttons[i] = new ModuleButton(offsetX + i * 24, offsetY - 20, "", this, textures[i], tabText[i], 24, 24);
            this.buttons[i].setAdditionalData(i);
        }
        this.sizeX = 24;
        this.sizeY = 24;
    }

    public void setTab(int tabNum) {
        this.tab = this.buttons[tabNum];
    }

    public int getTab() {
        return this.tab == null ? 0 : (Integer)this.tab.getAdditionalData();
    }

    @Override
    public void onMouseClicked(GuiModular gui, double x, double y, int button) {
        super.onMouseClicked(gui, x, y, button);
        for (ModuleButton button2 : this.buttons) {
            button2.onMouseClicked(gui, x, y, button);
        }
    }

    @Override
    public List<Button> addButtons(int x, int y) {
        List<Button> list = super.addButtons(x, y);
        for (ModuleButton button2 : this.buttons) {
            list.addAll(button2.addButtons(x, y));
        }
        return list;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void actionPerform(Button button) {
        super.actionPerform(button);
        for (ModuleButton button2 : this.buttons) {
            button2.actionPerform(button);
        }
    }

    @Override
    public void renderForeground(MatrixStack buf, int guiOffsetX, int guiOffsetY, int mouseX, int mouseY, float zLevel, ContainerScreen<? extends Container> gui, FontRenderer font) {
        super.renderForeground(buf, guiOffsetX, guiOffsetY, mouseX, mouseY, zLevel, gui, font);
        for (ModuleButton button2 : this.buttons) {
            button2.renderForeground(buf, guiOffsetX, guiOffsetY, mouseX, mouseY, zLevel, gui, font);
        }
    }

    @Override
    public void renderBackground(ContainerScreen<? extends Container> gui, MatrixStack buf, int x, int y, int mouseX, int mouseY, FontRenderer font) {
        super.renderBackground(gui, buf, x, y, mouseX, mouseY, font);
        for (ModuleButton button2 : this.buttons) {
            button2.renderBackground(gui, buf, x, y, mouseX, mouseY, font);
        }
    }

    @Override
    public void onInventoryButtonPressed(ModuleButton buttonId) {
        this.tab = buttonId;
        this.gameObject.onModuleUpdated(this);
    }
}

