/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.items;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.NetworkHooks;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.LibVulpesBlocks;
import zmaster587.libVulpes.api.LibvulpesGuiRegistry;
import zmaster587.libVulpes.block.BlockMeta;
import zmaster587.libVulpes.block.BlockTile;
import zmaster587.libVulpes.block.multiblock.BlockMultiblockMachine;
import zmaster587.libVulpes.inventory.ContainerModular;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.TextureResources;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleContainerPan;
import zmaster587.libVulpes.network.INetworkItem;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketItemModifcation;
import zmaster587.libVulpes.tile.TileSchematic;
import zmaster587.libVulpes.tile.multiblock.TileMultiBlock;
import zmaster587.libVulpes.tile.multiblock.TilePlaceholder;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.Vector3F;
import zmaster587.libVulpes.util.ZUtils;

public class ItemProjector
extends Item
implements IModularInventory,
IButtonInventory,
INetworkItem,
INamedContainerProvider {
    ArrayList<TileMultiBlock> machineList = new ArrayList();
    ArrayList<BlockTile> blockList = new ArrayList();
    HashMap<Integer, String> descriptionList = new HashMap();
    private static final String IDNAME = "machineId";

    public ItemProjector(Item.Properties properties) {
        super(properties);
    }

    private String buildMachineBlocks(TileMultiBlock multiblock, BlockTile mainBlock) {
        HashMap<Object, Integer> map = new HashMap<Object, Integer>();
        Object[][][] structure = multiblock.getStructure();
        for (int i = 0; i < structure.length; ++i) {
            for (int j = 0; j < structure[i].length; ++j) {
                for (int k = 0; k < structure[i][j].length; ++k) {
                    Object o = structure[i][j][k];
                    if (!map.containsKey(o)) {
                        map.put(o, 1);
                        continue;
                    }
                    map.put(o, (Integer)map.get(o) + 1);
                }
            }
        }
        String str = Item.func_150898_a((Block)mainBlock).func_200295_i(new ItemStack((IItemProvider)mainBlock)).getString() + " x1\n";
        for (Map.Entry entry : map.entrySet()) {
            List<BlockMeta> blockMeta = multiblock.getAllowableBlocks(entry.getKey());
            if (blockMeta.isEmpty() || Item.func_150898_a((Block)blockMeta.get(0).getBlock()) == null || blockMeta.get(0).getBlock() == Blocks.field_150350_a) continue;
            for (int i = 0; i < blockMeta.size(); ++i) {
                String itemStr = Item.func_150898_a((Block)blockMeta.get(i).getBlock()).func_200295_i(new ItemStack((IItemProvider)blockMeta.get(i).getBlock(), 1)).getString();
                if (itemStr.contains("block.")) continue;
                str = str + itemStr;
                str = str + " or ";
            }
            if (str.endsWith(" or ")) {
                str = str.substring(0, str.length() - 4);
            }
            str = str + " x" + entry.getValue() + "\n";
        }
        return str;
    }

    public void registerMachine(TileMultiBlock multiblock, BlockTile mainBlock) {
        this.machineList.add(multiblock);
        this.blockList.add(mainBlock);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void mouseEvent(InputEvent.MouseScrollEvent event) {
        ItemStack stack;
        if (Minecraft.func_71410_x().field_71439_g.func_225608_bj_() && event.getScrollDelta() != 0.0 && (stack = Minecraft.func_71410_x().field_71439_g.func_184586_b(Hand.MAIN_HAND)) != null && stack.func_77973_b() == this && this.getMachineId(stack) != -1) {
            if (event.getScrollDelta() < 0.0) {
                this.setYLevel(stack, this.getYLevel(stack) + 1);
            } else {
                this.setYLevel(stack, this.getYLevel(stack) - 1);
            }
            event.setCanceled(true);
            PacketHandler.sendToServer(new PacketItemModifcation(this, (PlayerEntity)Minecraft.func_71410_x().field_71439_g, 1));
        }
    }

    private void clearStructure(World world, TileMultiBlock tile, ItemStack stack) {
        int id = this.getMachineId(stack);
        Direction direction = Direction.values()[this.getDirection(stack)];
        TileMultiBlock multiblock = this.machineList.get(id);
        int prevMachineId = this.getPrevMachineId(stack);
        if (prevMachineId >= 0 && prevMachineId < this.machineList.size()) {
            Object[][][] structure = this.machineList.get(prevMachineId).getStructure();
            Vector3F<Integer> basepos = this.getBasePosition(stack);
            for (int y = 0; y < structure.length; ++y) {
                for (int z = 0; z < structure[0].length; ++z) {
                    for (int x = 0; x < structure[0][0].length; ++x) {
                        int globalX = (Integer)basepos.x - x * direction.func_82599_e() + z * direction.func_82601_c();
                        int globalZ = (Integer)basepos.z + x * direction.func_82601_c() + z * direction.func_82599_e();
                        BlockPos pos = new BlockPos(globalX, (Integer)basepos.y + y, globalZ);
                        if (world.func_180495_p(pos).func_177230_c() != LibVulpesBlocks.blockPhantom) continue;
                        world.func_217377_a(pos, false);
                    }
                }
            }
        }
    }

    private void RebuildStructure(World world, TileMultiBlock tile, ItemStack stack, int posX, int posY, int posZ, Direction orientation, boolean hologram) {
        int endNumber;
        int startNumber;
        int id = this.getMachineId(stack);
        Direction direction = Direction.func_82600_a((int)this.getDirection(stack));
        TileMultiBlock multiblock = this.machineList.get(id);
        this.clearStructure(world, tile, stack);
        Object[][][] structure = multiblock.getStructure();
        direction = orientation;
        int y = this.getYLevel(stack);
        if (y == -1) {
            startNumber = 0;
            endNumber = structure.length;
        } else {
            startNumber = y;
            endNumber = y + 1;
        }
        for (y = startNumber; y < endNumber; ++y) {
            for (int z = 0; z < structure[0].length; ++z) {
                for (int x = 0; x < structure[0][0].length; ++x) {
                    List<Object> block;
                    if (structure[y][z][x] instanceof Character && ((Character)structure[y][z][x]).charValue() == 'c') {
                        block = new ArrayList<BlockMeta>();
                        block.add(new BlockMeta(this.blockList.get(id).func_176223_P(), true));
                    } else {
                        if (multiblock.getAllowableBlocks(structure[y][z][x]).isEmpty()) continue;
                        block = multiblock.getAllowableBlocks(structure[y][z][x]);
                    }
                    int globalX = posX - x * direction.func_82599_e() + z * direction.func_82601_c();
                    int globalZ = posZ + x * direction.func_82601_c() + z * direction.func_82599_e();
                    int globalY = -y + structure.length + posY - 1;
                    BlockPos pos = new BlockPos(globalX, globalY, globalZ);
                    if (!world.func_175623_d(pos) && !world.func_180495_p(pos).func_227032_a_((Fluid)Fluids.field_204546_a) || ((BlockMeta)block.get(0)).getBlock() == Blocks.field_150350_a) continue;
                    if (hologram) {
                        world.func_175656_a(pos, LibVulpesBlocks.blockPhantom.func_176223_P());
                        TileEntity newTile = world.func_175625_s(pos);
                        if (!(newTile instanceof TilePlaceholder)) continue;
                        ((TileSchematic)newTile).setReplacedBlock(block);
                        ((TilePlaceholder)newTile).setReplacedTileEntity(((BlockMeta)block.get(0)).getBlock().createTileEntity(((BlockMeta)block.get(0)).getBlock().func_176223_P(), (IBlockReader)world));
                        continue;
                    }
                    world.func_175656_a(pos, ((BlockMeta)block.get(0)).getBlockState());
                }
            }
        }
        this.setPrevMachineId(stack, id);
        this.setBasePosition(stack, posX, posY, posZ);
        this.setDirection(stack, orientation.ordinal());
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (!world.field_72995_K && player.func_225608_bj_()) {
            INamedContainerProvider stack = (INamedContainerProvider)player.func_184586_b(hand).func_77973_b();
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)stack, packetBuffer -> {
                packetBuffer.writeInt(this.getModularInvType().ordinal());
                packetBuffer.writeBoolean(hand == Hand.MAIN_HAND);
            });
            return super.func_77659_a(world, player, hand);
        }
        return super.func_77659_a(world, player, hand);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        World world = context.func_195991_k();
        int id = this.getMachineId(stack);
        if (player.field_71075_bZ.field_75098_d && !player.func_225608_bj_() && id != -1 && !world.field_72995_K && this.blockList.get(id) == context.func_195991_k().func_180495_p(context.func_195995_a()).func_177230_c()) {
            Vector3F<Integer> pos = this.getBasePosition(stack);
            Direction direction = Direction.values()[this.getDirection(stack)];
            this.setYLevel(stack, -1);
            this.RebuildStructure(context.func_195991_k(), this.machineList.get(id), stack, (Integer)pos.x, (Integer)pos.y, (Integer)pos.z, direction, false);
        }
        if (!player.func_225608_bj_() && id != -1 && world.field_72995_K) {
            Direction dir = Direction.func_82600_a((int)ZUtils.getDirectionFacing(player.field_70177_z - 180.0f));
            TileMultiBlock tile = this.machineList.get(this.getMachineId(stack));
            int x = tile.getStructure()[0][0].length;
            int z = tile.getStructure()[0].length;
            int globalX = (-x * dir.func_82599_e() + z * dir.func_82601_c()) / 2;
            int globalZ = (x * dir.func_82601_c() + z * dir.func_82599_e()) / 2;
            BlockPos pos = context.func_195995_a();
            TileEntity tile2 = world.func_175625_s(pos);
            if (tile2 instanceof TileMultiBlock) {
                for (TileMultiBlock tiles : this.machineList) {
                    if (tile2.getClass() != ((Object)((Object)tiles)).getClass()) continue;
                    this.setMachineId(stack, this.machineList.indexOf((Object)tiles));
                    Object[][][] structure = tiles.getStructure();
                    HashedBlockPosition controller = this.getControllerOffset(structure);
                    dir = BlockMultiblockMachine.getFront(world.func_180495_p(tile2.func_174877_v())).func_176734_d();
                    controller.y = (short)(structure.length - controller.y);
                    globalX = -controller.x * dir.func_82599_e() + controller.z * dir.func_82601_c();
                    globalZ = controller.x * dir.func_82601_c() + controller.z * dir.func_82599_e();
                    this.setDirection(stack, dir.ordinal());
                    this.setBasePosition(stack, pos.func_177958_n() - globalX, pos.func_177956_o() - controller.y + 1, pos.func_177952_p() - globalZ);
                    PacketHandler.sendToServer(new PacketItemModifcation(this, player, 0));
                    PacketHandler.sendToServer(new PacketItemModifcation(this, player, 2));
                    return super.onItemUseFirst(stack, context);
                }
            }
            if (context.func_196000_l() == Direction.DOWN) {
                this.setBasePosition(stack, pos.func_177958_n() - globalX, pos.func_177956_o() - tile.getStructure().length, pos.func_177952_p() - globalZ);
            } else {
                this.setBasePosition(stack, pos.func_177958_n() - globalX, pos.func_177956_o() + 1, pos.func_177952_p() - globalZ);
            }
            this.setDirection(stack, dir.ordinal());
            PacketHandler.sendToServer(new PacketItemModifcation(this, player, 2));
        }
        return super.onItemUseFirst(stack, context);
    }

    protected HashedBlockPosition getControllerOffset(Object[][][] structure) {
        for (int y = 0; y < structure.length; ++y) {
            for (int z = 0; z < structure[0].length; ++z) {
                for (int x = 0; x < structure[0][0].length; ++x) {
                    if (!(structure[y][z][x] instanceof Character) || ((Character)structure[y][z][x]).charValue() != 'c') continue;
                    return new HashedBlockPosition(x, y, z);
                }
            }
        }
        return null;
    }

    @Override
    public List<ModuleBase> getModules(int ID, PlayerEntity player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        LinkedList<ModuleBase> btns = new LinkedList<ModuleBase>();
        for (int i = 0; i < this.machineList.size(); ++i) {
            TileMultiBlock multiblock = this.machineList.get(i);
            btns.add(new ModuleButton(60, 4 + i * 24, LibVulpes.proxy.getLocalizedString(multiblock.getMachineName()), this, TextureResources.buttonBuild));
            ((ModuleButton)btns.get(i)).setAdditionalData(i);
        }
        ModuleContainerPan panningContainer = new ModuleContainerPan(5, 20, btns, new LinkedList<ModuleBase>(), TextureResources.starryBG, 160, 100, 0, 500);
        modules.add(panningContainer);
        return modules;
    }

    @Override
    public String getModularInventoryName() {
        return "item.holoProjector";
    }

    @Override
    public boolean canInteractWithContainer(PlayerEntity entity) {
        return entity != null && entity.func_70089_S() && entity.func_184586_b(Hand.MAIN_HAND) != null && entity.func_184586_b(Hand.MAIN_HAND).func_77973_b() == this;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onInventoryButtonPressed(ModuleButton buttonId) {
        ItemStack stack = Minecraft.func_71410_x().field_71439_g.func_184586_b(Hand.MAIN_HAND);
        if (stack != null && stack.func_77973_b() == this) {
            this.setMachineId(stack, (Integer)buttonId.getAdditionalData());
            PacketHandler.sendToServer(new PacketItemModifcation(this, (PlayerEntity)Minecraft.func_71410_x().field_71439_g, 0));
        }
    }

    private void setMachineId(ItemStack stack, int id) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        nbt.func_74768_a(IDNAME, id);
        stack.func_77982_d(nbt);
    }

    private int getMachineId(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e(IDNAME);
        }
        return -1;
    }

    private void setYLevel(ItemStack stack, int level) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        TileMultiBlock machine = this.machineList.get(this.getMachineId(stack));
        if (level == -2) {
            level = machine.getStructure().length - 1;
        } else if (level == machine.getStructure().length) {
            level = -1;
        }
        nbt.func_74768_a("yOffset", level);
        stack.func_77982_d(nbt);
    }

    private int getYLevel(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e("yOffset");
        }
        return -1;
    }

    private void setPrevMachineId(ItemStack stack, int id) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        nbt.func_74768_a("machineIdPrev", id);
        stack.func_77982_d(nbt);
    }

    private int getPrevMachineId(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e("machineIdPrev");
        }
        return -1;
    }

    private Vector3F<Integer> getBasePosition(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT nbt = stack.func_77978_p();
            Vector3F<Integer> vec = new Vector3F<Integer>(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
            return vec;
        }
        return null;
    }

    private void setBasePosition(ItemStack stack, int x, int y, int z) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        nbt.func_74768_a("x", x);
        nbt.func_74768_a("y", y);
        nbt.func_74768_a("z", z);
        stack.func_77982_d(nbt);
    }

    public int getDirection(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e("dir");
        }
        return -1;
    }

    public void setDirection(ItemStack stack, int dir) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        nbt.func_74768_a("dir", dir);
        stack.func_77982_d(nbt);
    }

    private String getDescription(int id) {
        if (this.descriptionList.containsKey(id)) {
            this.descriptionList.get(id);
        }
        String builtList = this.buildMachineBlocks(this.machineList.get(id), this.blockList.get(id));
        this.descriptionList.put(id, builtList);
        return builtList;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World player, List list, ITooltipFlag bool) {
        super.func_77624_a(stack, player, list, bool);
        list.add(new StringTextComponent("Shift right-click: opens machine selection interface"));
        list.add(new StringTextComponent("Shift-scroll: moves cross-section"));
        int id = this.getMachineId(stack);
        if (id != -1) {
            String[] strList;
            list.add(new StringTextComponent(""));
            list.add(new StringTextComponent(TextFormatting.GREEN + LibVulpes.proxy.getLocalizedString(this.machineList.get(id).getMachineName())));
            String str = this.getDescription(id);
            for (String s : strList = str.split("\n")) {
                list.add(new StringTextComponent(s));
            }
        }
    }

    @Override
    public void writeDataToNetwork(ByteBuf out, byte id, ItemStack stack) {
        if (id == 0) {
            out.writeInt(this.getMachineId(stack));
        } else if (id == 1) {
            out.writeInt(this.getYLevel(stack));
        } else if (id == 2) {
            Vector3F<Integer> pos = this.getBasePosition(stack);
            out.writeInt(((Integer)pos.x).intValue());
            out.writeInt(((Integer)pos.y).intValue());
            out.writeInt(((Integer)pos.z).intValue());
            out.writeInt(this.getDirection(stack));
        }
    }

    @Override
    public void readDataFromNetwork(ByteBuf in, byte packetId, CompoundNBT nbt, ItemStack stack) {
        if (packetId == 0) {
            nbt.func_74768_a(IDNAME, in.readInt());
        } else if (packetId == 1) {
            nbt.func_74768_a("yLevel", in.readInt());
        } else if (packetId == 2) {
            nbt.func_74768_a("x", in.readInt());
            nbt.func_74768_a("y", in.readInt());
            nbt.func_74768_a("z", in.readInt());
            nbt.func_74768_a("dir", in.readInt());
        }
    }

    @Override
    public void useNetworkData(PlayerEntity player, Dist side, byte id, CompoundNBT nbt, ItemStack stack) {
        if (id == 0) {
            int machineId = nbt.func_74762_e(IDNAME);
            this.setMachineId(stack, nbt.func_74762_e(IDNAME));
            TileMultiBlock tile = this.machineList.get(machineId);
            this.setYLevel(stack, tile.getStructure().length - 1);
        } else if (id == 1) {
            this.setYLevel(stack, nbt.func_74762_e("yLevel"));
            Vector3F<Integer> vec = this.getBasePosition(stack);
            this.RebuildStructure(player.field_70170_p, this.machineList.get(this.getMachineId(stack)), stack, (Integer)vec.x, (Integer)vec.y, (Integer)vec.z, Direction.func_82600_a((int)this.getDirection(stack)), true);
        } else if (id == 2) {
            int x = nbt.func_74762_e("x");
            int y = nbt.func_74762_e("y");
            int z = nbt.func_74762_e("z");
            int dir = nbt.func_74762_e("dir");
            if (this.getMachineId(stack) != -1) {
                this.RebuildStructure(player.field_70170_p, this.machineList.get(this.getMachineId(stack)), stack, x, y, z, Direction.func_82600_a((int)dir), true);
            }
        }
    }

    public Container createMenu(int id, PlayerInventory playerInv, PlayerEntity player) {
        GuiHandler.guiId ID = this.getModularInvType();
        return new ContainerModular(LibvulpesGuiRegistry.CONTAINER_MODULAR_HELD_ITEM, id, player, this.getModules(this.getModularInvType().ordinal(), player), this, ID);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("item.libvulpes.holo_projector");
    }

    @Override
    public GuiHandler.guiId getModularInvType() {
        return GuiHandler.guiId.MODULARNOINV;
    }
}

