/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import zmaster587.libVulpes.interfaces.INetworkEntity;
import zmaster587.libVulpes.network.BasePacket;

public class PacketEntity
extends BasePacket {
    INetworkEntity entity;
    CompoundNBT nbt = new CompoundNBT();
    int entityId;
    byte packetId;

    public PacketEntity() {
    }

    public PacketEntity(INetworkEntity machine, byte packetId) {
        this();
        this.entity = machine;
        this.packetId = packetId;
    }

    public PacketEntity(INetworkEntity entity, byte packetId, CompoundNBT nbt) {
        this(entity, packetId);
        this.nbt = nbt;
    }

    @Override
    public void write(PacketBuffer out) {
        BasePacket.writeWorld(out, ((Entity)this.entity).field_70170_p);
        out.writeInt(((Entity)this.entity).func_145782_y());
        out.writeByte((int)this.packetId);
        out.writeBoolean(!this.nbt.isEmpty());
        if (!this.nbt.isEmpty()) {
            out.func_150786_a(this.nbt);
        }
        this.entity.writeDataToNetwork(out, this.packetId);
    }

    @Override
    public void read(PacketBuffer in) {
        World world = BasePacket.readWorld(in);
        int entityId = in.readInt();
        this.packetId = in.readByte();
        Entity ent = world.func_73045_a(entityId);
        if (in.readBoolean()) {
            CompoundNBT nbt = null;
            this.nbt = nbt = in.func_150793_b();
        }
        if (ent != null && ent instanceof INetworkEntity) {
            this.entity = (INetworkEntity)ent;
            this.entity.readDataFromNetwork(in, this.packetId, this.nbt);
        }
    }

    public void execute(PlayerEntity player, Dist side) {
        if (this.entity != null) {
            this.entity.useNetworkData(player, side, this.packetId, this.nbt);
        }
    }

    @Override
    public void executeServer(ServerPlayerEntity player) {
        this.execute((PlayerEntity)player, Dist.DEDICATED_SERVER);
    }

    @Override
    public void executeClient(PlayerEntity player) {
        this.execute(player, Dist.CLIENT);
        if (this.entity == null) {
            // empty if block
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readClient(PacketBuffer in) {
        PacketBuffer buffer = new PacketBuffer((ByteBuf)in);
        PacketEntity.readWorld(in);
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        int entityId = buffer.readInt();
        this.packetId = buffer.readByte();
        Entity ent = world.func_73045_a(entityId);
        if (buffer.readBoolean()) {
            CompoundNBT nbt = null;
            this.nbt = nbt = buffer.func_150793_b();
        }
        if (ent != null && ent instanceof INetworkEntity) {
            this.entity = (INetworkEntity)ent;
            this.entity.readDataFromNetwork(buffer, this.packetId, this.nbt);
        } else {
            this.entityId = entityId;
            System.out.println("oh no...");
        }
    }
}

