/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.network;

import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketChangeKeyState;
import zmaster587.libVulpes.network.PacketEntity;
import zmaster587.libVulpes.network.PacketItemModifcation;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.network.PacketSpawnEntity;
import zmaster587.libVulpes.util.ZUtils;

public class PacketHandler {
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    private static final SimpleChannel HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("libvulpes", "main_channel")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    public static PacketHandler INSTANCE = new PacketHandler();
    static HashMap<Integer, Class<? extends BasePacket>> packetList = new HashMap();
    static HashMap<Class<? extends BasePacket>, Integer> revPacketList = new HashMap();

    public final void addDiscriminator(Class<? extends BasePacket> clazz) {
        packetList.put(clazz.getName().hashCode(), clazz);
        revPacketList.put(clazz, clazz.getName().hashCode());
    }

    public static final void register() {
        HANDLER.registerMessage(0, EncapsulatingPacket.class, EncapsulatingPacket::encode, EncapsulatingPacket::decode, EncapsulatingPacket.Handler::handle);
        INSTANCE.addDiscriminator(PacketChangeKeyState.class);
        INSTANCE.addDiscriminator(PacketEntity.class);
        INSTANCE.addDiscriminator(PacketItemModifcation.class);
        INSTANCE.addDiscriminator(PacketMachine.class);
        INSTANCE.addDiscriminator(PacketSpawnEntity.class);
    }

    public static Class<? extends BasePacket> getClassById(int id) {
        return packetList.get(id);
    }

    public static int getIdByClass(Class<? extends BasePacket> id) {
        return revPacketList.get(id);
    }

    public static final void sendToServer(BasePacket pkt) {
        EncapsulatingPacket msg = new EncapsulatingPacket(pkt);
        HANDLER.sendToServer((Object)msg);
    }

    public static final void sendToPlayersTrackingEntity(BasePacket pkt, Entity entity) {
        EncapsulatingPacket msg = new EncapsulatingPacket(pkt);
        Stream players = ((ServerWorld)entity.field_70170_p).func_72863_F().field_217237_a.func_219097_a(new ChunkPos(new BlockPos(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_())), false);
        players.forEach(player -> HANDLER.sendTo(msg, player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT));
    }

    public static final void sendToAll(BasePacket pkt) {
        EncapsulatingPacket msg = new EncapsulatingPacket(pkt);
        List players = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v();
        players.forEach(player -> HANDLER.sendTo(msg, player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT));
    }

    public static final void sendToPlayer(BasePacket pkt, PlayerEntity player) {
        EncapsulatingPacket msg = new EncapsulatingPacket(pkt);
        HANDLER.sendTo((Object)msg, ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static final void sendToDispatcher(BasePacket pkt, NetworkManager netman) {
        EncapsulatingPacket msg = new EncapsulatingPacket(pkt);
        HANDLER.sendTo((Object)msg, netman, NetworkDirection.PLAY_TO_CLIENT);
    }

    @Deprecated
    public static final void sendToNearby(BasePacket pkt, int dimId, int x, int y, int z, double dist) {
        List players = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v();
        EncapsulatingPacket msg = new EncapsulatingPacket(pkt);
        for (ServerPlayerEntity player : players) {
            if (ZUtils.getDimensionId(player.func_130014_f_()) != dimId || !(player.func_70092_e((double)x, (double)y, (double)z) <= dist * dist)) continue;
            HANDLER.sendTo((Object)msg, player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static final void sendToNearby(BasePacket pkt, ResourceLocation dimId, BlockPos pos, double dist) {
        PacketHandler.sendToNearby(pkt, dimId, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dist);
    }

    public static final void sendToNearby(BasePacket pkt, ResourceLocation dimId, int x, int y, int z, double dist) {
        List players = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v();
        EncapsulatingPacket msg = new EncapsulatingPacket(pkt);
        for (ServerPlayerEntity player : players) {
            if (ZUtils.getDimensionIdentifier(player.func_130014_f_()) != dimId || !(player.func_70092_e((double)x, (double)y, (double)z) <= dist * dist)) continue;
            HANDLER.sendTo((Object)msg, player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static final void sendToNearby(BasePacket pkt, World world, int x, int y, int z, double dist) {
        ResourceLocation dimId = ZUtils.getDimensionIdentifier(world);
        List players = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v();
        EncapsulatingPacket msg = new EncapsulatingPacket(pkt);
        for (ServerPlayerEntity player : players) {
            if (ZUtils.getDimensionIdentifier(player.func_130014_f_()) != dimId || !(player.func_70092_e((double)x, (double)y, (double)z) <= dist * dist)) continue;
            HANDLER.sendTo((Object)msg, player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    @Deprecated
    public static final void sendToNearby(BasePacket pkt, int dimId, BlockPos pos, double dist) {
        PacketHandler.sendToNearby(pkt, dimId, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dist);
    }

    public static final void sendToNearby(BasePacket pkt, World dimId, BlockPos pos, double dist) {
        PacketHandler.sendToNearby(pkt, dimId, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dist);
    }

    public static class EncapsulatingPacket {
        BasePacket basePacket;

        EncapsulatingPacket(BasePacket pkt) {
            this.basePacket = pkt;
        }

        public static void encode(EncapsulatingPacket pkt, PacketBuffer buf) {
            buf.writeInt(PacketHandler.getIdByClass(pkt.basePacket.getClass()));
            pkt.basePacket.write(buf);
        }

        public static EncapsulatingPacket decode(PacketBuffer buf) {
            BasePacket pkt;
            int index = buf.readInt();
            Class<? extends BasePacket> clazz = PacketHandler.getClassById(index);
            try {
                pkt = clazz.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                return null;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return null;
            }
            if (EffectiveSide.get() == LogicalSide.CLIENT) {
                pkt.readClient(buf);
            } else {
                pkt.read(buf);
            }
            return new EncapsulatingPacket(pkt);
        }

        public static class Handler {
            @OnlyIn(value=Dist.CLIENT)
            private static void CallClient(EncapsulatingPacket msg, Supplier<NetworkEvent.Context> ctx) {
                ctx.get().enqueueWork(() -> msg.basePacket.executeClient((PlayerEntity)Minecraft.func_71410_x().field_71439_g));
            }

            public static void handle(EncapsulatingPacket msg, Supplier<NetworkEvent.Context> ctx) {
                if (EffectiveSide.get() == LogicalSide.CLIENT) {
                    Handler.CallClient(msg, ctx);
                } else {
                    ctx.get().enqueueWork(() -> msg.basePacket.executeServer(((NetworkEvent.Context)ctx.get()).getSender()));
                }
                ctx.get().setPacketHandled(true);
            }
        }
    }
}

