/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.INetworkItem;

public class PacketItemModifcation
extends BasePacket {
    CompoundNBT nbt = new CompoundNBT();
    byte packetId;
    int entityId;
    PlayerEntity entity;
    INetworkItem machine;

    public PacketItemModifcation() {
    }

    public PacketItemModifcation(INetworkItem machine, PlayerEntity entity, byte packetId) {
        this();
        this.machine = machine;
        this.entity = entity;
        this.packetId = packetId;
        this.entityId = entity.func_145782_y();
    }

    public PacketItemModifcation(INetworkItem machine, PlayerEntity entity, byte packetId, CompoundNBT nbt) {
        this(machine, entity, packetId);
        this.nbt = nbt;
    }

    @Override
    public void write(PacketBuffer out) {
        BasePacket.writeWorld(out, this.entity.field_70170_p);
        out.writeInt(this.entity.func_145782_y());
        out.writeByte((int)this.packetId);
        out.writeBoolean(!this.nbt.isEmpty());
        if (!this.nbt.isEmpty()) {
            out.func_150786_a(this.nbt);
        }
        this.machine.writeDataToNetwork((ByteBuf)out, this.packetId, this.entity.func_184586_b(Hand.MAIN_HAND));
    }

    @Override
    public void read(PacketBuffer in) {
        ItemStack itemStack;
        World world = BasePacket.readWorld(in);
        int entityId = in.readInt();
        this.packetId = in.readByte();
        Entity ent = world.func_73045_a(entityId);
        if (ent == null) {
            for (Entity e : world.func_217369_A()) {
                if (e.func_145782_y() != entityId) continue;
                ent = e;
                break;
            }
        }
        if (in.readBoolean()) {
            CompoundNBT nbt = null;
            this.nbt = nbt = in.func_150793_b();
        }
        if (ent != null && ent instanceof PlayerEntity && (itemStack = ((PlayerEntity)ent).func_184586_b(Hand.MAIN_HAND)) != null && itemStack.func_77973_b() instanceof INetworkItem) {
            ((INetworkItem)itemStack.func_77973_b()).readDataFromNetwork((ByteBuf)in, this.packetId, this.nbt, itemStack);
        }
    }

    public void execute(PlayerEntity player, Dist side) {
        ItemStack itemStack;
        if (player != null && (itemStack = player.func_184586_b(Hand.MAIN_HAND)) != null && itemStack.func_77973_b() instanceof INetworkItem) {
            ((INetworkItem)itemStack.func_77973_b()).useNetworkData(player, side, this.packetId, this.nbt, itemStack);
        }
    }

    @Override
    public void executeServer(ServerPlayerEntity player) {
        this.execute((PlayerEntity)player, Dist.DEDICATED_SERVER);
    }

    @Override
    public void executeClient(PlayerEntity player) {
        this.execute(player, Dist.CLIENT);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readClient(PacketBuffer in) {
        ItemStack itemStack;
        PacketBuffer buffer = new PacketBuffer((ByteBuf)in);
        BasePacket.readWorld(in);
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        int entityId = buffer.readInt();
        this.packetId = buffer.readByte();
        Entity ent = world.func_73045_a(entityId);
        if (buffer.readBoolean()) {
            CompoundNBT nbt = null;
            this.nbt = nbt = buffer.func_150793_b();
        }
        if (ent != null && ent instanceof PlayerEntity && (itemStack = ((PlayerEntity)ent).func_184586_b(Hand.MAIN_HAND)) != null && itemStack.func_77973_b() instanceof INetworkItem) {
            ((INetworkItem)itemStack.func_77973_b()).readDataFromNetwork((ByteBuf)in, this.packetId, this.nbt, itemStack);
        }
    }
}

