/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.network;

import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.util.INetworkMachine;

public class PacketMachine
extends BasePacket {
    INetworkMachine machine;
    CompoundNBT nbt = new CompoundNBT();
    byte packetId;

    public PacketMachine() {
    }

    public PacketMachine(INetworkMachine machine, byte packetId) {
        this();
        this.machine = machine;
        this.packetId = packetId;
    }

    @Override
    public void write(PacketBuffer outline) {
        BasePacket.writeWorld(outline, ((TileEntity)this.machine).func_145831_w());
        outline.writeInt(((TileEntity)this.machine).func_174877_v().func_177958_n());
        outline.writeInt(((TileEntity)this.machine).func_174877_v().func_177956_o());
        outline.writeInt(((TileEntity)this.machine).func_174877_v().func_177952_p());
        outline.writeByte((int)this.packetId);
        this.machine.writeDataToNetwork(outline, this.packetId);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readClient(PacketBuffer in) {
        BasePacket.readWorld(in);
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        int x = in.readInt();
        int y = in.readInt();
        int z = in.readInt();
        this.packetId = in.readByte();
        TileEntity ent = world.func_175625_s(new BlockPos(x, y, z));
        if (ent != null && ent instanceof INetworkMachine) {
            this.machine = (INetworkMachine)ent;
            this.machine.readDataFromNetwork(in, this.packetId, this.nbt);
        }
    }

    @Override
    public void read(PacketBuffer in) {
        TileEntity ent;
        World world = BasePacket.readWorld(in);
        int x = in.readInt();
        int y = in.readInt();
        int z = in.readInt();
        this.packetId = in.readByte();
        BlockPos pos = new BlockPos(x, y, z);
        Chunk chunk = world.func_175726_f(pos);
        if (chunk != null && world.func_175667_e(pos) && (ent = world.func_175625_s(pos)) != null && ent instanceof INetworkMachine) {
            this.machine = (INetworkMachine)ent;
            this.machine.readDataFromNetwork(in, this.packetId, this.nbt);
        }
    }

    @Override
    public void executeClient(PlayerEntity player) {
        if (this.machine != null) {
            this.machine.useNetworkData(player, Dist.CLIENT, this.packetId, this.nbt);
        }
    }

    @Override
    public void executeServer(ServerPlayerEntity player) {
        if (this.machine != null) {
            this.machine.useNetworkData((PlayerEntity)player, Dist.DEDICATED_SERVER, this.packetId, this.nbt);
        }
    }

    public void execute(PlayerEntity player, Dist side) {
        if (this.machine != null) {
            this.machine.useNetworkData(player, side, this.packetId, this.nbt);
        }
    }
}

