/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.network;

import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.IEntitySpawnNBT;

public class PacketSpawnEntity
extends BasePacket {
    private int entityId;
    private UUID uniqueId;
    private double x;
    private double y;
    private double z;
    private int speedX;
    private int speedY;
    private int speedZ;
    private int pitch;
    private int yaw;
    private EntityType<?> type;
    private int data;
    private CompoundNBT nbt;

    public PacketSpawnEntity() {
    }

    public PacketSpawnEntity(int p_i50777_1_, UUID p_i50777_2_, double p_i50777_3_, double p_i50777_5_, double p_i50777_7_, float p_i50777_9_, float p_i50777_10_, EntityType<?> p_i50777_11_, int p_i50777_12_, Vector3d p_i50777_13_) {
        this.entityId = p_i50777_1_;
        this.uniqueId = p_i50777_2_;
        this.x = p_i50777_3_;
        this.y = p_i50777_5_;
        this.z = p_i50777_7_;
        this.pitch = MathHelper.func_76141_d((float)(p_i50777_9_ * 256.0f / 360.0f));
        this.yaw = MathHelper.func_76141_d((float)(p_i50777_10_ * 256.0f / 360.0f));
        this.type = p_i50777_11_;
        this.data = p_i50777_12_;
        this.speedX = (int)(MathHelper.func_151237_a((double)p_i50777_13_.field_72450_a, (double)-3.9, (double)3.9) * 8000.0);
        this.speedY = (int)(MathHelper.func_151237_a((double)p_i50777_13_.field_72448_b, (double)-3.9, (double)3.9) * 8000.0);
        this.speedZ = (int)(MathHelper.func_151237_a((double)p_i50777_13_.field_72449_c, (double)-3.9, (double)3.9) * 8000.0);
    }

    public PacketSpawnEntity(Entity p_i50778_1_) {
        this(p_i50778_1_, 0);
    }

    public PacketSpawnEntity(Entity p_i50778_1_, CompoundNBT nbt) {
        this(p_i50778_1_, 0);
        this.nbt = nbt;
    }

    public PacketSpawnEntity(Entity entityIn, int typeIn) {
        this(entityIn.func_145782_y(), entityIn.func_110124_au(), entityIn.func_226277_ct_(), entityIn.func_226278_cu_(), entityIn.func_226281_cx_(), entityIn.field_70125_A, entityIn.field_70177_z, entityIn.func_200600_R(), typeIn, entityIn.func_213322_ci());
    }

    public PacketSpawnEntity(Entity p_i50779_1_, EntityType<?> p_i50779_2_, int p_i50779_3_, BlockPos p_i50779_4_) {
        this(p_i50779_1_.func_145782_y(), p_i50779_1_.func_110124_au(), p_i50779_4_.func_177958_n(), p_i50779_4_.func_177956_o(), p_i50779_4_.func_177952_p(), p_i50779_1_.field_70125_A, p_i50779_1_.field_70177_z, p_i50779_2_, p_i50779_3_, p_i50779_1_.func_213322_ci());
    }

    @Override
    public void read(PacketBuffer buf) {
        this.entityId = buf.func_150792_a();
        this.uniqueId = buf.func_179253_g();
        this.type = (EntityType)Registry.field_212629_r.func_148745_a(buf.func_150792_a());
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.pitch = buf.readByte();
        this.yaw = buf.readByte();
        this.data = buf.readInt();
        this.speedX = buf.readShort();
        this.speedY = buf.readShort();
        this.speedZ = buf.readShort();
        boolean hasNBT = buf.readBoolean();
        if (hasNBT) {
            this.nbt = buf.func_150793_b();
        }
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.func_150787_b(this.entityId);
        buf.func_179252_a(this.uniqueId);
        buf.func_150787_b(Registry.field_212629_r.func_148757_b(this.type));
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeByte(this.pitch);
        buf.writeByte(this.yaw);
        buf.writeInt(this.data);
        buf.writeShort(this.speedX);
        buf.writeShort(this.speedY);
        buf.writeShort(this.speedZ);
        buf.writeBoolean(this.nbt != null);
        if (this.nbt != null) {
            buf.func_150786_a(this.nbt);
        }
    }

    @Override
    protected void readClient(PacketBuffer in) {
        this.read(in);
    }

    @Override
    public void executeServer(ServerPlayerEntity player) {
    }

    public void execute(Entity entity) {
        entity.func_184221_a(this.uniqueId);
        entity.func_70016_h((double)this.speedX, (double)this.speedY, (double)this.speedZ);
        entity.func_145769_d(this.entityId);
        if (this.nbt != null && entity instanceof IEntitySpawnNBT) {
            ((IEntitySpawnNBT)entity).readSpawnNBT(this.nbt);
        }
        entity.func_70080_a(this.x, this.y, this.z, (float)this.yaw, (float)this.pitch);
        entity.func_213312_b(this.x, this.y, this.z);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void executeClient(PlayerEntity player) {
        Entity entity = this.type.func_200721_a((World)Minecraft.func_71410_x().field_71441_e);
        entity.func_184221_a(this.uniqueId);
        entity.func_70016_h((double)this.speedX, (double)this.speedY, (double)this.speedZ);
        entity.func_145769_d(this.entityId);
        if (this.nbt != null && entity instanceof IEntitySpawnNBT) {
            ((IEntitySpawnNBT)entity).readSpawnNBT(this.nbt);
        }
        entity.func_70080_a(this.x, this.y, this.z, (float)this.yaw, (float)this.pitch);
        Minecraft.func_71410_x().field_71441_e.func_217411_a(this.entityId, entity);
        entity.func_70080_a(this.x, this.y, this.z, (float)this.yaw, (float)this.pitch);
        entity.func_213312_b(this.x, this.y, this.z);
    }
}

