/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.SmithingRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;
import zmaster587.libVulpes.interfaces.IRecipe;
import zmaster587.libVulpes.recipe.RecipesMachine;

public abstract class RecipeMachineFactory
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<IRecipe> {
    public static IRecipeType<SmithingRecipe> machiningType = IRecipeType.func_222147_a((String)"machining");

    public IRecipe read(ResourceLocation context, PacketBuffer buffer) {
        LinkedList<List<ItemStack>> inputs = new LinkedList<List<ItemStack>>();
        LinkedList<RecipesMachine.ChanceItemStack> outputs = new LinkedList<RecipesMachine.ChanceItemStack>();
        LinkedList<FluidStack> inputFluids = new LinkedList<FluidStack>();
        LinkedList<RecipesMachine.ChanceFluidStack> outputFluids = new LinkedList<RecipesMachine.ChanceFluidStack>();
        int timeTaken = 0;
        int energy = 0;
        int maxOutput = -1;
        for (int ingredientListSize = buffer.readInt(); ingredientListSize > 0; --ingredientListSize) {
            LinkedList<ItemStack> stacks = new LinkedList<ItemStack>();
            for (int subingredient = buffer.readInt(); subingredient > 0; --subingredient) {
                stacks.add(buffer.func_150791_c());
            }
            inputs.add(stacks);
        }
        for (int fluidCount = buffer.readInt(); fluidCount > 0; --fluidCount) {
            FluidStack stack = buffer.readFluidStack();
            inputFluids.add(stack);
        }
        for (int productCount = buffer.readInt(); productCount > 0; --productCount) {
            ItemStack stack = buffer.func_150791_c();
            float chance = buffer.readFloat();
            outputs.add(new RecipesMachine.ChanceItemStack(stack, chance));
        }
        for (int fluidOutputCount = buffer.readInt(); fluidOutputCount > 0; --fluidOutputCount) {
            FluidStack stack = buffer.readFluidStack();
            float chance = buffer.readFloat();
            outputFluids.add(new RecipesMachine.ChanceFluidStack(stack, chance));
        }
        energy = buffer.readInt();
        timeTaken = buffer.readInt();
        maxOutput = buffer.readInt();
        RecipesMachine.Recipe recipe = new RecipesMachine.Recipe(this, context, outputs, inputs, outputFluids, inputFluids, timeTaken, energy, new HashMap<Integer, ResourceLocation>());
        if (maxOutput > 0) {
            recipe.setMaxOutputSize(maxOutput);
        }
        RecipesMachine.getInstance().recipeList.get(this.getMachine()).removeIf(value -> value.func_199560_c().equals((Object)recipe.func_199560_c()));
        RecipesMachine.getInstance().recipeList.get(this.getMachine()).add(recipe);
        return recipe;
    }

    public void write(PacketBuffer buffer, IRecipe recipe) {
        buffer.writeInt(recipe.getPossibleIngredients().size());
        for (List<ItemStack> list : recipe.getPossibleIngredients()) {
            buffer.writeInt(list.size());
            for (ItemStack ingredient : list) {
                buffer.func_150788_a(ingredient);
            }
        }
        buffer.writeInt(recipe.getFluidIngredients().size());
        for (FluidStack fluidStack : recipe.getFluidIngredients()) {
            buffer.writeFluidStack(fluidStack);
        }
        buffer.writeInt(recipe.getOutput().size());
        for (RecipesMachine.ChanceItemStack chanceItemStack : recipe._getRawOutput()) {
            buffer.func_150788_a(chanceItemStack.stack);
            buffer.writeFloat(chanceItemStack.chance);
        }
        buffer.writeInt(recipe.getFluidOutputs().size());
        for (RecipesMachine.ChanceFluidStack chanceFluidStack : recipe._getRawFluidOutput()) {
            buffer.writeFluidStack(chanceFluidStack.stack);
            buffer.writeFloat(chanceFluidStack.chance);
        }
        buffer.writeInt(recipe.getPower());
        buffer.writeInt(recipe.getTime());
        buffer.writeInt(recipe.getRequiredEmptyOutputs());
    }

    public IRecipe read(ResourceLocation context, JsonObject json) {
        LinkedList<List<ItemStack>> inputs = new LinkedList();
        List<Object> outputs = new LinkedList();
        LinkedList<FluidStack> inputFluids = new LinkedList<FluidStack>();
        LinkedList<RecipesMachine.ChanceFluidStack> outputFluids = new LinkedList();
        int timeTaken = 0;
        int energy = 0;
        int maxOutput = -1;
        try {
            JsonElement fluidResultElement;
            JsonElement fluidIngredientElement;
            JsonElement ingredientElement = json.get("itemingredients");
            if (ingredientElement != null) {
                inputs = this.getIngredientsFromArray(context, ingredientElement);
            }
            JsonElement itemResults = json.get("itemresults");
            JsonElement maxOutputJson = json.get("maxoutputsize");
            if (maxOutputJson != null) {
                maxOutput = maxOutputJson.getAsInt();
            }
            if (itemResults != null) {
                if (itemResults.isJsonArray()) {
                    for (JsonElement element : itemResults.getAsJsonArray()) {
                        outputs.addAll(this.getFirstIngredient(context, element));
                    }
                } else {
                    outputs = this.getFirstIngredient(context, itemResults);
                }
            }
            if ((fluidIngredientElement = json.get("fluidingredients")) != null) {
                for (RecipesMachine.ChanceFluidStack stack : this.getFluidStacks(context, fluidIngredientElement)) {
                    inputFluids.add(stack.stack);
                }
            }
            if ((fluidResultElement = json.get("fluidresults")) != null) {
                outputFluids = this.getFluidStacks(context, fluidResultElement);
            }
            timeTaken = json.get("time").getAsInt();
            energy = json.get("energy").getAsInt();
        }
        catch (NullPointerException e) {
            throw new JsonParseException("Missing parameters");
        }
        catch (InvalidRecipeException e) {
            throw new JsonParseException(e.getMessage());
        }
        RecipesMachine.Recipe recipe = new RecipesMachine.Recipe(this, context, outputs, inputs, outputFluids, inputFluids, timeTaken, energy, new HashMap<Integer, ResourceLocation>());
        if (maxOutput > 0) {
            recipe.setMaxOutputSize(maxOutput);
        }
        RecipesMachine.getInstance().recipeList.get(this.getMachine()).removeIf(value -> value.func_199560_c().equals((Object)recipe.func_199560_c()));
        RecipesMachine.getInstance().recipeList.get(this.getMachine()).add(recipe);
        return recipe;
    }

    public abstract Class getMachine();

    public List<RecipesMachine.ChanceFluidStack> getFluidStacks(ResourceLocation context, JsonElement json) throws InvalidRecipeException {
        if (!json.isJsonArray()) {
            return null;
        }
        LinkedList<RecipesMachine.ChanceFluidStack> fluidstacks = new LinkedList<RecipesMachine.ChanceFluidStack>();
        JsonArray ingredientListJSON = json.getAsJsonArray();
        for (JsonElement ingredient : ingredientListJSON) {
            fluidstacks.add(this.parseFluid(context, ingredient));
        }
        return fluidstacks;
    }

    public RecipesMachine.ChanceFluidStack parseFluid(ResourceLocation context, JsonElement json) throws InvalidRecipeException {
        Fluid fluid;
        String fluidname = json.getAsJsonObject().get("fluid").getAsString();
        int size = json.getAsJsonObject().get("amount").getAsInt();
        JsonElement chanceElem = json.getAsJsonObject().get("chance");
        float chance = 0.0f;
        if (chanceElem != null) {
            chance = chanceElem.getAsFloat();
        }
        if ((fluid = (Fluid)Registry.field_212619_h.func_82594_a(new ResourceLocation(fluidname))).func_207187_a(Fluids.field_204541_a)) {
            throw new InvalidRecipeException("Fluid '" + fluidname + "' is not a valid fluid!");
        }
        return new RecipesMachine.ChanceFluidStack(new FluidStack(fluid, size), chance);
    }

    List<List<ItemStack>> getIngredientsFromArray(ResourceLocation context, JsonElement json) {
        if (!json.isJsonArray()) {
            return null;
        }
        JsonArray ingredientListJSON = json.getAsJsonArray();
        LinkedList<List<ItemStack>> inputs = new LinkedList<List<ItemStack>>();
        for (JsonElement ingredient : ingredientListJSON) {
            LinkedList<ItemStack> newList = new LinkedList<ItemStack>();
            for (RecipesMachine.ChanceItemStack stack3 : this.getIngredients(context, ingredient)) {
                newList.add(stack3.stack);
            }
            inputs.add(newList);
        }
        return inputs;
    }

    List<RecipesMachine.ChanceItemStack> getIngredients(ResourceLocation context, JsonElement json) {
        LinkedList<RecipesMachine.ChanceItemStack> stacks = new LinkedList<RecipesMachine.ChanceItemStack>();
        for (ItemStack stack : CraftingHelper.getIngredient((JsonElement)json).func_193365_a()) {
            int count = stack.func_190916_E();
            int data = stack.func_77952_i();
            float chance = 0.0f;
            ItemStack stack2 = stack.func_77946_l();
            JsonElement countElem = json.getAsJsonObject().get("count");
            JsonElement dataElem = json.getAsJsonObject().get("data");
            JsonElement chanceElem = json.getAsJsonObject().get("chance");
            if (countElem != null) {
                count = countElem.getAsInt();
            }
            if (dataElem != null) {
                data = dataElem.getAsInt();
            }
            if (chanceElem != null) {
                chance = chanceElem.getAsFloat();
            }
            stack2.func_190920_e(count);
            stack2.func_196085_b(data);
            stacks.add(new RecipesMachine.ChanceItemStack(stack2, chance));
        }
        return stacks;
    }

    List<RecipesMachine.ChanceItemStack> getFirstIngredient(ResourceLocation context, JsonElement json) {
        List<RecipesMachine.ChanceItemStack> stacks = this.getIngredients(context, json);
        if (stacks.size() > 1) {
            RecipesMachine.ChanceItemStack stack = stacks.get(0);
            stacks = new LinkedList<RecipesMachine.ChanceItemStack>();
            stacks.add(stack);
        }
        return stacks;
    }

    public static class InvalidRecipeException
    extends Exception {
        public InvalidRecipeException(String reason) {
            super(reason);
        }
    }
}

