/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.recipe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.interfaces.IRecipe;
import zmaster587.libVulpes.recipe.NumberedOreDictStack;
import zmaster587.libVulpes.recipe.RecipeMachineFactory;
import zmaster587.libVulpes.tile.TileEntityMachine;

public class RecipesMachine {
    public HashMap<Class<?>, List<IRecipe>> recipeList = new HashMap();
    private static RecipesMachine instance = new RecipesMachine();

    public static RecipesMachine getInstance() {
        return instance;
    }

    public void clearRecipes(Class<? extends TileEntityMachine> clazz) {
        this.recipeList.get(clazz).clear();
    }

    public void addRecipe(ResourceLocation name, IRecipeSerializer<?> serializer, Class clazz, Object[] out, int timeRequired, int power, Object ... inputs) {
        List<IRecipe> recipes = this.getRecipes(clazz);
        if (recipes == null) {
            recipes = new LinkedList<IRecipe>();
            this.recipeList.put(clazz, recipes);
        }
        HashMap<Integer, ResourceLocation> oreDict = new HashMap<Integer, ResourceLocation>();
        LinkedList<List<ItemStack>> stack = new LinkedList<List<ItemStack>>();
        ArrayList<FluidStack> inputFluidStacks = new ArrayList<FluidStack>();
        try {
            for (int i = 0; i < inputs.length; ++i) {
                LinkedList<ItemStack> innerList = new LinkedList<ItemStack>();
                if (inputs[i] != null) {
                    if (inputs[i] instanceof String) {
                        ResourceLocation res = new ResourceLocation((String)inputs[i]);
                        oreDict.put(i, res);
                        for (Item item : ItemTags.func_199903_a().func_199910_a(res).func_230236_b_()) {
                            innerList.add(new ItemStack((IItemProvider)item));
                        }
                    } else if (inputs[i] instanceof ResourceLocation) {
                        oreDict.put(i, (ResourceLocation)inputs[i]);
                        if (!ItemTags.func_199903_a().func_199908_a().contains((ResourceLocation)inputs[i])) {
                            throw new NullPointerException("No such item tag registered: " + ((ResourceLocation)inputs[i]).toString());
                        }
                        for (Item item : ItemTags.func_199903_a().func_199910_a((ResourceLocation)inputs[i]).func_230236_b_()) {
                            innerList.add(new ItemStack((IItemProvider)item));
                        }
                    } else if (inputs[i] instanceof NumberedOreDictStack) {
                        oreDict.put(i, ((NumberedOreDictStack)inputs[i]).ore);
                        for (Item item : ItemTags.func_199903_a().func_199910_a(new ResourceLocation((String)inputs[i])).func_230236_b_()) {
                            int number = ((NumberedOreDictStack)inputs[i]).getNumber();
                            ItemStack stack2 = new ItemStack((IItemProvider)item, number);
                            stack2.func_190920_e(number);
                            innerList.add(stack2);
                        }
                    } else if (inputs[i] instanceof FluidStack) {
                        inputFluidStacks.add((FluidStack)inputs[i]);
                    } else {
                        if (inputs[i] instanceof Item) {
                            inputs[i] = new ItemStack((IItemProvider)((Item)inputs[i]));
                        } else if (inputs[i] instanceof Block) {
                            inputs[i] = new ItemStack((IItemProvider)((Block)inputs[i]));
                        }
                        innerList.add((ItemStack)inputs[i]);
                    }
                }
                if (innerList.isEmpty()) continue;
                stack.add(innerList);
            }
            ArrayList<ChanceItemStack> outputItem = new ArrayList<ChanceItemStack>();
            ArrayList<ChanceFluidStack> outputFluidStacks = new ArrayList<ChanceFluidStack>();
            for (ResourceLocation outputObject : out) {
                if (outputObject instanceof ItemStack) {
                    outputItem.add(new ChanceItemStack((ItemStack)outputObject, 0.0f));
                    continue;
                }
                outputFluidStacks.add(new ChanceFluidStack((FluidStack)outputObject, 0.0f));
            }
            Recipe recipe = inputFluidStacks.isEmpty() && outputFluidStacks.isEmpty() ? new Recipe(serializer, name, outputItem, stack, timeRequired, power, oreDict) : new Recipe(serializer, name, outputItem, stack, outputFluidStacks, inputFluidStacks, timeRequired, power, oreDict);
            if (recipes.contains(recipe)) {
                LibVulpes.logger.info("Overwriting recipe " + recipes.remove(recipe));
            }
            recipes.add(recipe);
        }
        catch (ClassCastException e) {
            String message = e.getLocalizedMessage();
            for (StackTraceElement element : e.getStackTrace()) {
                message = message + "\n\t" + element.toString();
            }
            LibVulpes.logger.warn("Cannot add recipe!");
            LibVulpes.logger.warn(message);
        }
        catch (NullPointerException e) {
            String message = e.getLocalizedMessage();
            for (StackTraceElement element : e.getStackTrace()) {
                message = message + "\n\t" + element.toString();
            }
            LibVulpes.logger.warn("Cannot add recipe!");
            LibVulpes.logger.warn(message);
        }
    }

    public void addRecipe(ResourceLocation name, IRecipeSerializer<?> serializer, Class clazz, Object out, int timeRequired, int power, Object ... inputs) {
        this.addRecipe(name, serializer, clazz, new Object[]{out}, timeRequired, power, inputs);
    }

    public void addRecipe(ResourceLocation name, IRecipeSerializer<?> serializer, Class clazz, List<Object> out, int timeRequired, int power, List<Object> inputs) {
        Object[] outputs = new Object[out.size()];
        outputs = out.toArray(outputs);
        Object[] inputs2 = new Object[inputs.size()];
        inputs2 = inputs.toArray(inputs2);
        this.addRecipe(name, serializer, clazz, outputs, timeRequired, power, inputs2);
    }

    public List<IRecipe> getRecipes(Class clazz) {
        return this.recipeList.get(clazz);
    }

    public static class Recipe
    implements IRecipe {
        private List<List<ItemStack>> input;
        private Map<Integer, ResourceLocation> inputOreDict;
        private LinkedList<FluidStack> fluidInput;
        private LinkedList<ChanceItemStack> output = new LinkedList();
        private LinkedList<ChanceFluidStack> fluidOutput;
        private int completionTime;
        private int power;
        private int maxOutputSize;
        IRecipeSerializer<?> serializer;
        ResourceLocation name;

        public Recipe() {
            this.input = new LinkedList<List<ItemStack>>();
            this.fluidInput = new LinkedList();
            this.fluidOutput = new LinkedList();
        }

        public Recipe(IRecipeSerializer<?> serializer, ResourceLocation name, List<ChanceItemStack> output, List<List<ItemStack>> input, int completionTime, int powerReq, Map<Integer, ResourceLocation> oreDict) {
            this.output.addAll(output);
            this.input = new LinkedList<List<ItemStack>>();
            this.input.addAll(input);
            this.completionTime = completionTime;
            this.power = powerReq;
            this.fluidInput = new LinkedList();
            this.fluidOutput = new LinkedList();
            this.inputOreDict = oreDict;
            this.maxOutputSize = -1;
            this.serializer = serializer;
            this.name = name;
        }

        public Recipe(IRecipeSerializer<?> serializer, ResourceLocation name, List<ChanceItemStack> output, List<List<ItemStack>> input, List<ChanceFluidStack> fluidOutput, List<FluidStack> fluidInput, int completionTime, int powerReq, Map<Integer, ResourceLocation> oreDict) {
            this(serializer, name, output, input, completionTime, powerReq, oreDict);
            this.fluidInput.addAll(fluidInput);
            this.fluidOutput.addAll(fluidOutput);
        }

        public void setMaxOutputSize(int size) {
            this.maxOutputSize = size;
        }

        public int getCompletionTime() {
            return this.completionTime;
        }

        public int getPowerReq() {
            return this.power;
        }

        @Override
        public List<List<ItemStack>> getPossibleIngredients() {
            return this.input;
        }

        @Override
        public ResourceLocation getOreDictString(int slot) {
            return this.inputOreDict == null ? null : this.inputOreDict.get(slot);
        }

        @Override
        public List<FluidStack> getFluidIngredients() {
            return this.fluidInput;
        }

        @Override
        public List<FluidStack> getFluidOutputs() {
            LinkedList<FluidStack> stacks = new LinkedList<FluidStack>();
            this.fluidOutput.forEach(s -> stacks.add(s.stack));
            return stacks;
        }

        @Override
        public int getTime() {
            return this.completionTime;
        }

        @Override
        public int getPower() {
            return this.power;
        }

        @Override
        public List<ChanceItemStack> _getRawOutput() {
            return this.output;
        }

        @Override
        public List<ChanceFluidStack> _getRawFluidOutput() {
            return this.fluidOutput;
        }

        @Override
        public List<ItemStack> getOutput() {
            ArrayList<ItemStack> stack = new ArrayList<ItemStack>();
            int maxOutputSize = this.getRequiredEmptyOutputs();
            if (maxOutputSize > 0) {
                float maxChance = 0.0f;
                Random rand = new Random(System.currentTimeMillis());
                for (ChanceItemStack i : this.output) {
                    maxChance += i.chance;
                }
                block1: for (int i = 0; i < maxOutputSize; ++i) {
                    float currentHit = rand.nextFloat() * maxChance;
                    float currChance = 0.0f;
                    ItemStack nextStack = this.output.get((int)0).stack;
                    for (ChanceItemStack currStack : this.output) {
                        if ((currChance += currStack.chance) > currentHit) {
                            stack.add(nextStack.func_77946_l());
                            continue block1;
                        }
                        nextStack = currStack.stack;
                    }
                }
            } else {
                for (ChanceItemStack i : this.output) {
                    stack.add(i.stack.func_77946_l());
                }
            }
            if (stack.contains(null)) {
                while (stack.remove(null)) {
                }
                LibVulpes.logger.warn("Recipe " + this.func_199560_c().toString() + " has null item output, this should NOT happen!!");
            }
            return stack;
        }

        public List<ChanceItemStack> getChanceOutputs() {
            return this.output;
        }

        @Override
        public int getRequiredEmptyOutputs() {
            return this.maxOutputSize;
        }

        public boolean outputToOnlyEmptySlots() {
            return this.maxOutputSize != -1;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Recipe) {
                int i;
                Recipe otherRecipe = (Recipe)obj;
                if (this.input.size() != otherRecipe.input.size() || this.fluidInput.size() != otherRecipe.fluidInput.size()) {
                    return false;
                }
                for (i = 0; i < this.input.size(); ++i) {
                    if (this.input.get(i).size() != otherRecipe.input.get(i).size()) {
                        return false;
                    }
                    for (int j = 0; j < this.input.get(i).size(); ++j) {
                        if (ItemStack.func_77989_b((ItemStack)this.input.get(i).get(j), (ItemStack)otherRecipe.input.get(i).get(j))) continue;
                        return false;
                    }
                }
                for (i = 0; i < this.fluidInput.size(); ++i) {
                    if (this.fluidInput.get(i).getFluid() == otherRecipe.fluidInput.get(i).getFluid()) continue;
                    return false;
                }
            }
            return true;
        }

        public boolean func_77569_a(IInventory inv, World worldIn) {
            return false;
        }

        public ItemStack func_77572_b(IInventory inv) {
            return null;
        }

        public boolean func_194133_a(int width, int height) {
            return false;
        }

        public ItemStack func_77571_b() {
            return ItemStack.field_190927_a;
        }

        public ResourceLocation func_199560_c() {
            return this.name;
        }

        public IRecipeSerializer<?> func_199559_b() {
            return this.serializer;
        }

        public IRecipeType<?> func_222127_g() {
            return RecipeMachineFactory.machiningType;
        }
    }

    public static class ChanceFluidStack {
        public FluidStack stack;
        public float chance;

        public ChanceFluidStack(FluidStack stack, float chance) {
            this.stack = stack;
            this.chance = chance;
        }
    }

    public static class ChanceItemStack {
        public ItemStack stack;
        public float chance;

        public ChanceItemStack(ItemStack stack, float chance) {
            this.stack = stack;
            this.chance = chance;
        }
    }
}

