/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.render;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class RenderHelper {
    protected static final RenderState.TransparencyState LIGHTNING_TRANSPARENCY = new RenderState.TransparencyState("lightning_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final RenderState.TransparencyState NO_TRANSPARENCY = new RenderState.TransparencyState("no_transparency", () -> RenderSystem.disableBlend(), () -> {});
    protected static final RenderState.TransparencyState TRANSLUCENT_TRANSPARENCY = new RenderState.TransparencyState("translucent_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final RenderState.TransparencyState TRANSPARENT_TRANSPARENCY = new RenderState.TransparencyState("translucent_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    });
    public static final VertexFormat POSITION_COLOR_LIGHTMAP_NORMAL = new VertexFormat(ImmutableList.builder().add((Object)DefaultVertexFormats.field_181713_m).add((Object)DefaultVertexFormats.field_181714_n).add((Object)DefaultVertexFormats.field_227848_e_).add((Object)DefaultVertexFormats.field_181717_q).add((Object)DefaultVertexFormats.field_181718_r).build());
    protected static final RenderState.AlphaState DEFAULT_ALPHA = new RenderState.AlphaState(0.003921569f);
    protected static final RenderState.LightmapState LIGHTMAP_ENABLED = new RenderState.LightmapState(true);
    protected static final RenderState.LightmapState LIGHTMAP_DISABLED = new RenderState.LightmapState(false);
    protected static final RenderState.OverlayState OVERLAY_ENABLED = new RenderState.OverlayState(true);
    protected static final RenderState.OverlayState OVERLAY_DISABLED = new RenderState.OverlayState(false);
    protected static final RenderState.DiffuseLightingState DIFFUSE_LIGHTING_ENABLED = new RenderState.DiffuseLightingState(true);
    protected static final RenderState.DiffuseLightingState DIFFUSE_LIGHTING_DISABLED = new RenderState.DiffuseLightingState(false);
    protected static final RenderState.CullState CULL_ENABLED = new RenderState.CullState(true);
    protected static final RenderState.CullState CULL_DISABLED = new RenderState.CullState(false);
    protected static final RenderState.DepthTestState DEPTH_ALWAYS = new RenderState.DepthTestState("always", 519);
    protected static final RenderState.DepthTestState DEPTH_EQUAL = new RenderState.DepthTestState("==", 514);
    protected static final RenderState.DepthTestState DEPTH_LEQUAL = new RenderState.DepthTestState("<=", 515);
    protected static final RenderState.WriteMaskState COLOR_DEPTH_WRITE = new RenderState.WriteMaskState(true, true);
    protected static final RenderState.WriteMaskState COLOR_WRITE = new RenderState.WriteMaskState(true, false);
    protected static final RenderState.WriteMaskState DEPTH_WRITE = new RenderState.WriteMaskState(false, true);
    protected static final RenderState.LayerState NO_LAYERING = new RenderState.LayerState("no_layering", () -> {}, () -> {});
    protected static final RenderState.WriteMaskState COLOR_ONLY = new RenderState.WriteMaskState(true, false);
    protected static final RenderState.TargetState TRANSLUCENT_TARGET = new RenderState.TargetState("translucent_target", () -> {
        if (Minecraft.func_238218_y_()) {
            Minecraft.func_71410_x().field_71438_f.func_239228_q_().func_147610_a(false);
        }
    }, () -> {
        if (Minecraft.func_238218_y_()) {
            Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
        }
    });
    protected static final RenderState.ShadeModelState SHADE_DISABLED = new RenderState.ShadeModelState(false);
    protected static final RenderState.ShadeModelState SHADE_ENABLED = new RenderState.ShadeModelState(true);
    private static final RenderType SEMI_TRANSLUCENT = RenderType.func_228633_a_((String)"coloredTranslucent", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)4, (int)256, (boolean)false, (boolean)true, (RenderType.State)RenderType.State.func_228694_a_().func_228727_a_(COLOR_ONLY).func_228726_a_(LIGHTNING_TRANSPARENCY).func_228721_a_(TRANSLUCENT_TARGET).func_228723_a_(SHADE_DISABLED).func_228728_a_(true));
    private static final VertexFormat POS_TEX_NORMAL = new VertexFormat(ImmutableList.builder().add((Object)DefaultVertexFormats.field_181713_m).add((Object)DefaultVertexFormats.field_181715_o).add((Object)DefaultVertexFormats.field_181717_q).add((Object)DefaultVertexFormats.field_181718_r).build());
    private static final VertexFormat POS_NORMAL = new VertexFormat(ImmutableList.builder().add((Object)DefaultVertexFormats.field_181713_m).add((Object)DefaultVertexFormats.field_181717_q).add((Object)DefaultVertexFormats.field_181718_r).build());
    protected static final RenderState.TextureState BLOCK_SHEET_MIPPED = new RenderState.TextureState(AtlasTexture.field_110575_b, false, true);
    private static final RenderType TRANSLUCENTBLOCK = RenderType.func_228633_a_((String)"translucent_custom", (VertexFormat)DefaultVertexFormats.field_176600_a, (int)7, (int)262144, (boolean)true, (boolean)true, (RenderType.State)RenderHelper.getTranslucentState());

    private static RenderType.State getTranslucentState() {
        return RenderType.State.func_228694_a_().func_228723_a_(SHADE_ENABLED).func_228719_a_(LIGHTMAP_ENABLED).func_228724_a_(BLOCK_SHEET_MIPPED).func_228726_a_(LIGHTNING_TRANSPARENCY).func_228721_a_(TRANSLUCENT_TARGET).func_228728_a_(true);
    }

    public static final RenderType getSolidEntityModelRenderType(ResourceLocation tex) {
        RenderType.State rendertype$state = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(tex, false, false)).func_228726_a_(NO_TRANSPARENCY).func_228716_a_(DIFFUSE_LIGHTING_ENABLED).func_228719_a_(LIGHTMAP_ENABLED).func_228722_a_(OVERLAY_ENABLED).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"entity_custom_solid", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)4, (int)256, (boolean)true, (boolean)false, (RenderType.State)rendertype$state);
    }

    public static final RenderType getTranslucentEntityModelRenderType(ResourceLocation tex) {
        RenderType.State rendertype$state = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(tex, false, false)).func_228726_a_(TRANSLUCENT_TRANSPARENCY).func_228716_a_(DIFFUSE_LIGHTING_ENABLED).func_228713_a_(DEFAULT_ALPHA).func_228714_a_(CULL_DISABLED).func_228719_a_(LIGHTMAP_ENABLED).func_228722_a_(OVERLAY_ENABLED).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"entity_custom_translucent", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)4, (int)256, (boolean)true, (boolean)false, (RenderType.State)rendertype$state);
    }

    public static final RenderType getTranslucentNoTexEntityModelRenderType() {
        RenderType.State rendertype$state = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState()).func_228726_a_(TRANSLUCENT_TRANSPARENCY).func_228716_a_(DIFFUSE_LIGHTING_ENABLED).func_228713_a_(DEFAULT_ALPHA).func_228714_a_(CULL_DISABLED).func_228719_a_(LIGHTMAP_ENABLED).func_228722_a_(OVERLAY_ENABLED).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"entity_custom_translucent", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)4, (int)256, (boolean)true, (boolean)false, (RenderType.State)rendertype$state);
    }

    public static final RenderType getLightningTranslucencyNoTexEntityModelRenderType() {
        RenderType.State rendertype$state = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState()).func_228726_a_(TRANSLUCENT_TRANSPARENCY).func_228713_a_(DEFAULT_ALPHA).func_228726_a_(LIGHTNING_TRANSPARENCY).func_228716_a_(DIFFUSE_LIGHTING_ENABLED).func_228719_a_(LIGHTMAP_ENABLED).func_228722_a_(OVERLAY_DISABLED).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"entity_custom_translucent_notex", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)4, (int)256, (boolean)true, (boolean)false, (RenderType.State)rendertype$state);
    }

    public static final RenderType getTranslucentManualRenderType() {
        RenderType.State rendertype$state = RenderType.State.func_228694_a_().func_228726_a_(TRANSLUCENT_TRANSPARENCY).func_228716_a_(DIFFUSE_LIGHTING_ENABLED).func_228713_a_(DEFAULT_ALPHA).func_228714_a_(CULL_DISABLED).func_228719_a_(LIGHTMAP_ENABLED).func_228722_a_(OVERLAY_ENABLED).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"coloredTranslucent", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)256, (boolean)true, (boolean)true, (RenderType.State)rendertype$state);
    }

    public static final RenderType getSolidManualRenderType() {
        return RenderType.func_228633_a_((String)"coloredTranslucent", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)256, (boolean)true, (boolean)true, (RenderType.State)RenderType.State.func_228694_a_().func_228726_a_(LIGHTNING_TRANSPARENCY).func_228721_a_(TRANSLUCENT_TARGET).func_228723_a_(SHADE_DISABLED).func_228728_a_(true));
    }

    public static RenderType getTranslucentTexturedManualRenderType(ResourceLocation location) {
        RenderType.State rendertype$state = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(location, false, false)).func_228713_a_(DEFAULT_ALPHA).func_228726_a_(LIGHTNING_TRANSPARENCY).func_228716_a_(DIFFUSE_LIGHTING_ENABLED).func_228719_a_(LIGHTMAP_DISABLED).func_228722_a_(OVERLAY_DISABLED).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"manual_tex_translucent", (VertexFormat)DefaultVertexFormats.field_227851_o_, (int)7, (int)256, (boolean)true, (boolean)false, (RenderType.State)rendertype$state);
    }

    public static RenderType getSolidTexturedManualRenderType(ResourceLocation location) {
        RenderType.State rendertype$state = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(location, false, false)).func_228726_a_(NO_TRANSPARENCY).func_228716_a_(DIFFUSE_LIGHTING_ENABLED).func_228719_a_(LIGHTMAP_ENABLED).func_228722_a_(OVERLAY_DISABLED).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"manual_tex_solid", (VertexFormat)DefaultVertexFormats.field_227851_o_, (int)7, (int)256, (boolean)true, (boolean)false, (RenderType.State)rendertype$state);
    }

    public static RenderType getTranslucentColoredManualRenderType(ResourceLocation location, float r, float g, float b, float a) {
        RenderType.State rendertype$state = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(location, false, false)).func_228726_a_(LIGHTNING_TRANSPARENCY).func_228716_a_(DIFFUSE_LIGHTING_ENABLED).func_228719_a_(LIGHTMAP_ENABLED).func_228722_a_(OVERLAY_ENABLED).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"manual_col_translucent", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)256, (boolean)true, (boolean)false, (RenderType.State)rendertype$state);
    }

    public static RenderType getParticleType(ResourceLocation icon) {
        RenderType.State rendertype$state = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(icon, false, false)).func_228727_a_(new RenderState.WriteMaskState(true, true)).func_228726_a_(LIGHTNING_TRANSPARENCY).func_228716_a_(DIFFUSE_LIGHTING_DISABLED).func_228728_a_(false);
        return RenderType.func_228633_a_((String)"manual_col_translucent", (VertexFormat)DefaultVertexFormats.field_181704_d, (int)7, (int)256, (boolean)true, (boolean)false, (RenderType.State)rendertype$state);
    }

    public static RenderType getLaserBeamType() {
        RenderType.State rendertype$state = RenderType.State.func_228694_a_().func_228726_a_(LIGHTNING_TRANSPARENCY).func_228716_a_(DIFFUSE_LIGHTING_DISABLED).func_228713_a_(DEFAULT_ALPHA).func_228714_a_(CULL_DISABLED).func_228719_a_(LIGHTMAP_DISABLED).func_228722_a_(OVERLAY_DISABLED).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"coloredTranslucent", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)256, (boolean)true, (boolean)true, (RenderType.State)rendertype$state);
    }

    public static RenderType getTranslucentBlock() {
        return TRANSLUCENTBLOCK;
    }

    public static void renderTag(MatrixStack matrix, IRenderTypeBuffer buffer, double distanceSq, String displayString, int packedLightIn, float scale) {
        double d3 = distanceSq;
        Minecraft mc = Minecraft.func_71410_x();
        EntityRendererManager renderManager = mc.func_175598_ae();
        if (!(distanceSq > 4096.0)) {
            matrix.func_227860_a_();
            matrix.func_227863_a_(renderManager.func_229098_b_());
            float f = 1.6f * scale;
            float f2 = 0.016666668f * f;
            matrix.func_227862_a_(-f2, -f2, f2);
            Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
            float f1 = Minecraft.func_71410_x().field_71474_y.func_216840_a(0.25f);
            int j = (int)(f1 * 255.0f) << 24;
            FontRenderer fontrenderer = Minecraft.func_71410_x().field_71466_p;
            float f3 = -fontrenderer.func_238414_a_((ITextProperties)new StringTextComponent(displayString)) / 2;
            fontrenderer.func_243247_a((ITextComponent)new StringTextComponent(displayString), f3, 0.0f, 0x20FFFFFF, false, matrix4f, buffer, true, j, packedLightIn);
            matrix.func_227865_b_();
        }
    }

    public static IVertexBuilder vertexPos(MatrixStack matrix, IVertexBuilder builder, double x, double y, double z) {
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        Vector4f vector4f = new Vector4f((float)x, (float)y, (float)z, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        return builder.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c());
    }

    public static void cleanupPlayerFacingMatrix() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public static void renderBlockWithEndPointers(MatrixStack matrix, IVertexBuilder buff, double radius, double x1, double y1, double z1, double x2, double y2, double z2, float r, float g, float b, float a) {
        RenderHelper.renderBottomFaceEndpoints(matrix, buff, radius, x1, y1 - radius / 2.0, z1, x2, y2 - radius / 2.0, z2, r, g, b, a);
        RenderHelper.renderTopFaceEndpoints(matrix, buff, radius, x1, y1 + radius / 2.0, z1, x2, y2 + radius / 2.0, z2, r, g, b, a);
        RenderHelper.renderNorthFaceEndpoints(matrix, buff, radius, x1, y1, z1 + radius / 2.0, x2, y2, z2 + radius / 2.0, r, g, b, a);
        RenderHelper.renderSouthFaceEndpoints(matrix, buff, radius, x1, y1, z1 - radius / 2.0, x2, y2, z2 - radius / 2.0, r, g, b, a);
        RenderHelper.renderEastFaceEndpoints(matrix, buff, radius, x1 + radius / 2.0, y1, z1, x2 + radius / 2.0, y2, z2, r, g, b, a);
        RenderHelper.renderWestFaceEndpoints(matrix, buff, radius, x1 - radius / 2.0, y1, z1, x2 - radius / 2.0, y2, z2, r, g, b, a);
    }

    public static void renderCrossXZ(MatrixStack matrix, IVertexBuilder buff, double width, double xMin, double yMin, double zMin, double xMax, double yMax, double zMax, float r, float g, float b, float a) {
        RenderHelper.renderTopFaceEndpoints(matrix, buff, width, xMin, yMin, zMin, xMax, yMax, zMax, r, g, b, a);
        RenderHelper.renderBottomFaceEndpoints(matrix, buff, width, xMin, yMin, zMin, xMax, yMax, zMax, r, g, b, a);
        RenderHelper.renderNorthFaceEndpoints(matrix, buff, width, xMin, yMin, zMin, xMax, yMax, zMax, r, g, b, a);
        RenderHelper.renderSouthFaceEndpoints(matrix, buff, width, xMin, yMin, zMin, xMax, yMax, zMax, r, g, b, a);
    }

    public static void renderTopFace(MatrixStack matrix, IVertexBuilder buff, double yMax, double xMin, double zMin, double xMax, double zMax) {
        RenderHelper.renderTopFace(matrix, buff, yMax, xMin, zMin, xMax, zMax, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void renderTopFace(MatrixStack matrix, IVertexBuilder buff, double yMax, double xMin, double zMin, double xMax, double zMax, float r, float g, float b, float a) {
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        Vector4f vector4f = new Vector4f((float)xMin, (float)yMax, (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMin, (float)yMax, (float)zMax, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMax, (float)yMax, (float)zMax, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMax, (float)yMax, (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void renderTopFaceEndpoints(MatrixStack matrix, IVertexBuilder buff, double width, double xMin, double yMin, double zMin, double xMax, double yMax, double zMax, float r, float g, float b, float a) {
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        Vector4f vector4f = new Vector4f((float)xMin, (float)yMin, (float)(zMin - width), 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMin, (float)yMin, (float)(zMin + width), 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMax, (float)yMax, (float)(zMax + width), 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMax, (float)yMax, (float)(zMax - width), 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void renderBottomFace(MatrixStack matrix, IVertexBuilder buff, double yMax, double xMin, double zMin, double xMax, double zMax, float r, float g, float b, float a) {
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        Vector4f vector4f = new Vector4f((float)xMax, (float)yMax, (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMax, (float)yMax, (float)zMax, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMin, (float)yMax, (float)zMax, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMin, (float)yMax, (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void renderBottomFaceEndpoints(MatrixStack matrix, IVertexBuilder buff, double width, double xMin, double yMin, double zMin, double xMax, double yMax, double zMax, float r, float g, float b, float a) {
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        Vector4f vector4f = new Vector4f((float)xMin, (float)yMin, (float)(zMin + width), 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMin, (float)yMin, (float)(zMin - width), 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMax, (float)yMax, (float)(zMax - width), 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMax, (float)yMax, (float)(zMax + width), 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void renderNorthFace(MatrixStack matrix, IVertexBuilder buff, double zMin, double xMin, double yMin, double xMax, double yMax, float r, float g, float b, float a) {
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        Vector4f vector4f = new Vector4f((float)xMin, (float)yMax, (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMax, (float)yMax, (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMax, (float)yMin, (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMin, (float)yMin, (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void renderNorthFaceEndpoints(MatrixStack matrix, IVertexBuilder buff, double width, double xMin, double yMin, double zMin, double xMax, double yMax, double zMax, float r, float g, float b, float a) {
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        Vector4f vector4f = new Vector4f((float)xMin, (float)(yMin + width), (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMax, (float)(yMax + width), (float)zMax, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMax, (float)(yMax - width), (float)zMax, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMin, (float)(yMin - width), (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void renderSouthFace(MatrixStack matrix, IVertexBuilder buff, double zMax, double xMin, double yMin, double xMax, double yMax, float r, float g, float b, float a) {
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        Vector4f vector4f = new Vector4f((float)xMin, (float)yMax, (float)zMax, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMin, (float)yMin, (float)zMax, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMax, (float)yMin, (float)zMax, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMax, (float)yMax, (float)zMax, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void renderSouthFaceEndpoints(MatrixStack matrix, IVertexBuilder buff, double width, double xMin, double yMin, double zMin, double xMax, double yMax, double zMax, float r, float g, float b, float a) {
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        Vector4f vector4f = new Vector4f((float)xMin, (float)(yMin + width), (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMin, (float)(yMin - width), (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMax, (float)(yMax - width), (float)zMax, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMax, (float)(yMax + width), (float)zMax, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void renderEastFace(MatrixStack matrix, IVertexBuilder buff, double xMax, double yMin, double zMin, double yMax, double zMax, float r, float g, float b, float a) {
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        Vector4f vector4f = new Vector4f((float)xMax, (float)yMax, (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMax, (float)yMax, (float)zMax, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMax, (float)yMin, (float)zMax, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMax, (float)yMin, (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void renderEastFaceEndpoints(MatrixStack matrix, IVertexBuilder buff, double width, double xMin, double yMin, double zMin, double xMax, double yMax, double zMax, float r, float g, float b, float a) {
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        Vector4f vector4f = new Vector4f((float)xMax, (float)(yMax + width), (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMax, (float)(yMax - width), (float)zMax, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMax, (float)(yMin - width), (float)zMax, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMax, (float)(yMin + width), (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void renderWestFace(MatrixStack matrix, IVertexBuilder buff, double xMin, double yMin, double zMin, double yMax, double zMax, float r, float g, float b, float a) {
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        Vector4f vector4f = new Vector4f((float)xMin, (float)yMin, (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMin, (float)yMin, (float)zMax, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMin, (float)yMax, (float)zMax, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMin, (float)yMax, (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void renderWestFaceEndpoints(MatrixStack matrix, IVertexBuilder buff, double width, double xMin, double yMin, double zMin, double xMax, double yMax, double zMax, float r, float g, float b, float a) {
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        Vector4f vector4f = new Vector4f((float)xMin, (float)(yMin + width), (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMin, (float)(yMin - width), (float)zMax, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMin, (float)(yMax - width), (float)zMax, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
        vector4f = new Vector4f((float)xMin, (float)(yMax + width), (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void renderTopFaceWithUV(MatrixStack matrix, IVertexBuilder buff, double yMax, double xMin, double zMin, double xMax, double zMax, float uMin, float uMax, float vMin, float vMax) {
        RenderHelper.renderTopFaceWithUV(matrix, buff, yMax, xMin, zMin, xMax, zMax, uMin, uMax, vMin, vMax, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void renderTopFaceWithUV(MatrixStack matrix, IVertexBuilder buff, double yMax, double xMin, double zMin, double xMax, double zMax, float uMin, float uMax, float vMin, float vMax, float r, float g, float b, float a) {
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        Vector4f vector4f = new Vector4f((float)xMin, (float)yMax, (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_225583_a_(uMin, vMin).func_181675_d();
        vector4f = new Vector4f((float)xMin, (float)yMax, (float)zMax, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_225583_a_(uMin, vMax).func_181675_d();
        vector4f = new Vector4f((float)xMax, (float)yMax, (float)zMax, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_225583_a_(uMax, vMax).func_181675_d();
        vector4f = new Vector4f((float)xMax, (float)yMax, (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_225583_a_(uMax, vMin).func_181675_d();
    }

    public static void renderBottomFaceWithUV(MatrixStack matrix, IVertexBuilder buff, double yMax, double xMin, double zMin, double xMax, double zMax, float uMin, float uMax, float vMin, float vMax, float r, float g, float b, float a) {
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        Vector4f vector4f = new Vector4f((float)xMax, (float)yMax, (float)zMax, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_225583_a_(uMax, vMax).func_181675_d();
        vector4f = new Vector4f((float)xMin, (float)yMax, (float)zMax, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_225583_a_(uMin, vMax).func_181675_d();
        vector4f = new Vector4f((float)xMin, (float)yMax, (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_225583_a_(uMin, vMin).func_181675_d();
        vector4f = new Vector4f((float)xMax, (float)yMax, (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_225583_a_(uMax, vMin).func_181675_d();
    }

    public static void renderNorthFaceWithUV(MatrixStack matrix, IVertexBuilder buff, double zMin, double xMin, double yMin, double xMax, double yMax, float uMin, float uMax, float vMin, float vMax) {
        RenderHelper.renderNorthFaceWithUV(matrix, buff, zMin, xMin, yMin, xMax, yMax, uMin, uMax, vMin, vMax, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void renderNorthFaceWithUV(MatrixStack matrix, IVertexBuilder buff, double zMin, double xMin, double yMin, double xMax, double yMax, float uMin, float uMax, float vMin, float vMax, float r, float g, float b, float a) {
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        Vector4f vector4f = new Vector4f((float)xMin, (float)yMax, (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_225583_a_(uMin, vMin).func_181675_d();
        vector4f = new Vector4f((float)xMax, (float)yMax, (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_225583_a_(uMax, vMin).func_181675_d();
        vector4f = new Vector4f((float)xMax, (float)yMin, (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_225583_a_(uMax, vMax).func_181675_d();
        vector4f = new Vector4f((float)xMin, (float)yMin, (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_225583_a_(uMin, vMax).func_181675_d();
    }

    public static void renderNorthFaceWithUVNoNormal(MatrixStack matrix, IVertexBuilder buff, double zMin, double xMin, double yMin, double xMax, double yMax, float uMin, float uMax, float vMin, float vMax, float r, float g, float b, float a) {
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        Vector4f vector4f = new Vector4f((float)xMin, (float)yMax, (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_225583_a_(uMin, vMin).func_181675_d();
        vector4f = new Vector4f((float)xMax, (float)yMax, (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_225583_a_(uMax, vMin).func_181675_d();
        vector4f = new Vector4f((float)xMax, (float)yMin, (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_225583_a_(uMax, vMax).func_181675_d();
        vector4f = new Vector4f((float)xMin, (float)yMin, (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_225583_a_(uMin, vMax).func_181675_d();
    }

    public static void renderSouthFaceWithUV(MatrixStack matrix, IVertexBuilder buff, double zMax, double xMin, double yMin, double xMax, double yMax, float uMin, float uMax, float vMin, float vMax, float r, float g, float b, float a) {
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        Vector4f vector4f = new Vector4f((float)xMin, (float)yMax, (float)zMax, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_225583_a_(uMin, vMin).func_181675_d();
        vector4f = new Vector4f((float)xMin, (float)yMin, (float)zMax, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_225583_a_(uMin, vMax).func_181675_d();
        vector4f = new Vector4f((float)xMax, (float)yMin, (float)zMax, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_225583_a_(uMax, vMax).func_181675_d();
        vector4f = new Vector4f((float)xMax, (float)yMax, (float)zMax, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_225583_a_(uMax, vMin).func_181675_d();
    }

    public static void renderEastFaceWithUV(MatrixStack matrix, IVertexBuilder buff, double xMax, double yMin, double zMin, double yMax, double zMax, float uMin, float uMax, float vMin, float vMax, float r, float g, float b, float a) {
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        Vector4f vector4f = new Vector4f((float)xMax, (float)yMax, (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_225583_a_(uMin, vMin).func_181675_d();
        vector4f = new Vector4f((float)xMax, (float)yMax, (float)zMax, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_225583_a_(uMax, vMin).func_181675_d();
        vector4f = new Vector4f((float)xMax, (float)yMin, (float)zMax, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_225583_a_(uMax, vMax).func_181675_d();
        vector4f = new Vector4f((float)xMax, (float)yMin, (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_225583_a_(uMin, vMax).func_181675_d();
    }

    public static void renderWestFaceWithUV(MatrixStack matrix, IVertexBuilder buff, double xMin, double yMin, double zMin, double yMax, double zMax, float uMin, float uMax, float vMin, float vMax, float r, float g, float b, float a) {
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        Vector4f vector4f = new Vector4f((float)xMin, (float)yMin, (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_225583_a_(uMin, vMax).func_181675_d();
        vector4f = new Vector4f((float)xMin, (float)yMin, (float)zMax, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_225583_a_(uMax, vMax).func_181675_d();
        vector4f = new Vector4f((float)xMin, (float)yMax, (float)zMax, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_225583_a_(uMax, vMin).func_181675_d();
        vector4f = new Vector4f((float)xMin, (float)yMax, (float)zMin, 1.0f);
        vector4f.func_229372_a_(matrix4f);
        buff.func_225582_a_((double)vector4f.func_195910_a(), (double)vector4f.func_195913_b(), (double)vector4f.func_195914_c()).func_227885_a_(r, g, b, a).func_225583_a_(uMin, vMin).func_181675_d();
    }

    public static void renderCubeWithUV(MatrixStack matrix, IVertexBuilder buff, double xMin, double yMin, double zMin, double xMax, double yMax, double zMax, float uMin, float uMax, float vMin, float vMax, float r, float g, float b, float a) {
        RenderHelper.renderTopFaceWithUV(matrix, buff, yMax, xMin, zMin, xMax, zMax, uMin, uMax, vMin, vMax, r, g, b, a);
        RenderHelper.renderNorthFaceWithUV(matrix, buff, zMin, xMin, yMin, xMax, yMax, uMin, uMax, vMin, vMax, r, g, b, a);
        RenderHelper.renderSouthFaceWithUV(matrix, buff, zMax, xMin, yMin, xMax, yMax, uMin, uMax, vMin, vMax, r, g, b, a);
        RenderHelper.renderEastFaceWithUV(matrix, buff, xMax, yMin, zMin, yMax, zMax, uMin, uMax, vMin, vMax, r, g, b, a);
        RenderHelper.renderWestFaceWithUV(matrix, buff, xMin, yMin, zMin, yMax, zMax, uMin, uMax, vMin, vMax, r, g, b, a);
        RenderHelper.renderBottomFaceWithUV(matrix, buff, yMin, xMin, zMin, xMax, zMax, uMin, uMax, vMin, vMax, r, g, b, a);
    }

    public static void renderCube(MatrixStack matrix, IVertexBuilder buff, double xMin, double yMin, double zMin, double xMax, double yMax, double zMax, float r, float g, float b, float a) {
        RenderHelper.renderTopFace(matrix, buff, yMax, xMin, zMin, xMax, zMax, r, g, b, a);
        RenderHelper.renderNorthFace(matrix, buff, zMin, xMin, yMin, xMax, yMax, r, g, b, a);
        RenderHelper.renderSouthFace(matrix, buff, zMax, xMin, yMin, xMax, yMax, r, g, b, a);
        RenderHelper.renderEastFace(matrix, buff, xMax, yMin, zMin, yMax, zMax, r, g, b, a);
        RenderHelper.renderWestFace(matrix, buff, xMin, yMin, zMin, yMax, zMax, r, g, b, a);
        RenderHelper.renderBottomFace(matrix, buff, yMin, xMin, zMin, xMax, zMax, r, g, b, a);
    }
}

