/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.tile;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.cap.ForgePowerCapability;
import zmaster587.libVulpes.energy.IPower;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModulePower;
import zmaster587.libVulpes.util.UniversalBattery;

public abstract class TileEntityForgeProducer
extends TileEntity
implements IModularInventory,
IEnergyStorage,
IPower,
IUniversalEnergy,
ITickableTileEntity {
    protected UniversalBattery energy;

    protected TileEntityForgeProducer(TileEntityType<?> tileEntityTypeIn, int energy) {
        super(tileEntityTypeIn);
        this.energy = new UniversalBattery(energy);
    }

    @Override
    public List<ModuleBase> getModules(int ID, PlayerEntity player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add(new ModulePower(18, 20, this.energy));
        return modules;
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return LazyOptional.of(() -> new ForgePowerCapability(this)).cast();
        }
        return super.getCapability(capability, facing);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        this.energy.write(nbt);
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.energy.readFromNBT(nbt);
    }

    @Override
    public boolean canExtract() {
        return true;
    }

    @Override
    public boolean canReceive() {
        return false;
    }

    @Override
    public boolean canConnectEnergy(Direction arg0) {
        return true;
    }

    @Override
    public int receiveEnergy(Direction from, int maxReceive, boolean simulate) {
        return this.acceptEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(Direction from, int maxExtract, boolean simulate) {
        return this.extractEnergy(maxExtract, simulate);
    }

    public boolean hasEnoughEnergyBuffer(int amt) {
        return this.getMaxEnergyStored() - this.getUniversalEnergyStored() >= amt;
    }

    public int getPowerPerOperation() {
        return 0;
    }

    public abstract boolean canGeneratePower();

    public void func_73660_a() {
        if (this.canGeneratePower()) {
            if (this.hasEnoughEnergyBuffer(this.getPowerPerOperation())) {
                if (!this.field_145850_b.field_72995_K) {
                    this.energy.acceptEnergy(this.getPowerPerOperation(), false);
                }
                this.onGeneratePower();
            } else {
                this.notEnoughBufferForFunction();
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            this.transmitPower();
        }
    }

    protected void transmitPower() {
        for (Direction facing : Direction.values()) {
            IEnergyStorage storage;
            TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(facing));
            if (tile == null || (storage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d()).orElse(null)) == null || !storage.canReceive()) continue;
            this.extractEnergy(storage.receiveEnergy(this.getUniversalEnergyStored(), false), false);
        }
    }

    public abstract void onGeneratePower();

    public void notEnoughBufferForFunction() {
    }

    @Override
    public int getEnergyStored(Direction from) {
        return this.energy.getUniversalEnergyStored();
    }

    public int getEnergyStored() {
        return this.energy.getUniversalEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(Direction from) {
        return this.energy.getMaxEnergyStored();
    }

    public boolean hasEnergy() {
        return this.energy.getUniversalEnergyStored() > 0;
    }

    @Override
    public void setEnergyStored(int value) {
        this.energy.setEnergyStored(value);
    }

    @Override
    public int extractEnergy(int amt, boolean simulate) {
        return this.energy.extractEnergy(amt, simulate);
    }

    @Override
    public int getUniversalEnergyStored() {
        return this.energy.getUniversalEnergyStored();
    }

    @Override
    public int getMaxEnergyStored() {
        return this.energy.getMaxEnergyStored();
    }

    @Override
    public void setMaxEnergyStored(int max) {
        this.energy.setEnergyStored(max);
    }

    @Override
    public int acceptEnergy(int amt, boolean simulate) {
        return this.energy.acceptEnergy(amt, simulate);
    }

    @Override
    public int receiveEnergy(int amt, boolean simulate) {
        return this.energy.acceptEnergy(amt, simulate);
    }
}

