/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.tile;

import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.cap.ForgePowerCapability;
import zmaster587.libVulpes.energy.IPower;
import zmaster587.libVulpes.tile.TileEntityMachine;
import zmaster587.libVulpes.util.UniversalBattery;

public abstract class TileEntityPowerMachine
extends TileEntityMachine
implements IPower,
IUniversalEnergy {
    protected UniversalBattery energy;

    public TileEntityPowerMachine(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        this.energy.write(nbt);
        return nbt;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return LazyOptional.of(() -> new ForgePowerCapability(this)).cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.energy.readFromNBT(nbt);
    }

    @Override
    public int receiveEnergy(Direction from, int maxReceive, boolean simulate) {
        return this.energy.acceptEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(Direction from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored(Direction from) {
        return this.energy.getUniversalEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(Direction from) {
        return this.energy.getMaxEnergyStored();
    }

    public boolean hasEnergy() {
        return this.energy.getUniversalEnergyStored() > 0;
    }

    @Override
    public void setEnergyStored(int value) {
        this.energy.setEnergyStored(value);
    }

    public void removePower(int amt) {
        this.energy.extractEnergy(amt, false);
    }

    public int getPower() {
        return this.energy.getUniversalEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(Direction arg0) {
        return true;
    }
}

