/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.tile;

import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.cap.ForgePowerCapability;
import zmaster587.libVulpes.config.CommonConfig;
import zmaster587.libVulpes.energy.IPower;
import zmaster587.libVulpes.util.UniversalBattery;

public abstract class TileEntityRFConsumer
extends TileEntity
implements IPower,
IUniversalEnergy,
ITickableTileEntity {
    protected UniversalBattery energy;

    protected TileEntityRFConsumer(TileEntityType<?> type, int energy) {
        super(type);
        this.energy = new UniversalBattery(energy);
    }

    @Override
    public boolean canExtract() {
        return false;
    }

    @Override
    public boolean canReceive() {
        return true;
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Override
    public boolean canConnectEnergy(Direction arg0) {
        return true;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return LazyOptional.of(() -> new ForgePowerCapability(this)).cast();
        }
        return super.getCapability(capability, facing);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        this.energy.write(nbt);
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.energy.readFromNBT(nbt);
    }

    @Override
    public int receiveEnergy(Direction from, int maxReceive, boolean simulate) {
        return this.acceptEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(Direction from, int maxExtract, boolean simulate) {
        return this.extractEnergy(maxExtract, simulate);
    }

    public boolean hasEnoughEnergy(int amt) {
        return this.getUniversalEnergyStored() >= amt;
    }

    public int getPowerPerOperation() {
        return 0;
    }

    public abstract boolean canPerformFunction();

    public void func_73660_a() {
        if (this.canPerformFunction()) {
            if (this.hasEnoughEnergy((int)Math.max((Double)CommonConfig.powerMult.get() * (double)this.getPowerPerOperation(), 1.0))) {
                if (!this.field_145850_b.field_72995_K) {
                    this.energy.extractEnergy(this.getPowerPerOperation(), false);
                }
                this.performFunction();
            } else {
                this.notEnoughEnergyForFunction();
            }
        }
    }

    public abstract void performFunction();

    public void notEnoughEnergyForFunction() {
    }

    @Override
    public int getEnergyStored(Direction from) {
        return this.energy.getUniversalEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(Direction from) {
        return this.energy.getMaxEnergyStored();
    }

    public boolean hasEnergy() {
        return this.energy.getUniversalEnergyStored() > 0;
    }

    @Override
    public void setEnergyStored(int value) {
        this.energy.setEnergyStored(value);
    }

    @Override
    public int extractEnergy(int amt, boolean simulate) {
        return this.energy.extractEnergy(amt, false);
    }

    @Override
    public int getUniversalEnergyStored() {
        return this.energy.getUniversalEnergyStored();
    }

    @Override
    public int getMaxEnergyStored() {
        return this.energy.getMaxEnergyStored();
    }

    @Override
    public void setMaxEnergyStored(int max) {
        this.energy.setEnergyStored(max);
    }

    @Override
    public int acceptEnergy(int amt, boolean simulate) {
        return this.energy.acceptEnergy(amt, simulate);
    }

    @Override
    public int receiveEnergy(int amt, boolean simulate) {
        return this.energy.acceptEnergy(amt, simulate);
    }
}

