/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.tile;

import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import zmaster587.libVulpes.block.BlockTile;
import zmaster587.libVulpes.inventory.modules.IProgressBar;
import zmaster587.libVulpes.tile.TileInventoriedForgeProducer;

public abstract class TileInventoriedForgePowerMachine
extends TileInventoriedForgeProducer
implements IProgressBar {
    protected int timeRemaining;
    protected int currentTime;
    protected int lastRFAmount;

    protected TileInventoriedForgePowerMachine(TileEntityType<?> tileEntityTypeIn, int energy, int invSize) {
        super(tileEntityTypeIn, energy, invSize);
    }

    @Override
    public boolean canGeneratePower() {
        return this.timeRemaining > 0;
    }

    @Override
    public void onGeneratePower() {
    }

    public int getLastAmtGenerated() {
        return this.lastRFAmount;
    }

    protected void setState(boolean state) {
        BlockState bstate = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (bstate.func_177230_c() instanceof BlockTile && (Boolean)bstate.func_177229_b((Property)BlockTile.STATE) != state) {
            this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)bstate.func_206870_a((Property)BlockTile.STATE, (Comparable)Boolean.valueOf(state)));
        }
    }

    protected void onOperationFinish() {
        this.setState(false);
    }

    @Override
    public void func_73660_a() {
        if (this.canGeneratePower()) {
            if (this.hasEnoughEnergyBuffer(this.getPowerPerOperation())) {
                this.lastRFAmount = this.getPowerPerOperation();
                if (!this.field_145850_b.field_72995_K) {
                    this.energy.acceptEnergy(this.lastRFAmount, false);
                }
                this.onGeneratePower();
                this.setState(true);
                if (this.timeRemaining < this.currentTime++) {
                    this.currentTime = 0;
                    this.timeRemaining = -1;
                    this.onOperationFinish();
                }
            } else {
                this.notEnoughBufferForFunction();
            }
        }
        this.transmitPower();
    }

    @Override
    public void notEnoughBufferForFunction() {
        this.setState(false);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("timeRemaining", this.timeRemaining);
        nbt.func_74768_a("currentTime", this.currentTime);
        return nbt;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.timeRemaining = nbt.func_74762_e("timeRemaining");
        this.currentTime = nbt.func_74762_e("currentTime");
    }

    @Override
    public float getNormallizedProgress(int id) {
        return (float)(this.timeRemaining - this.currentTime) / (float)this.timeRemaining;
    }

    @Override
    public void setProgress(int id, int progress) {
        this.currentTime = progress;
    }

    @Override
    public int getProgress(int id) {
        return this.currentTime;
    }

    @Override
    public int getTotalProgress(int id) {
        return this.timeRemaining;
    }

    @Override
    public void setTotalProgress(int id, int progress) {
        this.timeRemaining = progress;
    }
}

