/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.tile;

import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import zmaster587.libVulpes.cap.FluidCapability;
import zmaster587.libVulpes.tile.TileInventoriedRFConsumer;

public abstract class TileInventoriedRFConsumerTank
extends TileInventoriedRFConsumer
implements IFluidHandler {
    protected FluidTank tank;

    protected TileInventoriedRFConsumerTank(TileEntityType<?> type, int energy, int invSize, int tankSize) {
        super(type, energy, invSize);
        this.tank = new FluidTank(tankSize);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        CompoundNBT tanks = new CompoundNBT();
        this.tank.writeToNBT(tanks);
        nbt.func_218657_a("tank", (INBT)tanks);
        return nbt;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        if (nbt.func_74764_b("tank")) {
            this.tank.readFromNBT(nbt.func_74775_l("tank"));
        }
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
        return this.canFill(resource.getFluid()) ? this.tank.fill(resource, doFill) : 0;
    }

    public boolean canFill(Fluid fluid) {
        return true;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> new FluidCapability(this)).cast();
        }
        return super.getCapability(capability, facing);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
        return this.tank.drain(resource.getAmount(), doDrain);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public int getTanks() {
        return this.tank.getTanks();
    }

    public FluidStack getFluidInTank(int tank) {
        return this.tank.getFluidInTank(tank);
    }

    public int getTankCapacity(int tank) {
        return this.tank.getTankCapacity(tank);
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.tank.isFluidValid(tank, stack);
    }
}

