/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.tile;

import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.LibVulpesTileEntityTypes;
import zmaster587.libVulpes.interfaces.ILinkableTile;
import zmaster587.libVulpes.tile.IMultiblock;

public class TilePointer
extends TileEntity
implements IMultiblock,
ILinkableTile {
    BlockPos masterBlockPos;
    TileEntity masterBlock;

    public TilePointer() {
        super(LibVulpesTileEntityTypes.TILE_POINTER);
        this.masterBlockPos = null;
    }

    public TilePointer(BlockPos pos) {
        super(LibVulpesTileEntityTypes.TILE_POINTER);
        this.masterBlockPos = pos;
    }

    public TilePointer(TileEntityType<?> type) {
        super(type);
        this.masterBlockPos = null;
    }

    public TilePointer(TileEntityType<?> type, BlockPos pos) {
        super(type);
        this.masterBlockPos = pos;
    }

    @Override
    public boolean onLinkStart(ItemStack item, TileEntity entity, PlayerEntity player, World world) {
        TileEntity master;
        if (this.hasMaster() && (master = this.getMasterBlock()) instanceof ILinkableTile) {
            return ((ILinkableTile)master).onLinkStart(item, master, player, world);
        }
        return false;
    }

    @Override
    public boolean onLinkComplete(ItemStack item, TileEntity entity, PlayerEntity player, World world) {
        TileEntity master;
        if (this.hasMaster() && (master = this.getMasterBlock()) instanceof ILinkableTile) {
            return ((ILinkableTile)master).onLinkComplete(item, master, player, world);
        }
        return false;
    }

    public boolean allowRedstoneOutputOnSide(Direction facing) {
        return true;
    }

    public boolean isSet() {
        return this.masterBlockPos != null;
    }

    public BlockPos getMasterPos() {
        return this.masterBlockPos;
    }

    public void setBlockPos(BlockPos pos) {
        this.masterBlockPos = pos;
    }

    @Override
    public void setMasterBlock(BlockPos pos) {
        this.setComplete(pos);
    }

    public TileEntity getFinalPointedTile() {
        TileEntity pointedTile;
        try {
            pointedTile = this.field_145850_b.isAreaLoaded(this.masterBlockPos, 1) ? this.field_145850_b.func_175625_s(this.masterBlockPos) : null;
        }
        catch (NullPointerException e) {
            return null;
        }
        if (pointedTile == null) {
            return null;
        }
        if (pointedTile instanceof TilePointer) {
            try {
                return ((TilePointer)pointedTile).getFinalPointedTile();
            }
            catch (StackOverflowError e) {
                LibVulpes.logger.warn("Stack overflow has occured with tile at location " + this.func_174877_v() + ".  The game has been prevented from crashing (in theory)");
                return null;
            }
        }
        return pointedTile;
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    @Override
    public boolean hasMaster() {
        return this.isSet();
    }

    @Override
    public TileEntity getMasterBlock() {
        if (this.hasMaster()) {
            if (this.masterBlock == null || this.masterBlock.func_145837_r()) {
                this.masterBlock = this.field_145850_b.func_175625_s(this.masterBlockPos);
            }
            return this.masterBlock;
        }
        return null;
    }

    public boolean canUpdate() {
        return false;
    }

    @Override
    public void setComplete(BlockPos pos) {
        this.masterBlockPos = pos;
    }

    @Override
    public void setIncomplete() {
        this.masterBlockPos = null;
        this.masterBlock = null;
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        CompoundNBT nbtTagCompound = super.func_189515_b(nbt);
        return this.writeToNBTHelper(nbtTagCompound);
    }

    protected CompoundNBT writeToNBTHelper(CompoundNBT nbtTagCompound) {
        if (this.masterBlockPos != null) {
            nbtTagCompound.func_74768_a("masterX", this.masterBlockPos.func_177958_n());
            nbtTagCompound.func_74768_a("masterY", this.masterBlockPos.func_177956_o());
            nbtTagCompound.func_74768_a("masterZ", this.masterBlockPos.func_177952_p());
        }
        return nbtTagCompound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbtTagCompound) {
        super.func_230337_a_(state, nbtTagCompound);
        this.readFromNBTHelper(nbtTagCompound);
    }

    protected void readFromNBTHelper(CompoundNBT nbtTagCompound) {
        this.masterBlockPos = nbtTagCompound.func_74764_b("masterX") ? new BlockPos(nbtTagCompound.func_74762_e("masterX"), nbtTagCompound.func_74762_e("masterY"), nbtTagCompound.func_74762_e("masterZ")) : null;
    }
}

