/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.tile.multiblock;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.ITimeModifier;
import zmaster587.libVulpes.api.IToggleableMachine;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.api.LibvulpesGuiRegistry;
import zmaster587.libVulpes.block.BlockMeta;
import zmaster587.libVulpes.block.BlockTile;
import zmaster587.libVulpes.client.RepeatingSound;
import zmaster587.libVulpes.config.CommonConfig;
import zmaster587.libVulpes.inventory.ContainerModular;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.TextureResources;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.IProgressBar;
import zmaster587.libVulpes.inventory.modules.IToggleButton;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModulePower;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.inventory.modules.ModuleToggleSwitch;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.multiblock.TileMultiBlock;
import zmaster587.libVulpes.tile.multiblock.TileMultiblockMachine;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.MultiBattery;
import zmaster587.libVulpes.util.ZUtils;

public class TileMultiPowerConsumer
extends TileMultiBlock
implements INetworkMachine,
IModularInventory,
IProgressBar,
IToggleButton,
ITickableTileEntity,
IToggleableMachine {
    protected MultiBattery batteries = new MultiBattery();
    private float timeMultiplier = 1.0f;
    protected int completionTime = -1;
    protected int currentTime = -1;
    protected int powerPerTick;
    protected boolean enabled = false;
    protected ModuleToggleSwitch toggleSwitch = new ModuleToggleSwitch(160, 5, "", this, TextureResources.buttonToggleImage, 11, 26, this.getMachineEnabled());
    boolean hadPowerLastTick = true;
    Object soundToPlay;

    public TileMultiPowerConsumer(TileEntityType<?> type) {
        super(type);
    }

    public MultiBattery getBatteries() {
        return this.batteries;
    }

    public double getPowerMultiplier() {
        return (Double)CommonConfig.powerMult.get();
    }

    @Override
    public int getProgress(int id) {
        return this.currentTime;
    }

    @Override
    public int getTotalProgress(int id) {
        return this.completionTime;
    }

    @Override
    public void setProgress(int id, int progress) {
        this.currentTime = progress;
    }

    @Override
    public void setTotalProgress(int id, int progress) {
        this.completionTime = progress;
    }

    @Override
    public float getNormallizedProgress(int id) {
        return this.completionTime > 0 ? (float)this.currentTime / (float)this.completionTime : 0.0f;
    }

    public SoundEvent getSound() {
        return null;
    }

    public int getSoundDuration() {
        return 1;
    }

    public float getTimeMultiplierForBlock(BlockState state, TileEntity tile) {
        Collection blockTags = BlockTags.func_199896_a().func_199913_a((Object)state.func_177230_c());
        if (state.func_177230_c() instanceof ITimeModifier) {
            return ((ITimeModifier)state.func_177230_c()).getTimeMult();
        }
        if (blockTags.contains(new ResourceLocation("forge:coils/gold")) || blockTags.contains(new ResourceLocation("forge:coils/electrum"))) {
            return 0.9f;
        }
        if (blockTags.contains(new ResourceLocation("forge:coils/aluminum")) || blockTags.contains(new ResourceLocation("forge:coils/aluminium")) || blockTags.contains(new ResourceLocation("forge:coils/highvoltage"))) {
            return 0.8f;
        }
        if (blockTags.contains(new ResourceLocation("forge:coils/titanium"))) {
            return 0.75f;
        }
        if (blockTags.contains(new ResourceLocation("forge:coils/iridium"))) {
            return 0.5f;
        }
        return 1.0f;
    }

    public float getTimeMultiplier() {
        return this.timeMultiplier;
    }

    @Override
    protected void replaceStandardBlock(BlockPos newPos, BlockState state, TileEntity tile) {
        super.replaceStandardBlock(newPos, state, tile);
        this.timeMultiplier *= this.getTimeMultiplierForBlock(state, tile);
    }

    public void func_73660_a() {
        if (this.timeAlive == 0) {
            SoundEvent str;
            if (!this.field_145850_b.field_72995_K) {
                if (this.isComplete()) {
                    this.canRender = this.completeStructure = this.completeStructure(this.field_145850_b.func_180495_p(this.field_174879_c));
                }
            } else if (this.field_145850_b.field_72995_K && (str = this.getSound()) != null) {
                this.playMachineSound(str);
            }
            this.timeAlive = 1;
        }
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 1000L == 0L && !this.isComplete()) {
            this.attemptCompleteStructure(this.field_145850_b.func_180495_p(this.field_174879_c));
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
        if (this.isRunning()) {
            if (this.hasEnergy(this.requiredPowerPerTick()) || this.field_145850_b.field_72995_K && this.hadPowerLastTick) {
                this.onRunningPoweredTick();
                if (!this.field_145850_b.field_72995_K) {
                    if (!this.hadPowerLastTick) {
                        this.hadPowerLastTick = true;
                        this.func_70296_d();
                        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
                    }
                    this.useEnergy(this.usedPowerPerTick());
                }
            } else if (!this.field_145850_b.field_72995_K && this.hadPowerLastTick) {
                this.hadPowerLastTick = false;
                this.func_70296_d();
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
            }
        }
    }

    protected int requiredPowerPerTick() {
        return (int)Math.max((double)this.powerPerTick * this.getPowerMultiplier(), 1.0);
    }

    protected int usedPowerPerTick() {
        return this.requiredPowerPerTick();
    }

    protected void onRunningPoweredTick() {
        SoundEvent str;
        ++this.currentTime;
        if (!this.field_145850_b.field_72995_K || (str = this.getSound()) == null || this.field_145850_b.func_82737_E() % (long)this.getSoundDuration() == 0L) {
            // empty if block
        }
        if (this.currentTime == this.completionTime) {
            this.processComplete();
        }
    }

    protected void playMachineSound(SoundEvent str) {
        if (this.soundToPlay == null && this.field_145850_b.field_72995_K) {
            this.soundToPlay = new RepeatingSound(str, SoundCategory.BLOCKS, this);
        }
        LibVulpes.proxy.playSound(this.soundToPlay);
    }

    public void setMachineEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!this.field_145850_b.field_72995_K) {
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
    }

    public boolean getMachineEnabled() {
        return this.enabled;
    }

    @Override
    public void resetCache() {
        this.batteries.clear();
        super.resetCache();
    }

    @Override
    public void deconstructMultiBlock(World world, BlockPos destroyedPos, boolean blockBroken, BlockState state) {
        this.resetCache();
        this.completionTime = 0;
        this.currentTime = 0;
        this.enabled = false;
        this.timeMultiplier = 1.0f;
        super.deconstructMultiBlock(world, destroyedPos, blockBroken, state);
    }

    protected void processComplete() {
        this.completionTime = 0;
        this.currentTime = 0;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    @Override
    public boolean isRunning() {
        return this.completionTime > 0 && this.isComplete();
    }

    public void useEnergy(int amt) {
        this.batteries.extractEnergy(amt, false);
    }

    public boolean hasEnergy(int amt) {
        return this.batteries.getUniversalEnergyStored() >= amt;
    }

    @Override
    protected void integrateTile(TileEntity tile) {
        super.integrateTile(tile);
        for (BlockMeta block : TileMultiBlock.getMapping('P')) {
            if (block.getBlock() != this.field_145850_b.func_180495_p(tile.func_174877_v()).func_177230_c()) continue;
            this.batteries.addBattery((IUniversalEnergy)tile);
        }
    }

    @Override
    protected void writeNetworkData(CompoundNBT nbt) {
        super.writeNetworkData(nbt);
        nbt.func_74768_a("completionTime", this.completionTime);
        nbt.func_74768_a("currentTime", this.currentTime);
        nbt.func_74768_a("powerPerTick", this.powerPerTick);
        nbt.func_74757_a("enabled", this.enabled);
        if (this.timeMultiplier != 1.0f) {
            nbt.func_74776_a("timeMult", this.timeMultiplier);
        }
    }

    @Override
    protected void readNetworkData(CompoundNBT nbt) {
        super.readNetworkData(nbt);
        this.completionTime = nbt.func_74762_e("completionTime");
        this.currentTime = nbt.func_74762_e("currentTime");
        this.powerPerTick = nbt.func_74762_e("powerPerTick");
        this.enabled = nbt.func_74767_n("enabled");
        if (nbt.func_74764_b("timeMult")) {
            this.timeMultiplier = nbt.func_74760_g("timeMult");
        }
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && this.isRunning()) {
            ((BlockTile)this.func_195044_w().func_177230_c()).setBlockState(this.field_145850_b, this.field_145850_b.func_180495_p(this.func_174877_v()), this.func_174877_v(), true);
        }
    }

    @Override
    public void writeDataToNetwork(PacketBuffer out, byte id) {
        if (id == TileMultiblockMachine.NetworkPackets.POWERERROR.ordinal()) {
            out.writeBoolean(this.hadPowerLastTick);
        } else if (id == TileMultiblockMachine.NetworkPackets.TOGGLE.ordinal()) {
            out.writeBoolean(this.enabled);
        }
    }

    @Override
    public void readDataFromNetwork(PacketBuffer in, byte packetId, CompoundNBT nbt) {
        if (packetId == TileMultiblockMachine.NetworkPackets.POWERERROR.ordinal()) {
            nbt.func_74757_a("hadPowerLastTick", in.readBoolean());
        } else if (packetId == TileMultiblockMachine.NetworkPackets.TOGGLE.ordinal()) {
            nbt.func_74757_a("enabled", in.readBoolean());
        }
    }

    @Override
    public void useNetworkData(PlayerEntity player, Dist side, byte id, CompoundNBT nbt) {
        if (id == TileMultiblockMachine.NetworkPackets.POWERERROR.ordinal()) {
            this.hadPowerLastTick = nbt.func_74767_n("hadPowerLastTick");
        } else if (id == TileMultiblockMachine.NetworkPackets.TOGGLE.ordinal()) {
            this.setMachineEnabled(nbt.func_74767_n("enabled"));
            this.toggleSwitch.setToggleState(this.getMachineEnabled());
            if (!this.field_145850_b.field_72995_K) {
                PacketHandler.sendToNearby((BasePacket)new PacketMachine(this, (byte)TileMultiblockMachine.NetworkPackets.TOGGLE.ordinal()), ZUtils.getDimensionId(this.field_145850_b), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), 64.0);
            }
        }
    }

    @Override
    public List<ModuleBase> getModules(int ID, PlayerEntity player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add(new ModulePower(18, 20, this.getBatteries()));
        modules.add(this.toggleSwitch);
        modules.add(new ModuleText(140, 40, String.format("Speed:\n%.2fx", Float.valueOf(1.0f / this.getTimeMultiplier())), 0x2D2D2D));
        modules.add(new ModuleText(140, 60, String.format("Power:\n%.2fx", Float.valueOf(1.0f)), 0x2D2D2D));
        return modules;
    }

    @Override
    public String getModularInventoryName() {
        return this.getMachineName();
    }

    @Override
    public GuiHandler.guiId getModularInvType() {
        Block block = this.func_195044_w().func_177230_c();
        return block instanceof BlockTile ? ((BlockTile)block).getGuid() : GuiHandler.guiId.MODULAR;
    }

    @Override
    public void onInventoryButtonPressed(ModuleButton buttonId) {
        if (buttonId == this.toggleSwitch) {
            this.setMachineEnabled(this.toggleSwitch.getState());
            PacketHandler.sendToServer(new PacketMachine(this, (byte)TileMultiblockMachine.NetworkPackets.TOGGLE.ordinal()));
        }
    }

    @Override
    public void stateUpdated(ModuleBase module) {
        if (module == this.toggleSwitch) {
            this.setMachineEnabled(this.toggleSwitch.getState());
        }
    }

    @Override
    public boolean canInteractWithContainer(PlayerEntity entity) {
        return this.isComplete();
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.getModularInventoryName());
    }

    public Container createMenu(int ID, PlayerInventory playerInv, PlayerEntity playerEntity) {
        return new ContainerModular(LibvulpesGuiRegistry.CONTAINER_MODULAR_TILE, ID, playerEntity, this.getModules(this.getModularInvType().ordinal(), playerEntity), this, this.getModularInvType());
    }
}

