/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.tile.multiblock.hatch;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import zmaster587.libVulpes.api.LibVulpesTileEntityTypes;
import zmaster587.libVulpes.api.LibvulpesGuiRegistry;
import zmaster587.libVulpes.cap.FluidCapability;
import zmaster587.libVulpes.gui.CommonResources;
import zmaster587.libVulpes.interfaces.IInventoryUpdateCallback;
import zmaster587.libVulpes.inventory.ContainerModular;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleImage;
import zmaster587.libVulpes.inventory.modules.ModuleLiquidIndicator;
import zmaster587.libVulpes.inventory.modules.ModuleSlotArray;
import zmaster587.libVulpes.tile.TilePointer;
import zmaster587.libVulpes.tile.multiblock.TileMultiBlock;
import zmaster587.libVulpes.util.EmbeddedInventory;
import zmaster587.libVulpes.util.FluidUtils;
import zmaster587.libVulpes.util.IFluidHandlerInternal;
import zmaster587.libVulpes.util.IconResource;

public class TileFluidHatch
extends TilePointer
implements IFluidHandlerInternal,
IModularInventory,
ISidedInventory,
IInventoryUpdateCallback {
    protected FluidTank fluidTank;
    private EmbeddedInventory inventory;

    public TileFluidHatch() {
        super(LibVulpesTileEntityTypes.TILE_FLUID_INPUT_HATCH);
        this.fluidTank = new FluidTank(16000);
        this.inventory = new EmbeddedInventory(2, this);
        this.inventory.setCanInsertSlot(0, true);
        this.inventory.setCanInsertSlot(1, false);
        this.inventory.setCanExtractSlot(0, false);
        this.inventory.setCanExtractSlot(1, true);
    }

    public TileFluidHatch(int capacity) {
        super(LibVulpesTileEntityTypes.TILE_FLUID_INPUT_HATCH);
        this.fluidTank = new FluidTank(capacity);
        this.inventory = new EmbeddedInventory(2, this);
        this.inventory.setCanInsertSlot(0, true);
        this.inventory.setCanInsertSlot(1, false);
        this.inventory.setCanExtractSlot(0, false);
        this.inventory.setCanExtractSlot(1, true);
    }

    public TileFluidHatch(TileEntityType<?> type) {
        super(type);
        this.fluidTank = new FluidTank(16000);
        this.inventory = new EmbeddedInventory(2);
    }

    public TileFluidHatch(TileEntityType<?> type, int capacity) {
        super(type);
        this.fluidTank = new FluidTank(capacity);
        this.inventory = new EmbeddedInventory(2);
    }

    public boolean isOutputOnly() {
        return false;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> new FluidCapability(this)).cast();
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.inventory).cast();
        }
        return super.getCapability(capability, facing);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
        return this.fillInternal(resource, doFill);
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
        if (resource.isFluidEqual(this.fluidTank.getFluid())) {
            FluidStack fluidStack = this.fluidTank.drain(resource.getAmount(), doDrain);
            while (this.useBucket(0, this.func_70301_a(0))) {
            }
            return fluidStack;
        }
        return null;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
        return this.fluidTank.drain(maxDrain, doDrain);
    }

    @Override
    public FluidStack drainInternal(FluidStack maxDrain, IFluidHandler.FluidAction doDrain) {
        return this.drain(maxDrain, doDrain);
    }

    @Override
    public int fillInternal(FluidStack resource, IFluidHandler.FluidAction doFill) {
        int fillAmt = this.fluidTank.fill(resource, doFill);
        while (this.useBucket(0, this.func_70301_a(0))) {
        }
        if (doFill == IFluidHandler.FluidAction.EXECUTE && this.hasMaster() && this.getMasterBlock() instanceof TileMultiBlock) {
            ((TileMultiBlock)this.getMasterBlock()).onInventoryUpdated();
        }
        return fillAmt;
    }

    @Override
    public FluidStack drainInternal(int maxDrain, IFluidHandler.FluidAction doDrain) {
        return this.drain(maxDrain, doDrain);
    }

    public FluidStack getFluidInTank(int tank) {
        return this.fluidTank.getFluidInTank(tank);
    }

    public int getTankCapacity(int tank) {
        return this.fluidTank.getTankCapacity(tank);
    }

    @Override
    public List<ModuleBase> getModules(int ID, PlayerEntity player) {
        ArrayList<ModuleBase> list = new ArrayList<ModuleBase>();
        list.add(new ModuleSlotArray(45, 18, (IInventory)this, 0, 1));
        list.add(new ModuleSlotArray(45, 54, (IInventory)this, 1, 2));
        if (this.field_145850_b.field_72995_K) {
            list.add(new ModuleImage(44, 35, new IconResource(194, 0, 18, 18, CommonResources.genericBackground)));
        }
        list.add(new ModuleLiquidIndicator(27, 18, this));
        return list;
    }

    @Override
    public GuiHandler.guiId getModularInvType() {
        return GuiHandler.guiId.MODULAR;
    }

    @Override
    public String getModularInventoryName() {
        return "block.libvulpes.fluidihatch";
    }

    @Override
    public boolean canInteractWithContainer(PlayerEntity entity) {
        return true;
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amt) {
        return this.inventory.func_70298_a(slot, amt);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
        while (this.useBucket(0, this.func_70301_a(0))) {
        }
        if (this.hasMaster() && this.getMasterBlock() instanceof TileMultiBlock) {
            ((TileMultiBlock)this.getMasterBlock()).onInventoryUpdated();
        }
    }

    @Override
    public void onInventoryUpdated(int slot) {
        this.func_70299_a(slot, this.inventory.func_70301_a(slot));
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.inventory.func_94041_b(slot, stack);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        this.inventory.write(nbt);
        nbt.func_74768_a("capacity", this.fluidTank.getCapacity());
        this.fluidTank.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.inventory.readFromNBT(nbt);
        this.fluidTank = new FluidTank(nbt.func_74762_e("capacity"));
        this.fluidTank.readFromNBT(nbt);
    }

    protected boolean useBucket(int slot, ItemStack stack) {
        return FluidUtils.attemptDrainContainerIInv(this.inventory, (IFluidTank)this.fluidTank, stack, 0, 1);
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public boolean func_191420_l() {
        return this.inventory.func_191420_l();
    }

    public void func_174886_c(PlayerEntity player) {
    }

    public void func_174888_l() {
    }

    public int[] func_180463_a(Direction side) {
        return new int[]{0, 1};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        return index == 0 && this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index == 1;
    }

    public int getTanks() {
        return this.fluidTank.getTanks();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.fluidTank.isFluidValid(tank, stack);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.getModularInventoryName());
    }

    public Container createMenu(int ID, PlayerInventory playerInv, PlayerEntity playerEntity) {
        return new ContainerModular(LibvulpesGuiRegistry.CONTAINER_MODULAR_TILE, ID, playerEntity, this.getModules(this.getModularInvType().ordinal(), playerEntity), this, this.getModularInvType());
    }
}

