/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.tile.multiblock.hatch;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import zmaster587.libVulpes.api.LibVulpesTileEntityTypes;
import zmaster587.libVulpes.api.LibvulpesGuiRegistry;
import zmaster587.libVulpes.interfaces.IInventoryUpdateCallback;
import zmaster587.libVulpes.inventory.ContainerModular;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleSlotArray;
import zmaster587.libVulpes.tile.TilePointer;
import zmaster587.libVulpes.tile.multiblock.TileMultiBlock;
import zmaster587.libVulpes.util.EmbeddedInventory;

public class TileInventoryHatch
extends TilePointer
implements ISidedInventory,
IModularInventory,
IInventoryUpdateCallback {
    protected EmbeddedInventory inventory;

    public TileInventoryHatch(TileEntityType<?> type) {
        super(type);
        this.inventory = new EmbeddedInventory(0, this);
    }

    public TileInventoryHatch(TileEntityType<?> type, int invSize) {
        super(type);
        this.inventory = new EmbeddedInventory(invSize, this);
    }

    public TileInventoryHatch() {
        super(LibVulpesTileEntityTypes.TILE_INPUT_HATCH);
        this.inventory = new EmbeddedInventory(4, this);
    }

    public TileInventoryHatch(int invSize) {
        super(LibVulpesTileEntityTypes.TILE_INPUT_HATCH);
        this.inventory = new EmbeddedInventory(invSize, this);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        this.inventory.write(nbt);
        return nbt;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.inventory.readFromNBT(nbt);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.inventory).cast();
        }
        return super.getCapability(capability, facing);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amt) {
        return this.inventory.func_70298_a(slot, amt);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.setInventorySlotContentsNoUpdate(slot, stack);
        if (this.hasMaster() && this.getMasterBlock() instanceof TileMultiBlock) {
            ((TileMultiBlock)this.getMasterBlock()).onInventoryUpdated();
        }
    }

    public void setInventorySlotContentsNoUpdate(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(PlayerEntity player) {
        return player.func_70092_e((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p()) < 64.0;
    }

    public boolean func_191420_l() {
        return this.inventory.func_191420_l();
    }

    public void func_174889_b(PlayerEntity entity) {
    }

    public void func_174886_c(PlayerEntity entity) {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.inventory.func_94041_b(slot, stack);
    }

    public int[] func_180463_a(Direction side) {
        return this.inventory.func_180463_a(side);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        return this.inventory.func_180462_a(index, itemStackIn, direction);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return this.inventory.func_180461_b(index, stack, direction);
    }

    @Override
    public List<ModuleBase> getModules(int ID, PlayerEntity player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add(new ModuleSlotArray(8, 18, (IInventory)this, 0, this.func_70302_i_()));
        return modules;
    }

    @Override
    public String getModularInventoryName() {
        return null;
    }

    @Override
    public GuiHandler.guiId getModularInvType() {
        return GuiHandler.guiId.MODULAR;
    }

    @Override
    public boolean canInteractWithContainer(PlayerEntity entity) {
        return true;
    }

    public void onChunkUnloaded() {
        TileEntity tile;
        super.onChunkUnloaded();
        if (!this.field_145850_b.field_72995_K && (tile = this.getFinalPointedTile()) instanceof TileMultiBlock) {
            ((TileMultiBlock)tile).invalidateComponent(this);
        }
    }

    public ItemStack func_70304_b(int index) {
        return this.inventory.func_70304_b(index);
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }

    @Override
    public void onInventoryUpdated(int slot) {
        if (this.hasMaster() && this.getMasterBlock() instanceof TileMultiBlock) {
            ((TileMultiBlock)this.getMasterBlock()).onInventoryUpdated();
        }
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.getModularInventoryName());
    }

    public Container createMenu(int ID, PlayerInventory playerInv, PlayerEntity playerEntity) {
        return new ContainerModular(LibvulpesGuiRegistry.CONTAINER_MODULAR_TILE, ID, playerEntity, this.getModules(this.getModularInvType().ordinal(), playerEntity), this, this.getModularInvType());
    }
}

