/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.util;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemStackHandler;
import zmaster587.libVulpes.interfaces.IInventoryUpdateCallback;

public class EmbeddedInventory
extends ItemStackHandler
implements ISidedInventory {
    ItemStackHandler handler;
    IInventoryUpdateCallback tile;
    NonNullList<Boolean> slotInsert;
    NonNullList<Boolean> slotExtract;

    public EmbeddedInventory(int size) {
        this.stacks = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        this.slotInsert = NonNullList.func_191197_a((int)size, (Object)true);
        this.slotExtract = NonNullList.func_191197_a((int)size, (Object)true);
    }

    public EmbeddedInventory(int size, IInventoryUpdateCallback tile) {
        this(size);
        this.tile = tile;
    }

    public void write(CompoundNBT nbt) {
        nbt.func_74768_a("size", this.stacks.size());
        ListNBT list = new ListNBT();
        for (int i = 0; i < this.stacks.size(); ++i) {
            ItemStack stack = (ItemStack)this.stacks.get(i);
            if (stack.func_190926_b()) continue;
            CompoundNBT tag = new CompoundNBT();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            list.add((Object)tag);
        }
        nbt.func_218657_a("outputItems", (INBT)list);
        ArrayList<Byte> list2 = new ArrayList<Byte>();
        for (int i = 0; i < this.slotInsert.size(); ++i) {
            list2.add(i, (Boolean)this.slotInsert.get(i) != false ? (byte)1 : 0);
        }
        nbt.func_218657_a("slotInsert", (INBT)new ByteArrayNBT(list2));
        ArrayList<Byte> list3 = new ArrayList<Byte>();
        for (int i = 0; i < this.slotExtract.size(); ++i) {
            list3.add(i, (Boolean)this.slotExtract.get(i) != false ? (byte)1 : 0);
        }
        nbt.func_218657_a("slotExtract", (INBT)new ByteArrayNBT(list3));
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        if (this.tile != null) {
            this.tile.onInventoryUpdated(slot);
        }
    }

    public void readFromNBT(CompoundNBT nbt) {
        ListNBT list = nbt.func_150295_c("outputItems", 10);
        this.stacks = NonNullList.func_191197_a((int)Math.max(nbt.func_74762_e("size") == 0 ? 4 : nbt.func_74762_e("size"), this.stacks.size()), (Object)ItemStack.field_190927_a);
        this.handler = new ItemStackHandler(this.stacks);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT tag = list.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            this.stacks.set((int)slot, (Object)ItemStack.func_199557_a((CompoundNBT)tag));
        }
        byte[] list2 = nbt.func_74770_j("slotInsert");
        this.slotInsert = NonNullList.func_191197_a((int)list2.length, (Object)false);
        for (int i = 0; i < list2.length; ++i) {
            this.slotInsert.set(i, (Object)(list2[i] == 1 ? 1 : 0));
        }
        byte[] list3 = nbt.func_74770_j("slotExtract");
        this.slotExtract = NonNullList.func_191197_a((int)list3.length, (Object)false);
        for (int i = 0; i < list3.length; ++i) {
            this.slotExtract.set(i, (Object)(list3[i] == 1 ? 1 : 0));
        }
        if (this.slotInsert.size() == 0) {
            this.slotInsert = NonNullList.func_191197_a((int)4, (Object)false);
        }
        if (this.slotExtract.size() == 0) {
            this.slotExtract = NonNullList.func_191197_a((int)4, (Object)false);
        }
    }

    public int func_70302_i_() {
        return this.stacks.size();
    }

    public ItemStack func_70301_a(int slot) {
        if (slot >= this.stacks.size()) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)this.stacks.get(slot);
    }

    public ItemStack func_70298_a(int slot, int amt) {
        ItemStack stack = (ItemStack)this.stacks.get(slot);
        if (!stack.func_190926_b()) {
            ItemStack stack2 = stack.func_77979_a(Math.min(amt, stack.func_190916_E()));
            if (stack.func_190916_E() == 0) {
                this.stacks.set(slot, (Object)ItemStack.field_190927_a);
            }
            return stack2;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.stacks.set(slot, (Object)stack);
    }

    public int func_70297_j_() {
        return 64;
    }

    public void setCanInsertSlot(int index, boolean bool) {
        this.slotInsert.set(index, (Object)bool);
    }

    public void setCanExtractSlot(int index, boolean bool) {
        this.slotExtract.set(index, (Object)bool);
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public boolean func_191420_l() {
        for (ItemStack i : this.stacks) {
            if (i == null || i.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        return ((ItemStack)this.stacks.get(slot)).func_190926_b() || ((ItemStack)this.stacks.get(slot)).func_77969_a(item) && ((ItemStack)this.stacks.get(slot)).func_77976_d() != ((ItemStack)this.stacks.get(slot)).func_190916_E();
    }

    public int[] func_180463_a(Direction side) {
        int[] array = new int[this.stacks.size()];
        for (int i = 0; i < this.stacks.size(); ++i) {
            array[i] = i;
        }
        return array;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        return (Boolean)this.slotInsert.get(index);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return (Boolean)this.slotExtract.get(index);
    }

    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (!this.slotInsert.isEmpty() && ((Boolean)this.slotInsert.get(slot)).booleanValue()) {
            return super.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.slotExtract.isEmpty() && ((Boolean)this.slotExtract.get(slot)).booleanValue()) {
            return super.extractItem(slot, amount, simulate);
        }
        return ItemStack.field_190927_a;
    }

    public String getName() {
        return "";
    }

    public void func_70296_d() {
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = (ItemStack)this.stacks.get(index);
        this.stacks.set(index, (Object)ItemStack.field_190927_a);
        return stack;
    }

    public void func_174888_l() {
    }
}

