/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.util;

import net.minecraft.nbt.CompoundNBT;
import zmaster587.libVulpes.api.IUniversalEnergy;

public class UniversalBattery
implements IUniversalEnergy {
    private int energy;
    private int maxEnergy;

    public UniversalBattery() {
        this.maxEnergy = 0;
    }

    public UniversalBattery(int maxEnergy) {
        this.maxEnergy = maxEnergy;
    }

    @Override
    public int acceptEnergy(int maxReceive, boolean simulate) {
        if (maxReceive > this.maxEnergy - this.energy) {
            int returnAmt = this.maxEnergy - this.energy;
            if (!simulate) {
                this.energy = this.maxEnergy;
            }
            return returnAmt;
        }
        if (!simulate) {
            this.energy += maxReceive;
        }
        return maxReceive;
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate) {
        if (maxExtract > this.energy) {
            int ret = this.energy;
            if (!simulate) {
                this.energy = 0;
            }
            return ret;
        }
        if (!simulate) {
            this.energy -= maxExtract;
        }
        return maxExtract;
    }

    @Override
    public int getUniversalEnergyStored() {
        return this.energy;
    }

    @Override
    public int getMaxEnergyStored() {
        return this.maxEnergy;
    }

    @Override
    public void setMaxEnergyStored(int max) {
        this.maxEnergy = max;
    }

    @Override
    public void setEnergyStored(int energy) {
        this.energy = energy;
    }

    public void write(CompoundNBT nbt) {
        nbt.func_74768_a("energy", this.energy);
        nbt.func_74768_a("maxEnergy", this.maxEnergy);
    }

    public void readFromNBT(CompoundNBT nbt) {
        this.energy = nbt.func_74762_e("energy");
        this.maxEnergy = nbt.func_74762_e("maxEnergy");
    }

    @Override
    public boolean canReceive() {
        return true;
    }

    @Override
    public boolean canExtract() {
        return true;
    }
}

