/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.util;

import com.mojang.serialization.Lifecycle;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.Dimension;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class ZUtils {
    public static int getAverageColor(long r, long g, long b, int total) {
        return (int)(r / (long)total | g / (long)total << 8 | b / (long)total << 16);
    }

    public static boolean isBlockTag(Block block, ResourceLocation tag) {
        return BlockTags.func_199896_a().func_199913_a((Object)block).contains(tag);
    }

    public static int getDirectionFacing(float rotationYaw) {
        int l = MathHelper.func_76128_c((double)((double)(MathHelper.func_76142_g((float)rotationYaw) * 4.0f / 360.0f) + 0.5)) & 3;
        l = l == 0 ? 2 : (l == 1 ? 5 : (l == 2 ? 3 : 4));
        return l;
    }

    public static List copyRandomElements(List fromList, int maxElements) {
        LinkedList returnList = new LinkedList();
        LinkedList moveList = new LinkedList(fromList);
        Random rand = new Random(System.nanoTime());
        for (int i = 0; i < maxElements && !moveList.isEmpty(); ++i) {
            returnList.add(moveList.remove(rand.nextInt(moveList.size())));
        }
        return returnList;
    }

    public static AxisAlignedBB rotateAABB(AxisAlignedBB axis, double angleDeg) {
        double buffer;
        double angle = Math.toRadians(90.0 - angleDeg);
        double minZ = -(axis.field_72340_a * Math.sin(angle) + axis.field_72339_c * Math.cos(angle));
        double maxZ = -(axis.field_72336_d * Math.sin(angle) + axis.field_72334_f * Math.cos(angle));
        double minX = -(axis.field_72339_c * Math.sin(angle) + axis.field_72340_a * Math.cos(angle));
        double maxX = -(axis.field_72334_f * Math.sin(angle) + axis.field_72336_d * Math.cos(angle));
        if (minZ > maxZ) {
            buffer = minZ;
            minZ = maxZ;
            maxZ = buffer;
        }
        if (minX > maxZ) {
            buffer = minX;
            minX = maxX;
            maxX = buffer;
        }
        AxisAlignedBB ret = new AxisAlignedBB(minX, axis.field_72338_b, minZ, maxX, axis.field_72337_e, maxZ);
        return ret;
    }

    public static AxisAlignedBB convertLocalBBToGlobal(AxisAlignedBB local, AxisAlignedBB global, Entity e, double angle) {
        AxisAlignedBB rotatedLocal = ZUtils.rotateAABB(local, angle);
        return new AxisAlignedBB(e.func_226277_ct_() + rotatedLocal.field_72340_a, e.func_226278_cu_() + rotatedLocal.field_72338_b, e.func_226281_cx_() + rotatedLocal.field_72339_c, rotatedLocal.field_72336_d + e.func_226277_ct_(), rotatedLocal.field_72337_e + e.func_226278_cu_(), rotatedLocal.field_72334_f + e.func_226281_cx_());
    }

    public static String formatNumber(int number) {
        if (number > 999999999) {
            return (float)(number / 1000000) / 10.0f + "T";
        }
        if (number > 999999) {
            return (float)(number / 1000000) / 10.0f + "M";
        }
        if (number > 999) {
            return (float)(number / 100) / 10.0f + "K";
        }
        return String.valueOf(number);
    }

    public static boolean isInvEmpty(ItemStack[] stack) {
        boolean empty = true;
        if (stack == null) {
            return true;
        }
        for (ItemStack i : stack) {
            if (i.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public static boolean doesArrayContains(Object[] object, Object object2) {
        for (Object obj : object) {
            if (!obj.equals(object2)) continue;
            return true;
        }
        return false;
    }

    public static boolean doesArrayContains(int[] object, Object object2) {
        int[] nArray = object;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer obj = nArray[i];
            if (!((Object)obj).equals(object2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInvEmpty(IInventory stack) {
        boolean empty = true;
        if (stack == null) {
            return true;
        }
        for (int i = 0; i < stack.func_70302_i_(); ++i) {
            if (stack.func_70301_a(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public static boolean doesInvHaveRoom(ItemStack item, IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (!inv.func_70301_a(i).func_190926_b() && (!item.func_77969_a(inv.func_70301_a(i)) || inv.func_70301_a(i).func_190916_E() >= inv.func_70297_j_())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasFullStack(IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i).func_190926_b() || inv.func_70301_a(i).func_77976_d() != inv.func_70301_a(i).func_190916_E()) continue;
            return true;
        }
        return false;
    }

    public static int numEmptySlots(IInventory inv) {
        int num = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (!inv.func_70301_a(i).func_190926_b()) continue;
            ++num;
        }
        return num;
    }

    public static int numFilledSlots(IInventory inv) {
        int num = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i).func_190926_b() || inv.func_70301_a(i).func_190916_E() != inv.func_70301_a(i).func_77976_d()) continue;
            ++num;
        }
        return num;
    }

    public static void mergeInventory(ItemStack[] a, IInventory b) {
        for (int i = 0; i < a.length; ++i) {
            int firstEmtpySlot = -1;
            if (a[i] == null) continue;
            for (int slot = 0; slot < b.func_70302_i_(); ++slot) {
                if (b.func_70301_a(slot).func_190926_b()) {
                    if (firstEmtpySlot != -1) continue;
                    firstEmtpySlot = slot;
                    continue;
                }
                if (!b.func_70301_a(slot).func_77969_a(a[i])) continue;
                int maxTransfer = b.func_70297_j_() - b.func_70301_a(slot).func_190916_E();
                if (a[i].func_190916_E() < maxTransfer) {
                    b.func_70301_a(slot).func_190920_e(b.func_70301_a(slot).func_190916_E() + a[i].func_190916_E());
                    a[i] = ItemStack.field_190927_a;
                    break;
                }
                b.func_70301_a(slot).func_190920_e(b.func_70297_j_());
                a[i].func_190920_e(a[i].func_190916_E() - maxTransfer);
            }
            if (a[i].func_190926_b() || firstEmtpySlot == -1) continue;
            b.func_70299_a(firstEmtpySlot, a[i].func_77946_l());
            a[i] = ItemStack.field_190927_a;
        }
    }

    public static void mergeInventory(ItemStack a, IInventory b) {
        int firstEmtpySlot = -1;
        if (a != null) {
            for (int slot = 0; slot < b.func_70302_i_(); ++slot) {
                if (b.func_70301_a(slot).func_190926_b()) {
                    if (firstEmtpySlot != -1) continue;
                    firstEmtpySlot = slot;
                    continue;
                }
                if (!b.func_70301_a(slot).func_77969_a(a)) continue;
                int maxTransfer = b.func_70297_j_() - b.func_70301_a(slot).func_190916_E();
                if (a.func_190916_E() < maxTransfer) {
                    b.func_70301_a(slot).func_190920_e(b.func_70301_a(slot).func_190916_E() + a.func_190916_E());
                    a = ItemStack.field_190927_a;
                    break;
                }
                b.func_70301_a(slot).func_190920_e(b.func_70297_j_());
                a.func_190920_e(a.func_190916_E() - maxTransfer);
            }
            if (!a.func_190926_b() && firstEmtpySlot != -1) {
                if (a.func_190916_E() != 0) {
                    b.func_70299_a(firstEmtpySlot, a.func_77946_l());
                }
                a = ItemStack.field_190927_a;
            }
        }
    }

    public static ItemStack getFirstItemInInv(ItemStack[] i) {
        for (ItemStack stack : i) {
            if (stack.func_190926_b()) continue;
            return stack;
        }
        return null;
    }

    public static int getFirstFilledSlotIndex(IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) == ItemStack.field_190927_a) continue;
            return i;
        }
        return inv.func_70302_i_();
    }

    public static int getContinuousBlockLength(World world, Direction direction, BlockPos pos, int maxDist, Block block) {
        int dist = 0;
        for (int i = 0; i < maxDist && world.func_180495_p(new BlockPos((Vector3i)pos.func_177982_a(i * direction.func_82601_c(), i * direction.func_96559_d(), i * direction.func_82599_e()))).func_177230_c() == block; ++i) {
            dist = i + 1;
        }
        return dist;
    }

    public static int getContinuousBlockLength(World world, Direction direction, BlockPos pos, int maxDist, Block[] blocks) {
        int dist = 0;
        for (int i = 0; i < maxDist; ++i) {
            Block blockchecked = world.func_180495_p(new BlockPos((Vector3i)pos.func_177982_a(i * direction.func_82601_c(), i * direction.func_96559_d(), i * direction.func_82599_e()))).func_177230_c();
            boolean exists = false;
            for (Block b : blocks) {
                if (blockchecked != b) continue;
                exists = true;
                break;
            }
            if (!exists) break;
            dist = i + 1;
        }
        return dist;
    }

    public static boolean areOresSameTypeOreDict(ItemStack stack1, ItemStack stack2) {
        Collection item1s = ItemTags.func_199903_a().func_199913_a((Object)stack1.func_77973_b());
        Collection item2s = ItemTags.func_199903_a().func_199913_a((Object)stack2.func_77973_b());
        return item1s.stream().anyMatch(value -> item2s.contains(value));
    }

    public static ResourceLocation getDimensionIdentifier(World world) {
        if (world == null) {
            return null;
        }
        if (world.func_234923_W_() == null) {
            return null;
        }
        return world.func_234923_W_().func_240901_a_();
    }

    public static Optional<DimensionType> getDimensionFromIdentifier(ResourceLocation location) {
        return DynamicRegistries.func_239770_b_().func_230520_a_().func_241873_b(location);
    }

    public static DimensionType getDimensionType(IWorld world) {
        return world.func_230315_m_();
    }

    public static ServerWorld getWorld(ResourceLocation worldLoc) {
        RegistryKey registrykey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)worldLoc);
        return ServerLifecycleHooks.getCurrentServer().func_71218_a(registrykey);
    }

    public static boolean isWorldLoaded(ResourceLocation worldLoc) {
        RegistryKey registrykey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)worldLoc);
        return registrykey != null && ServerLifecycleHooks.getCurrentServer().func_71218_a(registrykey) != null;
    }

    public static boolean isWorldRegistered(ResourceLocation worldLoc) {
        return ZUtils.isWorldLoaded(worldLoc);
    }

    public static void unloadWorld(ResourceLocation dimId) {
        if (ZUtils.isWorldLoaded(dimId)) {
            ServerWorld world = ZUtils.getWorld(dimId);
            try {
                world.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean unregisterDimension(ResourceLocation worldLoc) {
        return false;
    }

    public static boolean registerDimension(ResourceLocation worldLoc, DimensionType type, Dimension dim) {
        if (ZUtils.getDimensionFromIdentifier(worldLoc).isPresent()) {
            return false;
        }
        RegistryKey dimRegistryKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239698_ad_, (ResourceLocation)worldLoc);
        MutableRegistry mutableregistry = DynamicRegistries.func_239770_b_().func_243612_b(Registry.field_239698_ad_);
        mutableregistry.func_218381_a(dimRegistryKey, (Object)type, Lifecycle.stable());
        return true;
    }

    public static int getDimensionId(World world) {
        return ZUtils.getDimensionType((IWorld)world).func_241513_m_();
    }

    public static void initDimension(ResourceLocation dimid) {
    }

    public static Direction rotateAround(Direction a, Direction b) {
        Vector3f newdir = new Vector3f((float)a.func_176730_m().func_177958_n(), (float)a.func_176730_m().func_177956_o(), (float)a.func_176730_m().func_177952_p());
        newdir.func_214905_a(b.func_229384_a_());
        return Direction.func_176737_a((float)newdir.func_195899_a(), (float)newdir.func_195900_b(), (float)newdir.func_195902_c());
    }

    public static enum RedstoneState {
        ON,
        OFF,
        INVERTED;


        public RedstoneState getNext() {
            int i = this.ordinal() + 1;
            if (i >= RedstoneState.values().length) {
                return RedstoneState.values()[0];
            }
            return RedstoneState.values()[i];
        }

        public RedstoneState getPrev() {
            int i = this.ordinal() - 1;
            if (i < 0) {
                return RedstoneState.values()[RedstoneState.values().length - 1];
            }
            return RedstoneState.values()[i];
        }

        public void write(CompoundNBT tag) {
            tag.func_74774_a("redstoneState", (byte)this.ordinal());
        }

        public static RedstoneState createFromNBT(CompoundNBT tag) {
            return RedstoneState.values()[tag.func_74771_c("redstoneState")];
        }
    }
}

