/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers;

import com.legobmw99.allomancy.Allomancy;
import com.legobmw99.allomancy.setup.AllomancyConfig;
import com.legobmw99.allomancy.setup.Metal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class PowersConfig {
    public static ForgeConfigSpec.IntValue max_metal_detection;
    public static ForgeConfigSpec.BooleanValue animate_selection;
    public static ForgeConfigSpec.EnumValue<SCREEN_LOC> overlay_position;
    public static ForgeConfigSpec.BooleanValue random_mistings;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> cfg_whitelist;
    public static Set<String> whitelist;
    private static ArrayList<String> defaultList;

    public static void init(ForgeConfigSpec.Builder common_builder, ForgeConfigSpec.Builder client_builder) {
        common_builder.comment("Settings for the gameplay elements of the mod").push("Gameplay");
        random_mistings = common_builder.comment("Spawn players as a random Misting").define("random_mistings", true);
        cfg_whitelist = common_builder.comment("List of registry names of items and blocks that are counted as 'metal").defineList("whitelist", PowersConfig.default_whitelist(), o -> o instanceof String);
        common_builder.pop();
        client_builder.push("Graphics");
        max_metal_detection = client_builder.comment("Maximum iron/steelsight distance").defineInRange("max_metal_distance", 15, 3, 30);
        animate_selection = client_builder.comment("Animate the selection wheel").define("animate_selection", true);
        overlay_position = client_builder.comment("Screen Overlay Position").defineEnum("overlay_position", (Enum)SCREEN_LOC.TOP_LEFT);
        client_builder.pop();
    }

    public static void refresh(ModConfig.ModConfigEvent e) {
        ModConfig cfg = e.getConfig();
        if (cfg.getSpec() == AllomancyConfig.COMMON_CONFIG) {
            PowersConfig.refresh_whitelist();
        }
    }

    private static void refresh_whitelist() {
        whitelist.clear();
        whitelist.addAll((Collection)cfg_whitelist.get());
    }

    private static List<String> default_whitelist() {
        defaultList = new ArrayList();
        PowersConfig.add(Items.field_151036_c);
        PowersConfig.add(Items.field_151006_E);
        PowersConfig.add(Items.field_151029_X);
        PowersConfig.add(Items.field_151151_aj);
        PowersConfig.add(Items.field_151167_ab);
        PowersConfig.add(Items.field_151133_ar);
        PowersConfig.add(Items.field_151129_at);
        PowersConfig.add(Items.field_151117_aB);
        PowersConfig.add(Items.field_151131_as);
        PowersConfig.add(Items.field_222089_ms);
        PowersConfig.add(Items.field_151111_aL);
        PowersConfig.add(Items.field_151033_d);
        PowersConfig.add(Items.field_151020_U);
        PowersConfig.add(Items.field_151169_ag);
        PowersConfig.add(Items.field_151028_Y);
        PowersConfig.add(Items.field_151013_M);
        PowersConfig.add(Items.field_151019_K);
        PowersConfig.add(Items.field_151136_bY);
        PowersConfig.add(Items.field_151138_bX);
        PowersConfig.add(Items.field_151022_W);
        PowersConfig.add(Items.field_151149_ai);
        PowersConfig.add(Items.field_151165_aa);
        PowersConfig.add(Items.field_151143_au);
        PowersConfig.add(Items.field_151108_aI);
        PowersConfig.add(Items.field_151140_bW);
        PowersConfig.add(Items.field_151109_aJ);
        PowersConfig.add(Items.field_151142_bV);
        PowersConfig.add(Items.field_151035_b);
        PowersConfig.add(Items.field_151005_D);
        PowersConfig.add(Items.field_151030_Z);
        PowersConfig.add(Items.field_151023_V);
        PowersConfig.add(Items.field_151171_ah);
        PowersConfig.add(Items.field_151113_aN);
        PowersConfig.add(Items.field_151011_C);
        PowersConfig.add(Items.field_151037_a);
        PowersConfig.add(Items.field_151097_aZ);
        PowersConfig.add(Items.field_151153_ao);
        PowersConfig.add(Items.field_196100_at);
        PowersConfig.add(Items.field_151150_bK);
        PowersConfig.add(Items.field_151040_l);
        PowersConfig.add(Items.field_151042_j);
        PowersConfig.add(Items.field_191525_da);
        PowersConfig.add(Items.field_151043_k);
        PowersConfig.add(Items.field_151074_bl);
        PowersConfig.add(Items.field_234759_km_);
        PowersConfig.add(Items.field_234760_kn_);
        PowersConfig.add(Items.field_234763_ls_);
        PowersConfig.add(Items.field_234764_lt_);
        PowersConfig.add(Items.field_234765_lu_);
        PowersConfig.add(Items.field_234766_lv_);
        PowersConfig.add(Items.field_234758_kU_);
        PowersConfig.add(Items.field_234756_kK_);
        PowersConfig.add(Items.field_234755_kJ_);
        PowersConfig.add(Items.field_234754_kI_);
        PowersConfig.add(Items.field_234757_kL_);
        PowersConfig.add(Blocks.field_150467_bQ);
        PowersConfig.add(Blocks.field_180400_cw);
        PowersConfig.add(Blocks.field_150454_av);
        PowersConfig.add(Blocks.field_150383_bp);
        PowersConfig.add(Blocks.field_150411_aY);
        PowersConfig.add(Blocks.field_150438_bZ);
        PowersConfig.add(Blocks.field_150332_K);
        PowersConfig.add(Blocks.field_196603_bb);
        PowersConfig.add(Blocks.field_150320_F);
        PowersConfig.add(Blocks.field_222431_lT);
        PowersConfig.add(Blocks.field_150331_J);
        PowersConfig.add(Blocks.field_150445_bS);
        PowersConfig.add(Blocks.field_150443_bT);
        PowersConfig.add(Blocks.field_150448_aq);
        PowersConfig.add(Blocks.field_150408_cc);
        PowersConfig.add(Blocks.field_150319_E);
        PowersConfig.add(Blocks.field_196552_aC);
        PowersConfig.add(Blocks.field_150339_S);
        PowersConfig.add(Blocks.field_150366_p);
        PowersConfig.add(Blocks.field_150340_R);
        PowersConfig.add(Blocks.field_150352_o);
        PowersConfig.add(Blocks.field_222432_lU);
        PowersConfig.add(Blocks.field_150447_bR);
        PowersConfig.add(Blocks.field_150473_bD);
        PowersConfig.add(Blocks.field_235334_I_);
        PowersConfig.add(Blocks.field_235366_md_);
        PowersConfig.add(Blocks.field_235397_ng_);
        PowersConfig.add(Blocks.field_235398_nh_);
        PowersConfig.add(Blocks.field_235405_no_);
        PowersConfig.add(Blocks.field_235387_nA_);
        PowersConfig.add("allomancy:vial");
        PowersConfig.add("allomancy:iron_lever");
        PowersConfig.add("allomancy:iron_button");
        PowersConfig.add("allomancy:lerasium_nugget");
        PowersConfig.add("allomancy:allomantic_grinder");
        PowersConfig.add("allomancy:coin_bag");
        PowersConfig.add("allomancy:cadmium_ore");
        PowersConfig.add("allomancy:chromium_ore");
        PowersConfig.add("allomancy:copper_ore");
        PowersConfig.add("allomancy:silver_ore");
        PowersConfig.add("allomancy:tin_ore");
        PowersConfig.add("allomancy:lead_ore");
        PowersConfig.add("allomancy:zinc_ore");
        PowersConfig.add("allomancy:cadmium_ingot");
        PowersConfig.add("allomancy:chromium_ingot");
        PowersConfig.add("allomancy:copper_ingot");
        PowersConfig.add("allomancy:silver_ingot");
        PowersConfig.add("allomancy:tin_ingot");
        PowersConfig.add("allomancy:lead_ingot");
        PowersConfig.add("allomancy:zinc_ingot");
        PowersConfig.add("allomancy:bronze_ingot");
        PowersConfig.add("allomancy:brass_ingot");
        for (Metal mt : Metal.values()) {
            if (mt == Metal.ALUMINUM) continue;
            PowersConfig.add("allomancy:" + mt.getName() + "_flakes");
        }
        PowersConfig.add("allomancy:lead_flakes");
        PowersConfig.add("allomancy:silver_flakes");
        defaultList.sort(String::compareTo);
        return defaultList;
    }

    private static void add(String s) {
        Allomancy.LOGGER.debug("Adding " + s + " to the default whitelist!");
        defaultList.add(s);
    }

    private static void add(Item i) {
        PowersConfig.add(i.getRegistryName().toString());
    }

    private static void add(Block b) {
        PowersConfig.add(b.getRegistryName().toString());
    }

    static {
        whitelist = new HashSet<String>();
    }

    public static enum SCREEN_LOC {
        TOP_RIGHT,
        BOTTOM_RIGHT,
        TOP_LEFT,
        BOTTOM_LEFT;

    }
}

