/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.util;

import com.legobmw99.allomancy.network.Network;
import com.legobmw99.allomancy.setup.Metal;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class AllomancyCapability
implements ICapabilitySerializable<CompoundNBT> {
    @CapabilityInject(value=AllomancyCapability.class)
    public static final Capability<AllomancyCapability> PLAYER_CAP = null;
    public static final ResourceLocation IDENTIFIER = new ResourceLocation("allomancy", "allomancy_data");
    private static final int[] MAX_BURN_TIME = new int[]{1800, 1800, 3600, 600, 1800, 1800, 2400, 1600, 100, 20, 300, 40, 1000, 10000, 3600, 160};
    private final boolean[] allomantic_powers;
    private final int[] burn_time;
    private final int[] metal_amounts;
    private final boolean[] burning_metals;
    private final LazyOptional<AllomancyCapability> handler = LazyOptional.of(() -> this);
    private int damange_stored;
    private String death_dimension;
    private BlockPos death_pos;
    private String spawn_dimension;
    private BlockPos spawn_pos;
    private int enhanced_time;

    public AllomancyCapability() {
        int powers = Metal.values().length;
        this.allomantic_powers = new boolean[powers];
        Arrays.fill(this.allomantic_powers, false);
        this.metal_amounts = new int[powers];
        Arrays.fill(this.metal_amounts, 0);
        this.burn_time = Arrays.copyOf(MAX_BURN_TIME, powers);
        this.burning_metals = new boolean[powers];
        Arrays.fill(this.burning_metals, false);
        this.enhanced_time = 0;
        this.damange_stored = 0;
        this.death_pos = null;
        this.spawn_pos = null;
    }

    public static void updateMetalBurnTime(AllomancyCapability capability, ServerPlayerEntity player) {
        for (Metal metal : Metal.values()) {
            if (!capability.isBurning(metal)) continue;
            if (!capability.hasPower(metal)) {
                capability.setBurning(metal, false);
                Network.sync(capability, (PlayerEntity)player);
                continue;
            }
            capability.setBurnTime(metal, capability.getBurnTime(metal) - 1);
            if (capability.getBurnTime(metal) > 0) continue;
            if (capability.getAmount(metal) <= 0) {
                capability.setBurning(metal, false);
            } else {
                capability.setAmount(metal, capability.getAmount(metal) - 1);
            }
            capability.setBurnTime(metal, MAX_BURN_TIME[metal.getIndex()]);
            Network.sync(capability, (PlayerEntity)player);
        }
    }

    public static AllomancyCapability forPlayer(Entity player) {
        return (AllomancyCapability)player.getCapability(PLAYER_CAP).orElseThrow(() -> new RuntimeException("Capability not attached!"));
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(AllomancyCapability.class, (Capability.IStorage)new Storage(), () -> null);
    }

    public boolean hasPower(Metal metal) {
        return this.allomantic_powers[metal.getIndex()];
    }

    public int getPowerCount() {
        int count = 0;
        for (boolean power : this.allomantic_powers) {
            if (!power) continue;
            ++count;
        }
        return count;
    }

    public Metal[] getPowers() {
        return (Metal[])Arrays.stream(Metal.values()).filter(this::hasPower).toArray(Metal[]::new);
    }

    public boolean isMistborn() {
        for (boolean power : this.allomantic_powers) {
            if (power) continue;
            return false;
        }
        return true;
    }

    public void setMistborn() {
        Arrays.fill(this.allomantic_powers, true);
    }

    public boolean isUninvested() {
        for (boolean power : this.allomantic_powers) {
            if (!power) continue;
            return false;
        }
        return true;
    }

    public void setUninvested() {
        Arrays.fill(this.allomantic_powers, false);
    }

    public void addPower(Metal metal) {
        this.allomantic_powers[metal.getIndex()] = true;
    }

    public void revokePower(Metal metal) {
        this.allomantic_powers[metal.getIndex()] = false;
    }

    public boolean isBurning(Metal metal) {
        return this.burning_metals[metal.getIndex()];
    }

    public void setBurning(Metal metal, boolean metalBurning) {
        this.burning_metals[metal.getIndex()] = metalBurning;
    }

    public int getAmount(Metal metal) {
        return this.metal_amounts[metal.getIndex()];
    }

    public void setAmount(Metal metal, int amt) {
        this.metal_amounts[metal.getIndex()] = amt;
    }

    public void drainMetals(Metal ... metals) {
        for (Metal mt : metals) {
            this.metal_amounts[mt.getIndex()] = 0;
            this.burn_time[mt.getIndex()] = 1;
        }
    }

    public int getDamageStored() {
        return this.damange_stored;
    }

    public void setDamageStored(int damageStored) {
        this.damange_stored = damageStored;
    }

    public void setDeathLoc(BlockPos pos, RegistryKey<World> dim) {
        this.setDeathLoc(pos, dim.func_240901_a_().toString());
    }

    protected void setDeathLoc(BlockPos pos, String dim_name) {
        this.death_pos = pos;
        this.death_dimension = dim_name;
    }

    public BlockPos getDeathLoc() {
        return this.death_pos;
    }

    public RegistryKey<World> getDeathDim() {
        if (this.death_dimension == null) {
            return null;
        }
        return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(this.death_dimension));
    }

    public void setSpawnLoc(BlockPos pos, RegistryKey<World> dim) {
        this.setSpawnLoc(pos, dim.func_240901_a_().toString());
    }

    public void setSpawnLoc(BlockPos pos, String dim_name) {
        this.spawn_pos = pos;
        this.spawn_dimension = dim_name;
    }

    public BlockPos getSpawnLoc() {
        return this.spawn_pos;
    }

    public RegistryKey<World> getSpawnDim() {
        if (this.spawn_dimension == null) {
            return null;
        }
        return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(this.spawn_dimension));
    }

    protected int getBurnTime(Metal metal) {
        return this.burn_time[metal.getIndex()];
    }

    protected void setBurnTime(Metal metal, int burnTime) {
        this.burn_time[metal.getIndex()] = burnTime;
    }

    public void decEnhanced() {
        if (this.isEnhanced()) {
            --this.enhanced_time;
        }
    }

    public boolean isEnhanced() {
        return this.enhanced_time > 0;
    }

    public void setEnhanced(int time) {
        this.enhanced_time = time;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return PLAYER_CAP.orEmpty(cap, this.handler);
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT allomancy_data = new CompoundNBT();
        CompoundNBT abilities = new CompoundNBT();
        for (Metal mt : Metal.values()) {
            abilities.func_74757_a(mt.getName(), this.hasPower(mt));
        }
        allomancy_data.func_218657_a("abilities", (INBT)abilities);
        CompoundNBT metal_storage = new CompoundNBT();
        for (Metal mt : Metal.values()) {
            metal_storage.func_74768_a(mt.getName(), this.getAmount(mt));
        }
        allomancy_data.func_218657_a("metal_storage", (INBT)metal_storage);
        CompoundNBT metal_burning = new CompoundNBT();
        for (Metal mt : Metal.values()) {
            metal_burning.func_74757_a(mt.getName(), this.isBurning(mt));
        }
        allomancy_data.func_218657_a("metal_burning", (INBT)metal_burning);
        CompoundNBT position = new CompoundNBT();
        if (this.death_pos != null) {
            position.func_74778_a("death_dimension", this.death_dimension);
            position.func_74768_a("death_x", this.death_pos.func_177958_n());
            position.func_74768_a("death_y", this.death_pos.func_177956_o());
            position.func_74768_a("death_z", this.death_pos.func_177952_p());
        }
        if (this.spawn_pos != null) {
            position.func_74778_a("spawn_dimension", this.spawn_dimension);
            position.func_74768_a("spawn_x", this.spawn_pos.func_177958_n());
            position.func_74768_a("spawn_y", this.spawn_pos.func_177956_o());
            position.func_74768_a("spawn_z", this.spawn_pos.func_177952_p());
        }
        allomancy_data.func_218657_a("position", (INBT)position);
        return allomancy_data;
    }

    public void deserializeNBT(CompoundNBT allomancy_data) {
        byte old_power;
        if (allomancy_data.func_74764_b("allomancyPower") && (old_power = allomancy_data.func_74771_c("allomancyPower")) != -1) {
            if (old_power == 8) {
                this.setMistborn();
            } else {
                this.addPower(Metal.getMetal(old_power));
            }
        }
        CompoundNBT abilities = (CompoundNBT)allomancy_data.func_74781_a("abilities");
        for (Metal mt : Metal.values()) {
            if (abilities.func_74767_n(mt.getName())) {
                this.addPower(mt);
                continue;
            }
            this.revokePower(mt);
        }
        CompoundNBT metal_storage = (CompoundNBT)allomancy_data.func_74781_a("metal_storage");
        for (Metal mt : Metal.values()) {
            this.setAmount(mt, metal_storage.func_74762_e(mt.getName()));
        }
        CompoundNBT metal_burning = (CompoundNBT)allomancy_data.func_74781_a("metal_burning");
        for (Metal mt : Metal.values()) {
            this.setBurning(mt, metal_burning.func_74767_n(mt.getName()));
        }
        CompoundNBT position = (CompoundNBT)allomancy_data.func_74781_a("position");
        if (position.func_74764_b("death_dimension")) {
            this.setDeathLoc(new BlockPos(position.func_74762_e("death_x"), position.func_74762_e("death_y"), position.func_74762_e("death_z")), position.func_74779_i("death_dimension"));
        }
        if (position.func_74764_b("spawn_dimension")) {
            this.setSpawnLoc(new BlockPos(position.func_74762_e("spawn_x"), position.func_74762_e("spawn_y"), position.func_74762_e("spawn_z")), position.func_74779_i("spawn_dimension"));
        }
    }

    public static class Storage
    implements Capability.IStorage<AllomancyCapability> {
        public INBT writeNBT(Capability<AllomancyCapability> capability, AllomancyCapability instance, Direction side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<AllomancyCapability> capability, AllomancyCapability instance, Direction side, INBT nbt) {
            if (nbt instanceof CompoundNBT) {
                instance.deserializeNBT((CompoundNBT)nbt);
            }
        }
    }
}

