/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Set;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.deadly.DeadlyLoot;
import shadows.apotheosis.deadly.DeadlyModuleClient;
import shadows.apotheosis.deadly.affix.AffixEvents;
import shadows.apotheosis.deadly.affix.LootRarity;
import shadows.apotheosis.deadly.affix.recipe.AffixShardingRecipe;
import shadows.apotheosis.deadly.config.DeadlyConfig;
import shadows.apotheosis.deadly.gen.BossDungeonFeature;
import shadows.apotheosis.deadly.gen.BossDungeonFeature2;
import shadows.apotheosis.deadly.gen.RogueSpawnerFeature;
import shadows.apotheosis.deadly.gen.TomeTowerFeature;
import shadows.apotheosis.deadly.gen.TroveFeature;
import shadows.apotheosis.deadly.objects.AffixTomeItem;
import shadows.apotheosis.deadly.objects.BossSpawnerBlock;
import shadows.apotheosis.deadly.objects.BossSummonerItem;
import shadows.apotheosis.deadly.objects.RarityShardItem;
import shadows.apotheosis.deadly.reload.AffixLootManager;
import shadows.apotheosis.deadly.reload.BossArmorManager;
import shadows.apotheosis.deadly.reload.BossItemManager;
import shadows.apotheosis.deadly.reload.RandomSpawnerManager;
import shadows.apotheosis.util.NameHelper;
import shadows.placebo.config.Configuration;
import shadows.placebo.recipe.RecipeHelper;

public class DeadlyModule {
    public static final Logger LOGGER = LogManager.getLogger((String)"Apotheosis : Deadly");
    public static final EnumMap<LootRarity, RarityShardItem> RARITY_SHARDS = new EnumMap(LootRarity.class);
    public static final EnumMap<LootRarity, AffixTomeItem> RARITY_TOMES = new EnumMap(LootRarity.class);
    public static final boolean DEBUG = false;

    @SubscribeEvent
    public void preInit(Apotheosis.ApotheosisConstruction e) {
        MinecraftForge.EVENT_BUS.register((Object)new AffixEvents());
        MinecraftForge.EVENT_BUS.addListener(this::reloads);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, this::onBiomeLoad);
        MinecraftForge.EVENT_BUS.addListener(this::reload);
    }

    @SubscribeEvent
    public void init(FMLCommonSetupEvent e) {
        this.reload(null);
        DeadlyLoot.init();
        LootRarity[] vals = LootRarity.values();
        for (int i = 0; i < vals.length - 1; ++i) {
            RecipeHelper.addRecipe((IRecipe)new AffixShardingRecipe(new ResourceLocation("apotheosis", "affix_sharding_" + vals[i].name().toLowerCase(Locale.ROOT)), vals[i]));
            Apotheosis.HELPER.addShapeless((Object)new ItemStack((IItemProvider)RARITY_SHARDS.get((Object)vals[i]), 2), new Object[]{new ItemStack((IItemProvider)RARITY_SHARDS.get((Object)vals[i + 1]))});
        }
        RecipeHelper.addRecipe((IRecipe)new AffixShardingRecipe(new ResourceLocation("apotheosis", "affix_sharding_" + LootRarity.ANCIENT.name().toLowerCase(Locale.ROOT)), LootRarity.ANCIENT));
    }

    @SubscribeEvent
    public void register(RegistryEvent.Register<Feature<?>> e) {
        e.getRegistry().register((IForgeRegistryEntry)((Feature)BossDungeonFeature.INSTANCE.setRegistryName("boss_dungeon")));
        e.getRegistry().register((IForgeRegistryEntry)((Feature)BossDungeonFeature2.INSTANCE.setRegistryName("boss_dungeon_2")));
        e.getRegistry().register((IForgeRegistryEntry)((Feature)RogueSpawnerFeature.INSTANCE.setRegistryName("rogue_spawner")));
        e.getRegistry().register((IForgeRegistryEntry)((Feature)TroveFeature.INSTANCE.setRegistryName("trove")));
        e.getRegistry().register((IForgeRegistryEntry)((Feature)TomeTowerFeature.INSTANCE.setRegistryName("tome_tower")));
    }

    @SubscribeEvent
    public void items(RegistryEvent.Register<Item> e) {
        e.getRegistry().register((IForgeRegistryEntry)((Item)new BossSummonerItem(new Item.Properties().func_200917_a(1).func_200916_a(Apotheosis.APOTH_GROUP)).setRegistryName("boss_summoner")));
        for (LootRarity r : LootRarity.values()) {
            RarityShardItem shard = new RarityShardItem(r, new Item.Properties().func_200916_a(Apotheosis.APOTH_GROUP));
            shard.setRegistryName(r.name().toLowerCase(Locale.ROOT) + "_shard");
            e.getRegistry().register((IForgeRegistryEntry)shard);
            RARITY_SHARDS.put(r, shard);
        }
        for (LootRarity r : LootRarity.values()) {
            AffixTomeItem tome = new AffixTomeItem(r, new Item.Properties().func_200916_a(Apotheosis.APOTH_GROUP));
            tome.setRegistryName(r.name().toLowerCase(Locale.ROOT) + "_tome");
            e.getRegistry().register((IForgeRegistryEntry)tome);
            RARITY_TOMES.put(r, tome);
        }
    }

    @SubscribeEvent
    public void blocks(RegistryEvent.Register<Block> e) {
        e.getRegistry().register((IForgeRegistryEntry)((Block)new BossSpawnerBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(-1.0f).func_222380_e().func_226896_b_()).setRegistryName("boss_spawner")));
    }

    @SubscribeEvent
    public void tiles(RegistryEvent.Register<TileEntityType<?>> e) {
        e.getRegistry().register((IForgeRegistryEntry)((TileEntityType)new TileEntityType(BossSpawnerBlock.BossSpawnerTile::new, (Set)ImmutableSet.of((Object)((Object)ApotheosisObjects.BOSS_SPAWNER)), null).setRegistryName("boss_spawn_tile")));
    }

    @SubscribeEvent
    public void serializers(RegistryEvent.Register<IRecipeSerializer<?>> e) {
        e.getRegistry().register((IForgeRegistryEntry)((IRecipeSerializer)AffixShardingRecipe.SERIALIZER.setRegistryName(new ResourceLocation("apotheosis", "affix_sharding"))));
    }

    @SubscribeEvent
    public void client(FMLClientSetupEvent e) {
        e.enqueueWork(DeadlyModuleClient::init);
    }

    public void reloads(AddReloadListenerEvent e) {
        e.addListener((IFutureReloadListener)AffixLootManager.INSTANCE);
        e.addListener((IFutureReloadListener)BossArmorManager.INSTANCE);
        e.addListener((IFutureReloadListener)BossItemManager.INSTANCE);
        e.addListener((IFutureReloadListener)RandomSpawnerManager.INSTANCE);
    }

    public void onBiomeLoad(BiomeLoadingEvent e) {
        ConfiguredFeature bossFeat = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)BossDungeonFeature.INSTANCE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_242733_d(128)).func_242728_a()).func_242731_b(DeadlyConfig.bossDungeonAttempts);
        ConfiguredFeature bossFeat2 = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)BossDungeonFeature2.INSTANCE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_242733_d(128)).func_242728_a()).func_242731_b(DeadlyConfig.bossDungeonAttempts);
        ConfiguredFeature spwFeat = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)RogueSpawnerFeature.INSTANCE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_242733_d(256)).func_242728_a()).func_242731_b(DeadlyConfig.rogueSpawnerAttempts);
        ConfiguredFeature troveFeat = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)TroveFeature.INSTANCE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_242733_d(64)).func_242728_a()).func_242731_b(DeadlyConfig.troveAttempts);
        ConfiguredFeature ttFeat = (ConfiguredFeature)TomeTowerFeature.INSTANCE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_243996_g).func_242729_a(DeadlyConfig.tomeTowerChance);
        this.registerAll(bossFeat, bossFeat2, spwFeat, troveFeat, ttFeat);
        if (!DeadlyConfig.BIOME_BLACKLIST.contains(e.getName())) {
            e.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, bossFeat).func_242513_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, bossFeat2).func_242513_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, spwFeat);
            e.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, troveFeat);
            if (Apotheosis.enableEnch && DeadlyConfig.tomeTowerChance > 0) {
                e.getGeneration().func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, ttFeat);
            }
        }
    }

    void registerAll(ConfiguredFeature<?, ?> ... feats) {
        for (ConfiguredFeature<?, ?> f : feats) {
            WorldGenRegistries.func_243664_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)f.field_222737_a.getRegistryName(), f);
        }
    }

    public void reload(Apotheosis.ApotheosisReloadEvent e) {
        DeadlyConfig.config = new Configuration(new File(Apotheosis.configDir, "deadly.cfg"));
        Configuration nameConfig = new Configuration(new File(Apotheosis.configDir, "names.cfg"));
        DeadlyConfig.loadConfigs();
        NameHelper.load(nameConfig);
        if (e == null && DeadlyConfig.config.hasChanged()) {
            DeadlyConfig.config.save();
        }
        if (e == null && nameConfig.hasChanged()) {
            nameConfig.save();
        }
    }

    public static void debugLog(BlockPos pos, String name) {
    }
}

